/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.TextComponent;

public class TextField
extends TextComponent {
    private String _delimiter = null;
    private static CharColor __delimiterDefaultColors = new CharColor(7, 0, 0);
    private CharColor _delimiterColors = this.getDelimiterDefaultColors();

    public TextField(int width, String text) {
        super(width, 1, text);
    }

    public TextField(int width) {
        super(width, 1);
    }

    public TextField() {
        this(-1);
    }

    public void setText(String text) {
        if (text == null) {
            super.setText(text);
        } else if (text.indexOf("\n") != -1) {
            super.setText(text.substring(0, text.indexOf("\n")));
        } else {
            super.setText(text);
        }
    }

    protected static String getDefaultDelimiter() {
        return "|";
    }

    public void setDelimiter(char c) {
        char[] chars = new char[]{c};
        this._delimiter = new String(chars);
    }

    private String getDelimiterString() {
        if (this._delimiter == null) {
            return new String("|");
        }
        return this._delimiter;
    }

    public CharColor getDelimiterDefaultColors() {
        return __delimiterDefaultColors;
    }

    public CharColor getDelimiterColors() {
        return this._delimiterColors;
    }

    public void setDelimiterColors(CharColor colors) {
        this._delimiterColors = colors;
    }

    protected Rectangle getTextRectangle() {
        Rectangle result = (Rectangle)this.getSize().clone();
        result.setLocation(this.getAbsoluteX() + 1, this.getAbsoluteY());
        result.setWidth(result.getWidth() - 2);
        return result;
    }

    protected void doPaint() {
        super.doPaint();
        Toolkit.printString(this.getDelimiterString(), this.getAbsoluteX(), this.getAbsoluteY(), this.getDelimiterColors());
        Toolkit.printString(this.getDelimiterString(), this.getAbsoluteX() + this.getSize().getWidth() - 1, this.getAbsoluteY(), this.getDelimiterColors());
    }

    protected Rectangle getPreferredSize() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }

    protected boolean handleInput(InputChar ch) {
        boolean filter;
        boolean bl = filter = ch.getCode() == InputChar.KEY_UP || ch.getCode() == InputChar.KEY_DOWN || ch.getCode() == InputChar.KEY_NPAGE || ch.getCode() == InputChar.KEY_PPAGE || ch.getCode() == InputChar.KEY_END || ch.getCode() == InputChar.KEY_HOME || !ch.isSpecialCode() && ch.getCharacter() == '\n' || !ch.isSpecialCode() && ch.getCharacter() == '\r';
        if (!filter) {
            return super.handleInput(ch);
        }
        return false;
    }
}

