/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.ArrayList;
import jcurses.event.ValueChangedEvent;
import jcurses.event.ValueChangedListener;
import jcurses.event.ValueChangedListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Paging;
import jcurses.util.Rectangle;
import jcurses.widgets.Widget;

public class TextComponent
extends Widget {
    private int _width = 0;
    private int _height = 0;
    private int _cursPosX = 0;
    private int _cursPosY = 0;
    private int _firstChar = 0;
    private int _firstLine = 0;
    StringBuffer _text = new StringBuffer("");
    ArrayList _lines = new ArrayList();
    ArrayList _lineLengths = new ArrayList();
    private static CharColor __textComponentDefaultColors = new CharColor(5, 0);
    private static CharColor __focusedTextComponentDefaultColors = new CharColor(4, 7, 1);
    private CharColor _focusedTextComponentColors = this.getFocusedTextComponentDefaultColors();
    private static CharColor __cursorDefaultColors = new CharColor(0, 7);
    private CharColor _cursorColors = this.getCursorDefaultColors();
    private ValueChangedListenerManager _listenerManager = new ValueChangedListenerManager();

    public TextComponent(int width, int height, String text) {
        this._width = width;
        this._height = height;
        this.setText(text);
    }

    public TextComponent(int width, int height) {
        this(width, height, "");
    }

    public TextComponent() {
        this(-1, -1, "");
    }

    public TextComponent(String text) {
        this(-1, -1, text);
    }

    protected int getWidth() {
        return this._width;
    }

    protected int getHeight() {
        return this._height;
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean dispatchEvent) {
        text = text == null ? "" : text;
        this._text = new StringBuffer(text);
        this.updateText(dispatchEvent);
        this.reset();
    }

    private void reset() {
        this._cursPosX = 0;
        this._cursPosY = 0;
        this._firstChar = 0;
        this._firstLine = 0;
    }

    public String getText() {
        return this._text.toString();
    }

    private void updateText() {
        this.updateText(true);
    }

    protected int getTextX() {
        return this._firstChar;
    }

    protected int getTextY() {
        return this._firstLine;
    }

    protected int getTextHeight() {
        return this._lines.size();
    }

    protected int getTextWidth() {
        int result = 0;
        for (int i = 0; i < this._lineLengths.size(); ++i) {
            int value = (Integer)this._lineLengths.get(i);
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    private void updateText(boolean dispatchEvent) {
        this._lines.clear();
        this._lineLengths.clear();
        String text = this._text.toString();
        int pos = 0;
        while (text.indexOf("\n", pos) != -1) {
            this._lines.add(new Integer(pos));
            this._lineLengths.add(new Integer(text.indexOf("\n", pos) - pos));
            pos = text.indexOf("\n", pos) + 1;
        }
        if (pos < text.length()) {
            this._lines.add(new Integer(pos));
            this._lineLengths.add(new Integer(this._text.length() - pos));
        }
        if (this._lines.size() == 0) {
            this._lines.add(new Integer(0));
            this._lineLengths.add(new Integer(0));
        } else if (text.endsWith("\n")) {
            this._lines.add(new Integer(text.length()));
            this._lineLengths.add(new Integer(0));
        }
        if (dispatchEvent) {
            this._listenerManager.handleEvent(new ValueChangedEvent(this));
        }
    }

    protected void drawAdditionalThings() {
    }

    protected void refreshAdditionalThings() {
    }

    protected Rectangle getTextRectangle() {
        Rectangle result = this.getSize();
        result.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        result.setHeight(result.getHeight());
        return result;
    }

    private int getVisibleHeight() {
        return this.getTextRectangle().getHeight();
    }

    private Rectangle getTextRectangle(int firstLine) {
        Rectangle rect = this.getTextRectangle();
        int y = firstLine - this._firstLine >= 0 ? firstLine - this._firstLine : 0;
        rect.setLocation(rect.getX(), rect.getY() + y);
        rect.setHeight(rect.getHeight() - y);
        return rect;
    }

    private Rectangle getLineRectangle(int firstLine) {
        Rectangle rect = this.getTextRectangle();
        int y = firstLine - this._firstLine >= 0 ? firstLine - this._firstLine : 0;
        rect.setLocation(rect.getX(), rect.getY() + y);
        rect.setHeight(1);
        return rect;
    }

    private int getFirstLineNumber() {
        return this._firstLine;
    }

    private int getFirstCharNumber() {
        return this._firstChar;
    }

    public CharColor getDefaultColors() {
        return __textComponentDefaultColors;
    }

    public CharColor getFocusedTextComponentDefaultColors() {
        return __focusedTextComponentDefaultColors;
    }

    public CharColor getFocusedTextComponentColors() {
        return this._focusedTextComponentColors;
    }

    public void setTextComponentColors(CharColor colors) {
        this._focusedTextComponentColors = colors;
    }

    public CharColor getCursorDefaultColors() {
        return __cursorDefaultColors;
    }

    public CharColor getCursorColors() {
        return this._cursorColors;
    }

    public void setCursorColors(CharColor colors) {
        this._cursorColors = colors;
    }

    protected Rectangle getPreferredSize() {
        return new Rectangle(this._width, this._height);
    }

    private void drawCursor() {
        char c = this.getCharacterAtCursorPosition();
        this.drawChar(this._cursPosX, this._cursPosY, this.getCursorColors(), c);
    }

    private void drawChar(int x, int y, CharColor colors, char c) {
        int x1 = x - this._firstChar;
        int y1 = y - this._firstLine;
        String toPrint = c == '\u0000' ? " " : this.replaceTextLineForPrinting("" + c);
        Toolkit.printString(toPrint, this.getTextRectangle().getX() + x1, this.getTextRectangle().getY() + y1, colors);
    }

    private void drawText(int index) {
        int begin;
        for (int i = begin = (firstLine = this.getFirstLineNumber()) > index ? firstLine : index; i < this._lines.size(); ++i) {
            this.drawLine(i);
        }
    }

    private void drawLine(int index) {
        Rectangle rect = this.getTextRectangle();
        CharColor colors = this.hasFocus() ? this.getFocusedTextComponentColors() : this.getColors();
        int firstLine = this.getFirstLineNumber();
        int firstChar = this.getFirstCharNumber();
        int pos = (Integer)this._lines.get(index);
        int length = (Integer)this._lineLengths.get(index);
        if (firstChar < length && index - firstLine < rect.getHeight()) {
            int length2 = length - firstChar;
            int length3 = length2 > rect.getWidth() ? rect.getWidth() : length2;
            Toolkit.printString(this.replaceTextLineForPrinting(this._text.substring(pos + firstChar, pos + firstChar + length3)), rect.getX(), rect.getY() + index - firstLine, colors);
        }
    }

    private String getLine(int index) {
        if (index > this._lines.size()) {
            return null;
        }
        int pos = (Integer)this._lines.get(index);
        int length = (Integer)this._lineLengths.get(index);
        return this._text.substring(pos, pos + length);
    }

    private void drawText() {
        this.drawText(0);
    }

    private Paging getPaging() {
        return new Paging(this.getVisibleHeight(), this.getTextHeight());
    }

    private int getPageNumber(int index) {
        return this.getPaging().getPageNumber(index);
    }

    private int getPageSize() {
        return this.getPaging().getPageSize();
    }

    private int getCurrentPageNumber() {
        return this.getPageNumber(this._cursPosY);
    }

    int getPageStartIndex(int pageNumber) {
        return this.getPaging().getPageStartIndex(pageNumber);
    }

    int getPageEndIndex(int pageNumber) {
        return this.getPaging().getPageEndIndex(pageNumber);
    }

    int getCurrentPageOffset() {
        return this.getPaging().getPageOffset(this._cursPosY);
    }

    private void drawBox(Rectangle rect) {
        CharColor colors = this.hasFocus() ? this.getFocusedTextComponentColors() : this.getColors();
        Toolkit.drawRectangle(rect, colors);
    }

    private void drawBox() {
        this.drawBox(this.getTextRectangle());
    }

    private void changeColors() {
        Rectangle rect = this.getTextRectangle();
        CharColor colors = this.hasFocus() ? this.getFocusedTextComponentColors() : this.getColors();
        Toolkit.changeColors(rect, colors);
    }

    protected void doPaint() {
        this.drawBox();
        this.drawText();
        if (this.hasFocus()) {
            this.drawCursor();
        }
    }

    protected boolean isFocusable() {
        return true;
    }

    protected void doRepaint() {
        this.doPaint();
    }

    private char getCharacterAtCursorPosition() {
        char result = '\u0000';
        if (this._text.length() > 0) {
            String line = this.getLine(this._cursPosY);
            result = this._cursPosX < line.length() ? line.charAt(this._cursPosX) : (char)'\u0000';
        }
        return result;
    }

    private boolean isTextChanged(int x, int y) {
        return this._firstChar != x || this._firstLine != y;
    }

    private boolean isCursorChanged(int x, int y) {
        return this._cursPosX != x || this._cursPosY != y;
    }

    private void redrawAfterCursorMove(int bCursorPosX, int bCursorPosY, int bFirstChar, int bFirstLine, char bChar) {
        if (this.isTextChanged(bFirstChar, bFirstLine)) {
            this.paint();
        } else if (this.isCursorChanged(bCursorPosX, bCursorPosY)) {
            this.redrawOldChar(bCursorPosX, bCursorPosY, bChar);
            this.drawCursor();
        }
    }

    private void redrawOldChar(int bCursorPosX, int bCursorPosY, char bChar) {
        CharColor colors = this.hasFocus() ? this.getFocusedTextComponentColors() : this.getColors();
        this.drawChar(bCursorPosX, bCursorPosY, colors, bChar);
    }

    private void redrawAfterTextChange(int bCursorPosX, int bCursorPosY, int bFirstChar, int bFirstLine) {
        if (this.isTextChanged(bFirstChar, bFirstLine)) {
            this.paint();
        } else if (this.isCursorChanged(bCursorPosX, bCursorPosY)) {
            int y = Math.min(this._cursPosY, bCursorPosY);
            this.drawBox(this.getTextRectangle(y));
            this.drawText(y);
            this.drawCursor();
            this.refreshAdditionalThings();
        }
    }

    private void redrawLine(int index) {
        this.drawBox(this.getLineRectangle(index));
        this.drawLine(index);
        this.drawCursor();
        this.refreshAdditionalThings();
    }

    protected String replaceTextLineForPrinting(String line) {
        return line;
    }

    protected boolean handleInput(InputChar ch) {
        int bCursorPosX = this._cursPosX;
        int bCursorPosY = this._cursPosY;
        int bFirstChar = this._firstChar;
        int bFirstLine = this._firstLine;
        char bChar = this.getCharacterAtCursorPosition();
        if (ch.getCode() == InputChar.KEY_RIGHT) {
            this.setCursorLocation(this._cursPosX + 1, this._cursPosY);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_LEFT) {
            this.setCursorLocation(this._cursPosX - 1, this._cursPosY);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_UP) {
            this.setCursorLocation(this._cursPosX, this._cursPosY - 1);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_DOWN) {
            this.setCursorLocation(this._cursPosX, this._cursPosY + 1);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_HOME) {
            this.setCursorLocation(this._cursPosX, 0);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_END) {
            this.setCursorLocation(this._cursPosX, this.getTextHeight() - 1);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_NPAGE) {
            int newYPos = 0;
            newYPos = this.getCurrentPageNumber() < this.getPageSize() - 1 ? this.getPaging().getIndexByPageOffset(this.getCurrentPageNumber() + 1, this.getCurrentPageOffset()) : this.getTextHeight() - 1;
            this.setCursorLocation(this._cursPosX, newYPos, true);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
            return true;
        }
        if (ch.getCode() == InputChar.KEY_PPAGE) {
            int newYPos = 0;
            newYPos = this.getCurrentPageNumber() > 0 ? this.getPaging().getIndexByPageOffset(this.getCurrentPageNumber() - 1, this.getCurrentPageOffset()) : 0;
            this.setCursorLocation(this._cursPosX, newYPos, true);
            this.redrawAfterCursorMove(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine, bChar);
        } else {
            if (ch.getCode() == InputChar.KEY_BACKSPACE) {
                this.deleteCharBeforeCursorLocation();
                if (this._cursPosX == 0) {
                    if (this._cursPosY > 0) {
                        int y = this._cursPosY - 1;
                        if (y < 0) {
                            y = 0;
                        }
                        int x = (Integer)this._lineLengths.get(y);
                        this.setCursorLocation(x, y);
                        this.redrawAfterTextChange(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine);
                    }
                } else {
                    this.setCursorLocation(this._cursPosX - 1, this._cursPosY);
                    this.redrawLine(this._cursPosY);
                }
                return true;
            }
            if (!ch.isSpecialCode()) {
                char c = ch.getCharacter();
                this.insertCharAtCursorLocation(c);
                if (c == '\n') {
                    this.setCursorLocation(0, this._cursPosY + 1);
                    this.redrawAfterTextChange(bCursorPosX, bCursorPosY, bFirstChar, bFirstLine);
                } else {
                    this.setCursorLocation(this._cursPosX + 1, this._cursPosY);
                    this.redrawLine(this._cursPosY);
                }
                return true;
            }
        }
        return false;
    }

    protected void focus() {
        this.changeColors();
        this.drawCursor();
    }

    protected void unfocus() {
        this.changeColors();
        this.redrawOldChar(this._cursPosX, this._cursPosY, this.getCharacterAtCursorPosition());
    }

    public void setCursorLocation(int x, int y) {
        this.setCursorLocation(x, y, false);
    }

    private void setCursorLocation(int x, int y, boolean pageAlignment) {
        this._cursPosY = y < 0 ? 0 : (y >= this._lines.size() ? this._lines.size() - 1 : y);
        int length = (Integer)this._lineLengths.get(this._cursPosY);
        this._cursPosX = x < 0 ? 0 : (x >= length ? length : x);
        int n = this._cursPosY = this._cursPosY < 0 ? 0 : this._cursPosY;
        if (this._firstChar > this._cursPosX) {
            this._firstChar = this._cursPosX;
        } else if (this._firstChar < this._cursPosX - this.getTextRectangle().getWidth() + 1) {
            this._firstChar = this._cursPosX - this.getTextRectangle().getWidth() + 1;
        }
        if (pageAlignment) {
            this._firstLine = this.getPageStartIndex(this.getPageNumber(this._cursPosY));
        } else if (this._firstLine > this._cursPosY) {
            this._firstLine = this._cursPosY;
        } else if (this._firstLine < this._cursPosY - this.getTextRectangle().getHeight() + 1) {
            this._firstLine = this._cursPosY - this.getTextRectangle().getHeight() + 1;
        }
    }

    private void insertCharAtCursorLocation(char c) {
        int pos = (Integer)this._lines.get(this._cursPosY) + this._cursPosX;
        this._text.insert(pos, c);
        this.updateText();
    }

    private void deleteCharBeforeCursorLocation() {
        int pos = (Integer)this._lines.get(this._cursPosY) + this._cursPosX;
        if (pos > 0) {
            this._text.deleteCharAt(pos - 1);
        }
        this.updateText();
    }

    private static String escapeString(String text) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                buf.append("\\n");
                continue;
            }
            if (c == '\r') {
                buf.append("\\r");
                continue;
            }
            if (c == '\t') {
                buf.append("\\t");
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public void addListener(ValueChangedListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(ValueChangedListener listener) {
        this._listenerManager.removeListener(listener);
    }
}

