/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.system.CharColor;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.IScrollable;
import jcurses.widgets.ScrollbarPainter;
import jcurses.widgets.TextComponent;

public class TextArea
extends TextComponent
implements IScrollable {
    private ScrollbarPainter _scrollbars = null;
    private static CharColor __borderDefaultColors = new CharColor(7, 0, 0);
    private CharColor _borderColors = this.getBorderDefaultColors();
    private static CharColor __scrollbarDefaultColors = new CharColor(0, 7, 1);
    private CharColor _scrollbarColors = this.getScrollbarDefaultColors();

    public TextArea(int width, int height, String text) {
        super(width, height, text);
        this._scrollbars = new ScrollbarPainter(this);
    }

    public TextArea(int width, int height) {
        this(width, height, null);
    }

    public TextArea() {
        this(-1, -1);
    }

    public CharColor getBorderDefaultColors() {
        return __borderDefaultColors;
    }

    public CharColor getBorderColors() {
        return this._borderColors;
    }

    public void setBorderColors(CharColor colors) {
        this._borderColors = colors;
    }

    public CharColor getScrollbarDefaultColors() {
        return __scrollbarDefaultColors;
    }

    public CharColor getScrollbarColors() {
        return this._scrollbarColors;
    }

    public void setScrollbarColors(CharColor colors) {
        this._scrollbarColors = colors;
    }

    protected Rectangle getTextRectangle() {
        Rectangle result = (Rectangle)this.getSize().clone();
        result.setLocation(this.getAbsoluteX() + 1, this.getAbsoluteY() + 1);
        result.setWidth(result.getWidth() - 2);
        result.setHeight(result.getHeight() - 2);
        return result;
    }

    protected void doPaint() {
        super.doPaint();
        Toolkit.drawBorder(this.getBorderRectangle(), this.getBorderColors());
        this.drawAdditionalThings();
    }

    protected void drawAdditionalThings() {
        this._scrollbars.paint();
    }

    protected void refreshAdditionalThings() {
        this._scrollbars.refresh();
    }

    protected Rectangle getPreferredSize() {
        return new Rectangle(this.getWidth(), this.getHeight());
    }

    private int getVisibleTextWidth() {
        return this.getSize().getWidth() - 2;
    }

    private int getVisibleTextHeight() {
        return this.getSize().getHeight() - 2;
    }

    public boolean hasHorizontalScrollbar() {
        return true;
    }

    public boolean hasVerticalScrollbar() {
        return true;
    }

    public Rectangle getBorderRectangle() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        return rect;
    }

    public float getHorizontalScrollbarOffset() {
        if (this.getTextWidth() <= 0 || this.getTextWidth() <= this.getVisibleTextWidth()) {
            return 0.0f;
        }
        return (float)this.getTextX() / (float)this.getTextWidth();
    }

    public float getHorizontalScrollbarLength() {
        if (this.getTextWidth() <= 0 || this.getTextWidth() <= this.getVisibleTextWidth()) {
            return 0.0f;
        }
        return (float)this.getVisibleTextWidth() / (float)this.getTextWidth();
    }

    public float getVerticalScrollbarOffset() {
        if (this.getTextHeight() <= 0 || this.getTextHeight() <= this.getVisibleTextHeight()) {
            return 0.0f;
        }
        return (float)this.getTextY() / (float)this.getTextHeight();
    }

    public float getVerticalScrollbarLength() {
        if (this.getTextHeight() <= 0 || this.getTextHeight() <= this.getVisibleTextHeight()) {
            return 0.0f;
        }
        return (float)this.getVisibleTextHeight() / (float)this.getTextHeight();
    }
}

