/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.StringTokenizer;
import jcurses.system.CharColor;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.Widget;

public class Label
extends Widget {
    private String _label = null;
    private static CharColor __labelDefaultColors = new CharColor(7, 0);

    public CharColor getDefaultColors() {
        return __labelDefaultColors;
    }

    public Label(String label, CharColor colors) {
        this._label = label != null ? label : "";
        this.setColors(colors);
    }

    public Label(String label) {
        this(label, null);
    }

    protected Rectangle getPreferredSize() {
        if (this._label.indexOf("\n") == -1) {
            return new Rectangle(this._label.length(), 1);
        }
        StringTokenizer tokenizer = new StringTokenizer(this._label, "\n");
        int width = 0;
        int height = 0;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            ++height;
            if (token.length() <= width) continue;
            width = token.length();
        }
        height = height == 0 ? 1 : height;
        return new Rectangle(width, height);
    }

    protected void doPaint() {
        Rectangle rect = (Rectangle)this.getSize().clone();
        rect.setLocation(this.getAbsoluteX(), this.getAbsoluteY());
        Toolkit.printString(this._label, rect, this.getColors());
    }

    protected void doRepaint() {
        this.doPaint();
    }
}

