/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.util.Rectangle;

class Grid {
    int[] _widths;
    int[] _heights;

    Grid(Rectangle rect, int width, int height) {
        if (rect.getWidth() / width < 1 || rect.getHeight() / height < 1) {
            throw new RuntimeException(" the grid is to fine: " + rect.getWidth() + ":" + rect.getHeight() + ":" + width + ":" + height);
        }
        this._widths = new int[width];
        this._heights = new int[height];
        this.fillArray(this._widths, rect.getWidth(), width);
        this.fillArray(this._heights, rect.getHeight(), height);
    }

    private void fillArray(int[] array, int rectWidth, int width) {
        int mod = rectWidth % width;
        int cellWidth = rectWidth / width;
        for (int i = 0; i < width; ++i) {
            if (mod > 0) {
                array[i] = cellWidth + 1;
                --mod;
                continue;
            }
            array[i] = cellWidth;
        }
    }

    Rectangle getRectangle(int x, int y, int width, int height) {
        return new Rectangle(this.getWidth(this._widths, 0, x), this.getWidth(this._heights, 0, y), this.getWidth(this._widths, x, x + width), this.getWidth(this._heights, y, y + height));
    }

    private int getWidth(int[] array, int begin, int end) {
        int width = 0;
        for (int i = begin; i < end; ++i) {
            width += array[i];
        }
        return width;
    }
}

