/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import jcurses.util.Rectangle;
import jcurses.widgets.DefaultLayoutConstraint;
import jcurses.widgets.LayoutManager;
import jcurses.widgets.Widget;
import jcurses.widgets.WidgetContainer;
import jcurses.widgets.WidgetsConstants;

public class DefaultLayoutManager
implements LayoutManager,
WidgetsConstants {
    private WidgetContainer _father = null;

    public void bindToContainer(WidgetContainer container) {
        if (this._father != null) {
            throw new RuntimeException("Already bound!!!");
        }
        this._father = container;
    }

    public void unbindFromContainer() {
        this._father = null;
    }

    public void layout(Widget widget, Object constraint) {
        if (!(constraint instanceof DefaultLayoutConstraint)) {
            throw new RuntimeException("unknown constraint: " + constraint.getClass().getName());
        }
        DefaultLayoutConstraint cstr = (DefaultLayoutConstraint)constraint;
        Rectangle prefSize = widget.getPreferredSize();
        int prefWidth = prefSize.getWidth();
        int prefHeight = prefSize.getHeight();
        if (prefWidth <= 0) {
            prefWidth = cstr.width;
        }
        if (prefHeight <= 0) {
            prefHeight = cstr.height;
        }
        int width = 0;
        int height = 0;
        if (prefWidth < cstr.width) {
            widget.setX(this.getAlignedCoordinate(prefWidth, cstr.width, cstr.x, cstr.horizontalConstraint));
            width = prefWidth;
        } else {
            widget.setX(cstr.x);
            width = cstr.width;
        }
        if (prefHeight < cstr.height) {
            widget.setY(this.getAlignedCoordinate(prefHeight, cstr.height, cstr.y, cstr.verticalConstraint));
            height = prefHeight;
        } else {
            widget.setY(cstr.y);
            height = cstr.height;
        }
        widget.setSize(new Rectangle(width, height));
    }

    private int getAlignedCoordinate(int prefG, int contG, int contC, int alignment) {
        alignment = alignment == 4 ? 0 : (alignment == 1 || alignment == 3 ? 1 : 2);
        int result = 0;
        result = alignment == 2 ? contC : (alignment == 1 ? contC + contG - prefG : contC + (contG - prefG) / 2);
        return result;
    }

    public void addWidget(Widget widget, int x, int y, int width, int height, int verticalConstraint, int horizontalConstraint) {
        this._father.addWidget(widget, new DefaultLayoutConstraint(x, y, width, height, horizontalConstraint, verticalConstraint));
    }

    public void removeWidget(Widget widget) {
        this._father.removeWidget(widget);
    }
}

