/*
 * Decompiled with CFR 0.152.
 */
package jcurses.widgets;

import java.util.Vector;
import jcurses.event.ActionEvent;
import jcurses.event.ActionListener;
import jcurses.event.ActionListenerManager;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.Toolkit;
import jcurses.util.Rectangle;
import jcurses.widgets.Widget;

public class Button
extends Widget {
    private ActionListenerManager _listenerManager = new ActionListenerManager();
    private static CharColor __buttonDefaultColors = new CharColor(7, 0);
    private String _label = null;
    private static CharColor __focusedButtonDefaultColors = new CharColor(4, 7, 1);
    private CharColor _focusedButtonColors = this.getFocusedButtonDefaultColors();
    private static CharColor __shortCutDefaultColors = new CharColor(7, 1);
    private CharColor _shortCutColors = this.getShortCutDefaultColors();
    private static InputChar __actionChar = new InputChar('\n');
    private InputChar _shortCut = null;

    public CharColor getDefaultColors() {
        return __buttonDefaultColors;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label;
    }

    private CharColor getFocusedButtonDefaultColors() {
        return __focusedButtonDefaultColors;
    }

    public CharColor getFocusedButtonColors() {
        return this._focusedButtonColors;
    }

    public void setFocusedButtonColors(CharColor colors) {
        this._focusedButtonColors = colors;
    }

    private CharColor getShortCutDefaultColors() {
        return __shortCutDefaultColors;
    }

    public CharColor getShortCutColors() {
        return this._shortCutColors;
    }

    public void setShortCutColors(CharColor colors) {
        this._shortCutColors = colors;
    }

    public Button(String label) {
        this._label = label;
    }

    protected Rectangle getPreferredSize() {
        return new Rectangle(this._label.length() + 4, 1);
    }

    protected void doPaint() {
        Rectangle rect = this.getRectangle();
        String text = "< " + this._label + " >";
        CharColor colors = this.hasFocus() ? this.getFocusedButtonColors() : this.getColors();
        Toolkit.printString(text, rect, colors);
        if (!this.hasFocus()) {
            this.drawShortCutIfNeeded();
        }
    }

    private void drawShortCutIfNeeded() {
        InputChar shortCut = this.getShortCut();
        if (shortCut != null) {
            int index;
            String c = shortCut.toString();
            if (this._label != null && (index = this._label.toLowerCase().indexOf(c.toLowerCase())) != -1) {
                String c1 = this._label.substring(index, index + 1);
                Toolkit.printString(c1, this.getAbsoluteX() + index + 2, this.getAbsoluteY(), this.getShortCutColors());
            }
        }
    }

    protected Vector getShortCutsList() {
        if (this.getShortCut() == null) {
            return null;
        }
        Vector<InputChar> result = new Vector<InputChar>();
        result.add(this.getShortCut());
        return result;
    }

    protected boolean isFocusable() {
        return true;
    }

    protected void doRepaint() {
        this.doPaint();
    }

    protected boolean handleInput(InputChar ch) {
        if (ch.equals(__actionChar) || this.getShortCut() != null && this.getShortCut().equals(ch)) {
            this.doAction();
            return true;
        }
        return false;
    }

    private void changeColors() {
        CharColor colors = this.hasFocus() ? this.getFocusedButtonColors() : this.getColors();
        Toolkit.changeColors(this.getRectangle(), colors);
    }

    protected void focus() {
        this.changeColors();
    }

    protected void unfocus() {
        this.changeColors();
    }

    public void addListener(ActionListener listener) {
        this._listenerManager.addListener(listener);
    }

    public void removeListener(ActionListener listener) {
        this._listenerManager.removeListener(listener);
    }

    private void doAction() {
        this._listenerManager.handleEvent(new ActionEvent(this));
    }

    public void setShortCut(char c) {
        this._shortCut = new InputChar(c);
    }

    private InputChar getShortCut() {
        return this._shortCut;
    }
}

