/*
 * Decompiled with CFR 0.152.
 */
package jcurses.util;

import jcurses.system.CharColor;
import jcurses.system.Toolkit;

public class ScrollbarUtils {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final CharColor __color = new CharColor(0, 7, 1);

    public static void drawScrollBar(int start, int end, int cst, float firstPart, float lastPart, int alignment) {
        if (firstPart == 0.0f && lastPart == 0.0f) {
            return;
        }
        int length = end - start + 1;
        float barLength2 = (float)(1.0 - (double)firstPart - (double)lastPart) * (float)length;
        int barLength = Math.round(barLength2);
        barLength = barLength == 0 ? 1 : barLength;
        int firstIntervall = Math.round(firstPart * (float)length);
        while (barLength + firstIntervall > length) {
            --firstIntervall;
        }
        if (lastPart == 0.0f) {
            firstIntervall = length - barLength;
        }
        if (alignment == 0) {
            Toolkit.drawHorizontalThickLine(start + firstIntervall, cst, start + firstIntervall + barLength - 1, __color);
        } else {
            Toolkit.drawVerticalThickLine(cst, start + firstIntervall, start + firstIntervall + barLength - 1, __color);
        }
    }
}

