/*
 * Decompiled with CFR 0.152.
 */
package jcurses.util;

public class Paging {
    private int _pageSize = 0;
    private int _size = 0;

    public Paging(int pageSize, int size) {
        this._pageSize = pageSize;
        this._size = size;
    }

    public int getPageNumber(int index) {
        int result = 0;
        if (index <= 0) {
            result = 0;
        } else if (this._pageSize == 1) {
            result = index;
        } else {
            if (this._size - index - 1 < this._pageSize) {
                index = this._size - 1;
            }
            result = (index + 1) / this._pageSize + ((index + 1) % this._pageSize > 0 ? 1 : 0) - 1;
        }
        return result;
    }

    public int getPageSize() {
        return this.getPageNumber(this._size) + 1;
    }

    public int getPageStartIndex(int pageNumber) {
        int result = Math.max(0, this.getPageEndIndex(pageNumber) - this._pageSize + 1);
        return result;
    }

    public int getPageEndIndex(int pageNumber) {
        int result = Math.min(this._size - 1, (pageNumber + 1) * this._pageSize - 1);
        return result;
    }

    public int getPageOffset(int index) {
        return index - this.getPageStartIndex(this.getPageNumber(index));
    }

    public int getIndexByPageOffset(int pageNumber, int pageOffset) {
        int startIndex = this.getPageStartIndex(pageNumber);
        int index = Math.min(this._size, startIndex + pageOffset);
        if (this.getPageNumber(index) != pageNumber) {
            index = startIndex;
        }
        return index;
    }
}

