/*
 * Decompiled with CFR 0.152.
 */
package jcurses.system;

import java.awt.Point;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import jcurses.system.CharColor;
import jcurses.system.InputChar;
import jcurses.system.LinePart;
import jcurses.util.Rectangle;

public class Toolkit {
    public static final short CORNER_UNDER_LINE = 0;
    public static final short CORNER_OVER_LINE = 1;
    public static final short LL_CORNER = 2;
    public static final short LR_CORNER = 3;
    public static final short UL_CORNER = 4;
    public static final short UR_CORNER = 5;
    static final int VERTICAL = 0;
    static final int HORIZONTAL = 1;
    private static long[] __attributes = new long[]{0L, 0L, 0L};
    private static short[] __basicColors = new short[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static short[][] __colorpairs = new short[8][8];
    private static Hashtable __clips;
    private static short __maxColorPairNumber;
    private static String __encoding;
    private static byte[] __bytes;

    public static void setClipRectangle(Rectangle clipRect) {
        ArrayList<Rectangle> clips = (ArrayList<Rectangle>)__clips.get(Thread.currentThread());
        if (clips == null) {
            clips = new ArrayList<Rectangle>();
            __clips.put(Thread.currentThread(), clips);
        }
        clips.add(clipRect);
    }

    public static void unsetClipRectangle() {
        ArrayList clips = (ArrayList)__clips.get(Thread.currentThread());
        if (clips == null) {
            return;
        }
        if (clips.size() > 0) {
            clips.remove(clips.size() - 1);
        }
        if (clips.size() == 0) {
            __clips.remove(Thread.currentThread());
        }
    }

    private static Rectangle getCurrentClipRectangle() {
        ArrayList clips = (ArrayList)__clips.get(Thread.currentThread());
        if (clips == null || clips.size() == 0) {
            return null;
        }
        Rectangle result = (Rectangle)clips.get(0);
        for (int i = 1; i < clips.size(); ++i) {
            Rectangle temp = (Rectangle)clips.get(i);
            if (!(result = result.intersection(temp)).isEmpty()) continue;
            return result;
        }
        return result;
    }

    private static String getLibraryPath() {
        String url = "";
        url = "." + File.separator;
        String[] fileNames = new File(url).list();
        boolean found = false;
        for (int i = 0; i < fileNames.length; ++i) {
            String name = fileNames[i];
            if (!Toolkit.isPlatformSupport(name)) continue;
            url = new File(url, name).getAbsolutePath();
            found = true;
            break;
        }
        if (!found) {
            throw new RuntimeException("couldn't find jcurses library");
        }
        return url;
    }

    public static boolean isPlatformSupport(String name) {
        return Toolkit.isWindowsPlatform() ? name.trim().startsWith("libjcurses") && name.trim().toLowerCase().indexOf("dll") != -1 : name.trim().startsWith("libjcurses") && name.trim().toLowerCase().indexOf("so") != -1;
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    private static void fillColorPairs() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Toolkit.__colorpairs[i][j] = -1;
            }
        }
    }

    private static native void fillAttributes(long[] var0);

    private static native void fillBasicColors(short[] var0);

    static short[] getBasicColors() {
        return __basicColors;
    }

    private static native void initColorPair(short var0, short var1, short var2);

    private static native int computeChtype(short var0);

    static int computeChtype(CharColor ch) {
        short number = Toolkit.getColorPairNumber(ch);
        if (number == -1) {
            number = Toolkit.addColorPairNumber(ch);
        }
        return Toolkit.computeChtype(number);
    }

    private static short getColorPairNumber(CharColor ch) {
        if (!Toolkit.hasColors()) {
            return ch.getBlackWhiteAttribute();
        }
        short background = ch.getBackground();
        short foreground = ch.getForeground();
        return __colorpairs[background][foreground];
    }

    private static short addColorPairNumber(CharColor ch) {
        short background = __basicColors[ch.getBackground()];
        short foreground = __basicColors[ch.getForeground()];
        Toolkit.__colorpairs[ch.getBackground()][ch.getForeground()] = __maxColorPairNumber = (short)(__maxColorPairNumber + 1);
        Toolkit.initColorPair(background, foreground, __maxColorPairNumber);
        return __maxColorPairNumber;
    }

    public static native void startPainting();

    public static native void endPainting();

    public static native int getScreenWidth();

    public static native int getScreenHeight();

    public static boolean hasColors() {
        return Toolkit.hasColorsAsInteger() != 0;
    }

    private static native int hasColorsAsInteger();

    public static native void init();

    public static native void shutdown();

    public static void clearScreen(CharColor color) {
        Toolkit.clearScreen(Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
    }

    private static native void clearScreen(short var0, long var1);

    public static void drawRectangle(Rectangle rect, CharColor color) {
        Rectangle clipRect = Toolkit.getCurrentClipRectangle();
        if (clipRect != null) {
            rect = rect.intersection(clipRect);
        }
        if (!rect.isEmpty()) {
            Toolkit.drawRectangle(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    public static void drawRectangle(int x, int y, int width, int height, CharColor color) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Toolkit.drawRectangle(rect, color);
    }

    private static native void drawRectangle(int var0, int var1, int var2, int var3, short var4, long var5);

    private static boolean between(int begin, int end, int pos) {
        return begin <= pos && end >= pos;
    }

    private static LinePart getLinePart(int begin, int end, int alignment, int position, Rectangle clipRect) {
        LinePart result = null;
        if (begin > end) {
            int tmp = end;
            end = begin;
            begin = tmp;
        }
        result = clipRect == null ? new LinePart(begin, end, alignment) : (alignment == 0 && !Toolkit.between(clipRect.getX(), clipRect.getX() + clipRect.getWidth() - 1, position) ? new LinePart() : (alignment == 1 && !Toolkit.between(clipRect.getY(), clipRect.getY() + clipRect.getHeight() - 1, position) ? new LinePart() : (alignment == 0 ? new LinePart(Math.max(clipRect.getY(), begin), Math.min(clipRect.getY() + clipRect.getHeight() - 1, end), alignment) : new LinePart(Math.max(clipRect.getX(), begin), Math.min(clipRect.getX() + clipRect.getWidth() - 1, end), alignment))));
        return result;
    }

    public static void drawHorizontalThickLine(int startX, int startY, int endX, CharColor color) {
        LinePart part = Toolkit.getLinePart(startX, endX, 1, startY, Toolkit.getCurrentClipRectangle());
        if (!part.isEmpty()) {
            Toolkit.drawHorizontalThickLine(part._begin, startY, part._end, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    private static native void drawHorizontalThickLine(int var0, int var1, int var2, short var3, long var4);

    public static void drawVerticalThickLine(int startX, int startY, int endY, CharColor color) {
        LinePart part = Toolkit.getLinePart(startY, endY, 0, startX, Toolkit.getCurrentClipRectangle());
        if (!part.isEmpty()) {
            Toolkit.drawVerticalThickLine(startX, part._begin, part._end, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    private static native void drawVerticalThickLine(int var0, int var1, int var2, short var3, long var4);

    public static void drawHorizontalLine(int startX, int startY, int endX, CharColor color) {
        LinePart part = Toolkit.getLinePart(startX, endX, 1, startY, Toolkit.getCurrentClipRectangle());
        if (!part.isEmpty()) {
            Toolkit.drawHorizontalLine(part._begin, startY, part._end, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    private static native void drawHorizontalLine(int var0, int var1, int var2, short var3, long var4);

    public static void drawVerticalLine(int startX, int startY, int endY, CharColor color) {
        LinePart part = Toolkit.getLinePart(startY, endY, 0, startX, Toolkit.getCurrentClipRectangle());
        if (!part.isEmpty()) {
            Toolkit.drawVerticalLine(startX, part._begin, part._end, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    private static native void drawVerticalLine(int var0, int var1, int var2, short var3, long var4);

    private static Point getCornerCenterPoint(int startX, int startY, int endX, int endY, short alignment) {
        int x = 0;
        int y = 0;
        y = alignment == 0 ? Math.min(startY, endY) : Math.max(startY, endY);
        x = y == startY ? endX : startX;
        return new Point(x, y);
    }

    private static short getCornerChar(int startX, int startY, int endX, int endY, short alignment) {
        int cornerX = Math.min(startX, endX);
        int cornerY = startX == cornerX ? startY : endY;
        int otherX = startX == cornerX ? endX : startX;
        int otherY = startX == cornerX ? endY : startY;
        short result = 0;
        result = cornerY < otherY ? (alignment == 0 ? (short)5 : 2) : (alignment == 0 ? (short)4 : 3);
        return result;
    }

    public static void drawCorner(int startX, int startY, int endX, int endY, CharColor color, short alignment) {
        Rectangle clipRect = Toolkit.getCurrentClipRectangle();
        if (clipRect == null) {
            Toolkit.drawCorner(startX, startY, endX, endY, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()], alignment);
        } else {
            Point center = Toolkit.getCornerCenterPoint(startX, startY, endX, endY, alignment);
            if (alignment == 0 || alignment == 1) {
                LinePart verticalPart = null;
                LinePart horizontalPart = null;
                if (startX == center.x) {
                    int endY2 = startY < center.y ? center.y - 1 : center.y + 1;
                    verticalPart = new LinePart(startY, endY2, center.x, 0);
                    int endX2 = endX < center.x ? center.x - 1 : center.x + 1;
                    horizontalPart = new LinePart(endX, endX2, center.y, 1);
                } else {
                    int endY3 = endY < center.y ? center.y - 1 : center.y + 1;
                    verticalPart = new LinePart(endY, endY3, center.x, 0);
                    int endX3 = startX < center.x ? center.x - 1 : center.x + 1;
                    horizontalPart = new LinePart(startX, endX3, center.y, 1);
                }
                Toolkit.drawHorizontalLine(horizontalPart._begin, horizontalPart._position, horizontalPart._end, color);
                Toolkit.drawVerticalLine(verticalPart._position, verticalPart._begin, verticalPart._end, color);
            }
            if (clipRect.inside(center.x, center.y)) {
                if (alignment != 0 && alignment != 1) {
                    Toolkit.drawCorner(center.x, center.y, center.x, center.y, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()], alignment);
                } else {
                    short newAlignment = Toolkit.getCornerChar(startX, startY, endX, endY, alignment);
                    Toolkit.drawCorner(center.x, center.y, center.x, center.y, Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()], newAlignment);
                }
            }
        }
    }

    private static native void drawCorner(int var0, int var1, int var2, int var3, short var4, long var5, short var7);

    public static void drawBorder(Rectangle rect, CharColor color) {
        Toolkit.drawBorder(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), color);
    }

    public static void drawBorder(int x, int y, int width, int height, CharColor color) {
        Toolkit.drawCorner(x + 1, y, x + width - 1, y + height - 2, color, (short)0);
        Toolkit.drawCorner(x, y + 1, x + width - 2, y + height - 1, color, (short)1);
        Toolkit.drawCorner(x, y, x, y, color, (short)4);
        Toolkit.drawCorner(x + width - 1, y + height - 1, x + width - 1, y + height - 1, color, (short)3);
    }

    public static void setEncoding(String encoding) {
        __encoding = encoding;
    }

    public static String getEncoding() {
        return __encoding;
    }

    private static void initEncoding() {
        if (Toolkit.isWindows()) {
            Toolkit.setEncoding("CP850");
        }
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    public static void printString(String text, Rectangle rect, CharColor color) {
        Rectangle clipRect = Toolkit.getCurrentClipRectangle();
        if (clipRect != null) {
            Rectangle newRect = rect.intersection(clipRect);
            if (!newRect.isEmpty()) {
                Toolkit.printClippedString(rect, newRect, text, color);
            }
        } else {
            Toolkit.printStringWithoutClipping(text, rect, color);
        }
    }

    private static void printStringWithoutClipping(String text, Rectangle rect, CharColor color) {
        byte[] bytes = null;
        if (__encoding == null) {
            bytes = text.getBytes();
        } else {
            try {
                bytes = text.getBytes(__encoding);
            }
            catch (UnsupportedEncodingException e) {
                __encoding = null;
                bytes = text.getBytes();
            }
        }
        Toolkit.printString(bytes, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
    }

    private static List getLines(String text, int maxWidth) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                String line = buffer.toString();
                if (line.length() > maxWidth) {
                    list.add(line.substring(0, maxWidth));
                    list.add(line.substring(maxWidth, line.length()));
                } else {
                    list.add(line);
                }
                buffer = new StringBuffer();
                continue;
            }
            if (c == '\r') continue;
            buffer.append(c);
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list;
    }

    private static void printClippedString(Rectangle oldRect, Rectangle newRect, String text, CharColor color) {
        List lines = Toolkit.getLines(text, oldRect.getWidth());
        int beginY = Math.max(oldRect.getY(), newRect.getY());
        int endY = Math.min(oldRect.getY() + oldRect.getHeight() - 1, newRect.getY() + newRect.getHeight() - 1);
        if (lines.size() > 0) {
            for (int i = 0; i < lines.size(); ++i) {
                if (i + oldRect.getY() < beginY || i + oldRect.getY() < beginY) continue;
                String line = (String)lines.get(i);
                int beginPart = 0;
                if (oldRect.getX() < newRect.getX()) {
                    beginPart = newRect.getX() - oldRect.getX();
                }
                if (beginPart >= line.length()) continue;
                if ((line = line.substring(beginPart, line.length())).length() > newRect.getWidth()) {
                    line = line.substring(0, newRect.getWidth());
                }
                Rectangle paintRect = new Rectangle(newRect.getX(), oldRect.getY() + i, line.length(), 1);
                Toolkit.printStringWithoutClipping(line, paintRect, color);
            }
        }
    }

    public static void printString(String text, int x, int y, CharColor color) {
        Toolkit.printString(text, x, y, text.length(), 1, color);
    }

    public static void printString(String text, int x, int y, int width, int height, CharColor color) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Toolkit.printString(text, rect, color);
    }

    private static native void printString(byte[] var0, int var1, int var2, int var3, int var4, short var5, long var6);

    public static synchronized InputChar readCharacter() {
        int code = Toolkit.readByte();
        return new InputChar(code);
    }

    private static synchronized native int readByte();

    static native int getSpecialKeyCode(int var0);

    public static void changeColors(Rectangle rect, CharColor color) {
        Rectangle clipRect = Toolkit.getCurrentClipRectangle();
        if (clipRect != null) {
            rect = rect.intersection(clipRect);
        }
        if (!rect.isEmpty()) {
            Toolkit.changeColors(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), Toolkit.getColorPairNumber(color), __attributes[color.getColorAttribute()]);
        }
    }

    private static native void changeColors(int var0, int var1, int var2, int var3, short var4, long var5);

    public static native void beep();

    static {
        System.load(Toolkit.getLibraryPath());
        Toolkit.fillBasicColors(__basicColors);
        Toolkit.fillAttributes(__attributes);
        Toolkit.fillColorPairs();
        Toolkit.initEncoding();
        Toolkit.init();
        __clips = new Hashtable();
        __maxColorPairNumber = (short)-1;
        __bytes = new byte[1];
    }
}

