/*
 * Decompiled with CFR 0.152.
 */
package jcurses.system;

import java.io.UnsupportedEncodingException;
import jcurses.system.Toolkit;

public class InputChar {
    public static final int KEY_DOWN = Toolkit.getSpecialKeyCode(258);
    public static final int KEY_UP = Toolkit.getSpecialKeyCode(259);
    public static final int KEY_LEFT = Toolkit.getSpecialKeyCode(260);
    public static final int KEY_RIGHT = Toolkit.getSpecialKeyCode(261);
    public static final int KEY_HOME = Toolkit.getSpecialKeyCode(262);
    public static final int KEY_BACKSPACE = Toolkit.getSpecialKeyCode(263);
    public static final int KEY_F1 = Toolkit.getSpecialKeyCode(265);
    public static final int KEY_F2 = Toolkit.getSpecialKeyCode(266);
    public static final int KEY_F3 = Toolkit.getSpecialKeyCode(267);
    public static final int KEY_F4 = Toolkit.getSpecialKeyCode(268);
    public static final int KEY_F5 = Toolkit.getSpecialKeyCode(269);
    public static final int KEY_F6 = Toolkit.getSpecialKeyCode(270);
    public static final int KEY_F7 = Toolkit.getSpecialKeyCode(271);
    public static final int KEY_F8 = Toolkit.getSpecialKeyCode(272);
    public static final int KEY_F9 = Toolkit.getSpecialKeyCode(273);
    public static final int KEY_F10 = Toolkit.getSpecialKeyCode(274);
    public static final int KEY_F11 = Toolkit.getSpecialKeyCode(275);
    public static final int KEY_F12 = Toolkit.getSpecialKeyCode(276);
    public static final int KEY_DC = Toolkit.getSpecialKeyCode(330);
    public static final int KEY_IC = Toolkit.getSpecialKeyCode(331);
    public static final int KEY_NPAGE = Toolkit.getSpecialKeyCode(338);
    public static final int KEY_PPAGE = Toolkit.getSpecialKeyCode(339);
    public static final int KEY_PRINT = Toolkit.getSpecialKeyCode(346);
    public static final int KEY_END = Toolkit.getSpecialKeyCode(360);
    private int _code = -1;
    private String _string = null;
    private static byte[] __bytes = new byte[1];

    public InputChar(int code) {
        this._code = code;
        if (this._code <= 255) {
            this._string = InputChar.convertByteToString(this._code);
        }
    }

    public InputChar(char character) {
        this._string = "" + character;
        this._code = this._string.getBytes()[0];
    }

    public boolean isSpecialCode() {
        return this._code > 255;
    }

    private static synchronized String convertByteToString(int code) {
        InputChar.__bytes[0] = (byte)code;
        String result = null;
        String encoding = Toolkit.getEncoding();
        if (encoding == null) {
            result = new String(__bytes);
        } else {
            try {
                result = new String(__bytes, encoding);
            }
            catch (UnsupportedEncodingException e) {
                result = new String(__bytes);
                Toolkit.setEncoding(null);
            }
        }
        return result;
    }

    public char getCharacter() {
        if (this.isSpecialCode()) {
            throw new RuntimeException("this is a special key");
        }
        return this._string.charAt(0);
    }

    public String toString() {
        return this._string;
    }

    public int getCode() {
        return this._code;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InputChar)) {
            return false;
        }
        InputChar character2 = (InputChar)obj;
        return this._code == character2.getCode();
    }

    public int hashCode() {
        return this._code;
    }
}

