/*
 * Decompiled with CFR 0.152.
 */
package jcurses.system;

import jcurses.system.Toolkit;

public class CharColor {
    public static final short BLACK = 0;
    public static final short RED = 1;
    public static final short GREEN = 2;
    public static final short YELLOW = 3;
    public static final short BLUE = 4;
    public static final short MAGENTA = 5;
    public static final short CYAN = 6;
    public static final short WHITE = 7;
    public static final short NORMAL = 0;
    public static final short REVERSE = 1;
    public static final short BOLD = 2;
    private short _background;
    private short _foreground;
    private short _blackWhiteAttribute = 0;
    private short _colorAttribute = 0;

    public CharColor(short background, short foreground, short blackWhiteAttribute, short colorAttribute) {
        this.verifyColor(background);
        this.verifyColor(foreground);
        this.verifyAttribute(colorAttribute);
        this.verifyAttribute(blackWhiteAttribute);
        this._background = background;
        this._foreground = foreground;
        this._blackWhiteAttribute = blackWhiteAttribute;
        this._colorAttribute = colorAttribute;
        this.initChtype();
    }

    public CharColor(short background, short foreground, short blackWhiteAttribute) {
        this(background, foreground, 0, 0);
    }

    public CharColor(short background, short foreground) {
        this(background, foreground, 0);
    }

    public void setBackground(short background) {
        this.verifyColor(background);
        this._background = background;
        this.initChtype();
    }

    public void setForeground(short foreground) {
        this.verifyColor(foreground);
        this._foreground = foreground;
        this.initChtype();
    }

    public short getBackground() {
        return this._background;
    }

    public short getForeground() {
        return this._foreground;
    }

    public short getBlackWhiteAttribute() {
        return this._blackWhiteAttribute;
    }

    public void setBlackWhiteAttribute(short blackWhiteAttribute) {
        this._blackWhiteAttribute = blackWhiteAttribute;
    }

    public short getColorAttribute() {
        return this._colorAttribute;
    }

    public void setColorAttribute(short colorAttribute) {
        this._colorAttribute = colorAttribute;
    }

    private void verifyColor(short color) {
        if (color != 0 && color != 1 && color != 2 && color != 3 && color != 4 && color != 5 && color != 6 && color != 7) {
            throw new IllegalArgumentException("Unknown color:" + color);
        }
    }

    private void verifyAttribute(short attribute) {
        if (attribute != 0 && attribute != 1 && attribute != 2) {
            throw new IllegalArgumentException("Unknown color attribute:" + attribute);
        }
    }

    private void initChtype() {
        Toolkit.computeChtype(this);
    }

    private String getColorName(short index) {
        String result = "";
        result = index == 0 ? "BLACK" : (index == 7 ? "WHITE" : (index == 2 ? "GREEN" : (index == 3 ? "YELLOW" : (index == 5 ? "MAGENTA" : (index == 6 ? "CYAN" : (index == 4 ? "BLUE" : "UNKNOWN COLOR"))))));
        return result;
    }

    private String getModusName(short index) {
        String result = "";
        switch (index) {
            case 0: {
                result = "NORMAL";
                break;
            }
            case 1: {
                result = "REVERSE";
                break;
            }
            case 2: {
                result = "BOLD";
                break;
            }
            default: {
                result = "UNKNOWN MODUS";
            }
        }
        return result;
    }

    public String toString() {
        if (Toolkit.hasColors()) {
            return "[background=" + this.getColorName(this._background) + ", foreground=" + this.getColorName(this._foreground) + "]";
        }
        return "[modi=" + this.getModusName(this._blackWhiteAttribute) + "]";
    }
}

