/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class VMStopCommand
extends SuperBladeCommand {
    byte driveID;

    public boolean preValidate() {
        String usage = "Usage: vm stop <drive ID>\ndrive ID = <1|2>";
        if (this.parameters == null || this.parameters.length != 1) {
            MOut.println(usage);
            return false;
        }
        try {
            this.driveID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.println("drive ID should be number");
            MOut.println(usage);
            return false;
        }
        if (this.driveID < 1 || this.driveID > 2) {
            MOut.println(usage);
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiOEMCommand.checkNoVMAndWeb()) {
            MOut.println("This device doesn't support virtual media");
            this.statusCode = 153;
            return;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessage resMessage = ipmiRaritanOEMCommand.closeVirtualMediaSession(this.driveID);
        if (resMessage != null && resMessage.completionCode == 0) {
            MOut.println("Done");
            this.statusCode = 0;
            return;
        }
        MOut.println("Failed");
        this.statusCode = 149;
    }
}

