/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserLevelCommand
extends SuperBladeCommand {
    byte userID;
    byte privilege;

    public boolean preValidate() {
        String usage = "Usage: user level <user id> <privilege> \nFor privilege level:\nAdministrator level : 4\nOperator level      : 3\nUser level          : 2\nCallback            : 1";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.println("user id should be number");
            MOut.println(usage);
            return false;
        }
        try {
            this.privilege = Byte.parseByte(this.parameters[1]);
        }
        catch (NumberFormatException ex) {
            MOut.println("privilege should be number");
            MOut.println(usage);
            return false;
        }
        if (this.privilege < 1 || this.privilege > 4) {
            MOut.println("Privilege level error");
            MOut.println("Administrator level : 4");
            MOut.println("operator level      : 3");
            MOut.println("user level          : 2");
            MOut.println("callback            : 1");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b1 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, this.privilege);
        if (!b1) {
            MOut.println("Set user privilege failed");
            this.statusCode = 149;
            return;
        }
        boolean b2 = ipmiMessagingCommand.setEnableUserPlusByID(this.userID, this.privilege);
        if (!b2) {
            MOut.println("Set enable user(+) failed");
            this.statusCode = 149;
            return;
        }
        MOut.println("Done");
        this.statusCode = 0;
    }
}

