/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.AllBladeStatusCommand;
import com.supermicro.ipmi.text.AllCMMStatusCommand;
import com.supermicro.ipmi.text.AllCommandHelpCommand;
import com.supermicro.ipmi.text.AllGigabitSwitchStatusCommnad;
import com.supermicro.ipmi.text.AllInfinibandStatusCommand;
import com.supermicro.ipmi.text.AllPowerSupplyStatusCommand;
import com.supermicro.ipmi.text.Argument;
import com.supermicro.ipmi.text.BladeBMCDHCPMultiCommand;
import com.supermicro.ipmi.text.BladeBMCIPMBMultiCommand;
import com.supermicro.ipmi.text.BladeBMCIPSettingMultiCommand;
import com.supermicro.ipmi.text.BladeBMCVLANMultiCommand;
import com.supermicro.ipmi.text.BladeConfigMultiCommand;
import com.supermicro.ipmi.text.BladeKVMCommand;
import com.supermicro.ipmi.text.BladePowerMultiCommand;
import com.supermicro.ipmi.text.BladeSensorsMultiCommand;
import com.supermicro.ipmi.text.BladeStatusMultiCommand;
import com.supermicro.ipmi.text.BladeUIDMultiCommand;
import com.supermicro.ipmi.text.CMMBladeModeCommand;
import com.supermicro.ipmi.text.CMMDateTimeCommand;
import com.supermicro.ipmi.text.CMMFlashCommand;
import com.supermicro.ipmi.text.CMMGatewayCommand;
import com.supermicro.ipmi.text.CMMIPCommand;
import com.supermicro.ipmi.text.CMMMACCommand;
import com.supermicro.ipmi.text.CMMNetmaskCommand;
import com.supermicro.ipmi.text.CMMNtpCommand;
import com.supermicro.ipmi.text.CMMResetCommand;
import com.supermicro.ipmi.text.CMMStatusCommand;
import com.supermicro.ipmi.text.CMMSyncfgCommand;
import com.supermicro.ipmi.text.CMMVersionCommand;
import com.supermicro.ipmi.text.ChangeHostCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.ExecCommand;
import com.supermicro.ipmi.text.FailureCommand;
import com.supermicro.ipmi.text.FindCommand;
import com.supermicro.ipmi.text.FoundCommand;
import com.supermicro.ipmi.text.GBPowerMultiCommand;
import com.supermicro.ipmi.text.GBStatusMultiCommand;
import com.supermicro.ipmi.text.GBWSSMultiCommand;
import com.supermicro.ipmi.text.HostAddCommand;
import com.supermicro.ipmi.text.HostGroupAddCommand;
import com.supermicro.ipmi.text.HostGroupAddHostCommand;
import com.supermicro.ipmi.text.HostGroupRemoveCommand;
import com.supermicro.ipmi.text.HostGroupRemoveHostCommand;
import com.supermicro.ipmi.text.HostGroupRenameCommand;
import com.supermicro.ipmi.text.HostListCommand;
import com.supermicro.ipmi.text.HostReloadCommand;
import com.supermicro.ipmi.text.HostRemoveCommand;
import com.supermicro.ipmi.text.HostRenameCommand;
import com.supermicro.ipmi.text.HostRunCommand;
import com.supermicro.ipmi.text.IPMIACPICommand;
import com.supermicro.ipmi.text.IPMIFRUListCommand;
import com.supermicro.ipmi.text.IPMIFlashCommand;
import com.supermicro.ipmi.text.IPMIFlashwCommand;
import com.supermicro.ipmi.text.IPMIIPMBCommand;
import com.supermicro.ipmi.text.IPMIIPMBOEMCommand;
import com.supermicro.ipmi.text.IPMILanARPCommand;
import com.supermicro.ipmi.text.IPMILanDHCPCommand;
import com.supermicro.ipmi.text.IPMILanGatewayCommand;
import com.supermicro.ipmi.text.IPMILanIPCommand;
import com.supermicro.ipmi.text.IPMILanMACCommand;
import com.supermicro.ipmi.text.IPMILanNetmaskCommand;
import com.supermicro.ipmi.text.IPMILanSNMPCommCommand;
import com.supermicro.ipmi.text.IPMILanSNMPCommand;
import com.supermicro.ipmi.text.IPMILanVLANCommand;
import com.supermicro.ipmi.text.IPMIOEMBackupCommand;
import com.supermicro.ipmi.text.IPMIOEMBoardIDCommand;
import com.supermicro.ipmi.text.IPMIOEMClearChassisIntrusionCommand;
import com.supermicro.ipmi.text.IPMIOEMRestoreCommand;
import com.supermicro.ipmi.text.IPMIOEMUIDCommand;
import com.supermicro.ipmi.text.IPMIPowerCommand;
import com.supermicro.ipmi.text.IPMIRawCommand;
import com.supermicro.ipmi.text.IPMIResetBMCCommand;
import com.supermicro.ipmi.text.IPMISensorCommand;
import com.supermicro.ipmi.text.IPMIVerCommand;
import com.supermicro.ipmi.text.InfinibandPowerMultiCommand;
import com.supermicro.ipmi.text.InfinibandStatusMultiCommand;
import com.supermicro.ipmi.text.ListSystemTemperatureCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.PlugInJarClassLoader;
import com.supermicro.ipmi.text.PowerSupplyFanMultiCommand;
import com.supermicro.ipmi.text.PowerSupplyPowerMultiCommand;
import com.supermicro.ipmi.text.PowerSupplyStatusMultiCommand;
import com.supermicro.ipmi.text.SELClearCommand;
import com.supermicro.ipmi.text.SELInfoCommand;
import com.supermicro.ipmi.text.SELListCommand;
import com.supermicro.ipmi.text.ShellCmdCommand;
import com.supermicro.ipmi.text.ShellCommand;
import com.supermicro.ipmi.text.SystemCommand;
import com.supermicro.ipmi.text.TrapClearCommand;
import com.supermicro.ipmi.text.TrapListCommand;
import com.supermicro.ipmi.text.TrapSaveCommand;
import com.supermicro.ipmi.text.TrapSavePETCommand;
import com.supermicro.ipmi.text.TrapStartCommand;
import com.supermicro.ipmi.text.TrapStatusCommand;
import com.supermicro.ipmi.text.TrapStopCommand;
import com.supermicro.ipmi.text.UserAddCommand;
import com.supermicro.ipmi.text.UserDeleteCommand;
import com.supermicro.ipmi.text.UserLevelCommand;
import com.supermicro.ipmi.text.UserListCommand;
import com.supermicro.ipmi.text.UserTestCommand;
import com.supermicro.ipmi.text.VMFloppyCommand;
import com.supermicro.ipmi.text.VMISOCommand;
import com.supermicro.ipmi.text.VMStatusCommand;
import com.supermicro.ipmi.text.VMStopCommand;
import com.supermicro.ipmi.text.VerCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jline.Completor;

public class Parser
implements Completor {
    boolean shellMode = false;
    Argument argumentRoot = new Argument("Main available commands", "");
    Argument system = new Argument("system", "system", "System status overview", new SystemCommand());
    Argument failure = new Argument("failure", "failure", "Blade system failure report", new FailureCommand());
    Argument blade = new Argument("blade", "blade", "Server blade management");
    Argument gigabit = new Argument("gigabit", "gigabit", "Gigabit switch management");
    Argument power = new Argument("power", "power", "Power supply management");
    Argument ib = new Argument("ib", "ib", "Infiniband management");
    Argument cmm = new Argument("cmm", "cmm", "CMM management");
    Argument lstemp = new Argument("listtemp", "listtemp", "List system temperatures", new ListSystemTemperatureCommand());
    Argument sel = new Argument("sel", "sel", "System event log");
    Argument user = new Argument("user", "user", "User management");
    Argument vm = new Argument("vm", "vm", "Virtual Media management");
    Argument ipmi = new Argument("ipmi", "ipmi", "IPMI device management");
    Argument ver = new Argument("ver", "ver", "Print version", new VerCommand());
    Argument shell = new Argument("shell", "shell", "Shell mode", new ShellCommand());
    Argument ch = new Argument("ch", "ch", "Change managed device in shell mode", new ChangeHostCommand());
    Argument allHelp = new Argument("list [keyword]", "list", "List all or find available commands", new AllCommandHelpCommand());
    Argument find = new Argument("find [<Start> <End> <netMask>]", "find", "Find IPMI device from local or IP range", new FindCommand());
    Argument found = new Argument("found [clear]", "found", "List or clear found IPMI devices", new FoundCommand());
    Argument exec = new Argument("exec <filename> [loop] [delay]", "exec", "Execute commands from file", new ExecCommand());
    Argument host = new Argument("host", "host", "Host management");
    Argument hostRun = new Argument("hostrun <host|group> <command>", "hostrun", "Run a command on host or group", new HostRunCommand());
    Argument trap = new Argument("trap", "trap", "IPMI SNMP Trap receiver management");
    Argument shellCmd = new Argument("sc", "sc", "Execute DOS/Linux shell command", new ShellCmdCommand());
    Argument allBladeStatus = new Argument("status", "status", "Blade status", new AllBladeStatusCommand());
    Argument allGigabitStatus = new Argument("status", "status", "Gigabit switch status", new AllGigabitSwitchStatusCommnad());
    Argument allPowerStatus = new Argument("status", "status", "Power supply status", new AllPowerSupplyStatusCommand());
    Argument allIBStatus = new Argument("status", "status", "Infiniband status", new AllInfinibandStatusCommand());
    Argument allCmmStatus = new Argument("status", "status", "CMM status", new AllCMMStatusCommand());
    Argument bladeIndex = new Argument("<blade index(es)>", "", "Index number of blade");
    Argument gigabitIndex = new Argument("<gigabit index(es)>", "", "Index number of gigabit switch");
    Argument powerIndex = new Argument("<power index(es)>", "", "Index number of power supply");
    Argument ibIndex = new Argument("<ib index(es)>", "", "Index number of Infiniband switch");
    Argument cmmIndex = new Argument("<cmm index>", "", "Index number of a CMM");
    Argument bladeStatus = new Argument("status", "status", "Blade status", new BladeStatusMultiCommand());
    Argument bladePower = new Argument("power", "power", "Power control", new BladePowerMultiCommand());
    Argument bladeKVM = new Argument("kvm", "kvm", "Request KVM switch", new BladeKVMCommand());
    Argument bladeUID = new Argument("uid", "uid", "on/off UID LED", new BladeUIDMultiCommand());
    Argument bladeSensors = new Argument("sensor", "sensor", "Sensors status", new BladeSensorsMultiCommand());
    Argument bladeBMC = new Argument("bmc", "bmc", "BMC(SIMBL) LAN configuration");
    Argument bladeConfig = new Argument("config", "config", "Blade motherboard configuration", new BladeConfigMultiCommand());
    Argument bladeBMCIP = new Argument("ip [IP]", "ip", "Get/set BMC IP", new BladeBMCIPSettingMultiCommand());
    Argument bladeBMCDHCP = new Argument("dhcp [enable|disable]", "dhcp", "Enable/Disable DHCP", new BladeBMCDHCPMultiCommand());
    Argument bladeBMCVLAN = new Argument("vlan [<enable|disable> <tag>]", "vlan", "Display/Enable/Disable VLAN", new BladeBMCVLANMultiCommand());
    Argument bladeBMCIPMB = new Argument("ipmb <netFn> <cmd> [data] ", "ipmb", "Send IPMI raw command", new BladeBMCIPMBMultiCommand());
    Argument gbStatus = new Argument("status", "status", "Gigabit Switch status", new GBStatusMultiCommand());
    Argument gbPower = new Argument("power", "power", "Power control", new GBPowerMultiCommand());
    Argument gbWSS = new Argument("wss", "wss", "WSS web configuration", new GBWSSMultiCommand());
    Argument powerStatus = new Argument("status", "status", "Power Supply status", new PowerSupplyStatusMultiCommand());
    Argument powerPower = new Argument("power", "power", "Power supply power control", new PowerSupplyPowerMultiCommand());
    Argument powerFanSpeed = new Argument("fan", "fan", "Power supply fan control", new PowerSupplyFanMultiCommand());
    Argument ibStatus = new Argument("status", "status", "Infiniband status", new InfinibandStatusMultiCommand());
    Argument ibPower = new Argument("power", "power", "Infiniband power control", new InfinibandPowerMultiCommand());
    Argument cmmStatus = new Argument("status", "status", "CMM status", new CMMStatusCommand());
    Argument cmmTime = new Argument("dtime [datetime]", "dtime", "Get/Set CMM date/time", new CMMDateTimeCommand());
    Argument cmmNTP = new Argument("ntp <UTC offset> <NTP1> [NTP2]", "ntp", "Sync time with NTP servers", new CMMNtpCommand());
    Argument cmmReset = new Argument("reset", "reset", "Reset CMM", new CMMResetCommand());
    Argument cmmFlash = new Argument("flash <filename>", "flash", "Flash CMM firmware", new CMMFlashCommand());
    Argument cmmVer = new Argument("ver", "ver", "CMM firmware version", new CMMVersionCommand());
    Argument cmmIP = new Argument("ip [ip]", "ip", "Get/Set IP. Format:###.###.###.###", new CMMIPCommand());
    Argument cmmMAC = new Argument("mac [mac]", "mac", "Get/Set MAC. Format:##:##:##:##:##:##", new CMMMACCommand());
    Argument cmmGateway = new Argument("gateway [gateway_IP]", "gateway", "Get/Set gateway. Format:###.###.###.###", new CMMGatewayCommand());
    Argument cmmnetmask = new Argument("netmask [netmask]", "netmask", "Get/Set netmask. Format:###.###.###.###", new CMMNetmaskCommand());
    Argument cmmSyncfg = new Argument("syncfg", "syncfg", "Sync configuration to slave CMM", new CMMSyncfgCommand());
    Argument cmmBladeMode = new Argument("opmode [mode]", "opmode", "Get/Set CMM OP mode. 0:Enterprise, 1:Office", new CMMBladeModeCommand());
    Argument selInfo = new Argument("info", "info", "System event log information", new SELInfoCommand());
    Argument selList = new Argument("list", "list", "List system event log", new SELListCommand());
    Argument selClear = new Argument("clear", "clear", "Clear system event log", new SELClearCommand());
    Argument userList = new Argument("list", "list", "List user", new UserListCommand());
    Argument userAdd = new Argument("add", "add", "Add user", new UserAddCommand());
    Argument userDelete = new Argument("delete", "delete", "Delete user", new UserDeleteCommand());
    Argument userLevel = new Argument("level", "level", "Update user level", new UserLevelCommand());
    Argument userTest = new Argument("test", "test", "Test login", new UserTestCommand());
    Argument vmStatus = new Argument("status", "status", "Virtual media status", new VMStatusCommand());
    Argument vmStop = new Argument("stop", "stop", "Stop virtual media", new VMStopCommand());
    Argument vmFloppy = new Argument("floppy", "floppy", "Upload a floppy image as virtual media", new VMFloppyCommand());
    Argument vmISO = new Argument("iso", "iso", "Virtual media via windows share", new VMISOCommand());
    Argument ipmiSensors = new Argument("sensor", "sensor", "Sensor status", new IPMISensorCommand());
    Argument ipmiPower = new Argument("power", "power", "Power control", new IPMIPowerCommand());
    Argument ipmiACPI = new Argument("acpi", "acpi", "ACPI status", new IPMIACPICommand());
    Argument ipmiLan = new Argument("lan", "lan", "LAN configruation");
    Argument ipmiFRU = new Argument("fru", "fru", "FRU information", new IPMIFRUListCommand());
    Argument ipmiOEM = new Argument("oem", "oem", "OEM Commands");
    Argument ipmiReset = new Argument("reset", "reset", "Reset BMC", new IPMIResetBMCCommand());
    Argument ipmiVer = new Argument("ver", "ver", "IPMI device version", new IPMIVerCommand());
    Argument ipmiFlash = new Argument("flash <filename>", "flash", "Flash SIM IPMI firmware", new IPMIFlashCommand());
    Argument ipmiFlashw = new Argument("flashw <filename>", "flashw", "Flash SIMSOW IPMI firmware", new IPMIFlashwCommand());
    Argument ipmiRaw = new Argument("raw <netFn> <cmd> [data]", "raw", "Send IPMI raw command", new IPMIRawCommand());
    Argument ipmiIPMB = new Argument("ipmb <ch> <addr> <netFn> <cmd> ...", "ipmb", "Send IPMB raw command", new IPMIIPMBCommand());
    Argument ipmiIPMBOEM = new Argument("ipmboem <ch> <addr> <netFn> <cmd> ...", "ipmboem", "Send IPMB(OEM) raw command", new IPMIIPMBOEMCommand());
    Argument ipmiLanIP = new Argument("ip [ip]", "ip", "Get/Set IP. Format:###.###.###.###", new IPMILanIPCommand());
    Argument ipmiLanMAC = new Argument("mac [mac]", "mac", "Get/Set MAC. Format:##:##:##:##:##:##", new IPMILanMACCommand());
    Argument ipmiLanGateway = new Argument("gateway [gateway_IP]", "gateway", "Get/Set gateway. Format:###.###.###.###", new IPMILanGatewayCommand());
    Argument ipmiLanNetmask = new Argument("netmask [netmask]", "netmask", "Get/Set netmask. Format:###.###.###.###", new IPMILanNetmaskCommand());
    Argument ipmiLanSNMPDest = new Argument("snmp [<seq> <ip> [mac]]", "snmp", "Get/Set SNMP destination", new IPMILanSNMPCommand());
    Argument ipmiLanSNMPComm = new Argument("snmpcomm [community string]", "snmpcomm", "Get/Set SNMP community string", new IPMILanSNMPCommCommand());
    Argument ipmiLanArp = new Argument("arp [on|off]", "arp", "On/Off Gratuitous ARP", new IPMILanARPCommand());
    Argument ipmiLanDHCP = new Argument("dhcp [enable|disable]", "dhcp", "Enable/Disable DHCP", new IPMILanDHCPCommand());
    Argument ipmiLanVLAN = new Argument("vlan [<enable|disable> <tag>]", "vlan", "Display/Enable/Disable VLAN", new IPMILanVLANCommand());
    Argument ipmiOEMClearChassisIntrusion = new Argument("clrint", "clrint", "Clear chassis Intrusion", new IPMIOEMClearChassisIntrusionCommand());
    Argument ipmiOEMBoardID = new Argument("id", "id", "MB ID. Only available for SIMxx IPMI", new IPMIOEMBoardIDCommand());
    Argument ipmiOEMUID = new Argument("uid [on|off]", "uid", "On/Off UID LED", new IPMIOEMUIDCommand());
    Argument ipmiOEMBackup = new Argument("backup <filename>", "backup", "Configuration backup to file", new IPMIOEMBackupCommand());
    Argument ipmiOEMRestore = new Argument("restore <filename> <option>", "restore", "Configuration restore from file", new IPMIOEMRestoreCommand());
    Argument hostList = new Argument("list", "list", "List host data", new HostListCommand());
    Argument hostReload = new Argument("reload", "reload", "Reload host data", new HostReloadCommand());
    Argument hostAdd = new Argument("add <host> <ip> [username] [password]", "add", "Add a host", new HostAddCommand());
    Argument hostRemove = new Argument("remove <host>", "remove", "Remove a host", new HostRemoveCommand());
    Argument hostRename = new Argument("rename <old name> <new name>", "rename", "Rename a host", new HostRenameCommand());
    Argument hostGroup = new Argument("group", "group", "Host group data management");
    Argument hostGroupAdd = new Argument("add <group> [host] ...", "add", "Add a host group", new HostGroupAddCommand());
    Argument hostGroupRemove = new Argument("remove <group>", "remove", "Remove a host group", new HostGroupRemoveCommand());
    Argument hostGroupRename = new Argument("rename <old name> <new name>", "rename", "Rename a host group", new HostGroupRenameCommand());
    Argument hostGroupremoveHost = new Argument("removehost <group> <host> ...", "removehost", "Remove a host from group", new HostGroupRemoveHostCommand());
    Argument hostGroupAddHost = new Argument("addhost <group> <host> ...", "addhost", "Add a host into group", new HostGroupAddHostCommand());
    Argument hostRemoveGroup = new Argument("removegroup <group>", "removegroup", "Remove a host group", new HostRemoveCommand());
    Argument trapStart = new Argument("start", "start", "Strat Trap receiver", new TrapStartCommand());
    Argument trapStop = new Argument("stop", "stop", "Stop Trap receiver", new TrapStopCommand());
    Argument trapList = new Argument("list", "list", "List the received Traps", new TrapListCommand());
    Argument trapClear = new Argument("clear", "clear", "Clear the received Traps", new TrapClearCommand());
    Argument trapSave = new Argument("save", "save", "Save the received Traps to file", new TrapSaveCommand());
    Argument trapSavePET = new Argument("savepet", "savepet", "Save as the IPMIView TrapReceiver PET format", new TrapSavePETCommand());
    Argument trapStatus = new Argument("status", "status", "Trap receiver status", new TrapStatusCommand());
    Argument sol = new Argument("sol", "sol", "SOL Test");
    ArrayList commandListTemp = new ArrayList();

    public Parser() {
        this(false);
    }

    public Parser(boolean shellMode) {
        this.shellMode = shellMode;
        this.initialFunctions();
    }

    public void initialFunctions() {
        this.argumentRoot.addNextArgument(this.system);
        this.argumentRoot.addNextArgument(this.failure);
        this.argumentRoot.addNextArgument(this.blade);
        this.argumentRoot.addNextArgument(this.gigabit);
        this.argumentRoot.addNextArgument(this.power);
        this.argumentRoot.addNextArgument(this.ib);
        this.argumentRoot.addNextArgument(this.cmm);
        this.argumentRoot.addNextArgument(this.lstemp);
        this.argumentRoot.addNextArgument(this.sel);
        this.argumentRoot.addNextArgument(this.user);
        this.argumentRoot.addNextArgument(this.vm);
        this.argumentRoot.addNextArgument(this.ipmi);
        if (!this.shellMode) {
            this.argumentRoot.addNextArgument(this.shell);
        }
        this.argumentRoot.addNextArgument(this.ver);
        if (this.shellMode) {
            this.argumentRoot.addNextArgument(this.ch);
        }
        this.argumentRoot.addNextArgument(this.allHelp);
        this.argumentRoot.addNextArgument(this.find);
        this.argumentRoot.addNextArgument(this.found);
        this.argumentRoot.addNextArgument(this.exec);
        this.argumentRoot.addNextArgument(this.host);
        this.argumentRoot.addNextArgument(this.hostRun);
        if (this.shellMode) {
            this.argumentRoot.addNextArgument(this.trap);
        }
        this.argumentRoot.addNextArgument(this.shellCmd);
        this.blade.addNextArgument(this.allBladeStatus);
        this.gigabit.addNextArgument(this.allGigabitStatus);
        this.power.addNextArgument(this.allPowerStatus);
        this.ib.addNextArgument(this.allIBStatus);
        this.cmm.addNextArgument(this.allCmmStatus);
        this.blade.addNextArgument(this.bladeIndex);
        this.gigabit.addNextArgument(this.gigabitIndex);
        this.power.addNextArgument(this.powerIndex);
        this.ib.addNextArgument(this.ibIndex);
        this.cmm.addNextArgument(this.cmmIndex);
        this.bladeIndex.setArgumentType(1);
        this.gigabitIndex.setArgumentType(1);
        this.powerIndex.setArgumentType(1);
        this.ibIndex.setArgumentType(1);
        this.cmmIndex.setArgumentType(1);
        this.bladeIndex.addNextArgument(this.bladeStatus);
        this.bladeIndex.addNextArgument(this.bladePower);
        this.bladeIndex.addNextArgument(this.bladeKVM);
        this.bladeIndex.addNextArgument(this.bladeUID);
        this.bladeIndex.addNextArgument(this.bladeSensors);
        this.bladeIndex.addNextArgument(this.bladeBMC);
        this.bladeIndex.addNextArgument(this.bladeConfig);
        this.bladeBMC.addNextArgument(this.bladeBMCIP);
        this.bladeBMC.addNextArgument(this.bladeBMCDHCP);
        this.bladeBMC.addNextArgument(this.bladeBMCVLAN);
        this.bladeBMC.addNextArgument(this.bladeBMCIPMB);
        this.gigabitIndex.addNextArgument(this.gbStatus);
        this.gigabitIndex.addNextArgument(this.gbPower);
        this.gigabitIndex.addNextArgument(this.gbWSS);
        this.powerIndex.addNextArgument(this.powerStatus);
        this.powerIndex.addNextArgument(this.powerPower);
        this.powerIndex.addNextArgument(this.powerFanSpeed);
        this.ibIndex.addNextArgument(this.ibStatus);
        this.ibIndex.addNextArgument(this.ibPower);
        this.cmmIndex.addNextArgument(this.cmmStatus);
        this.cmmIndex.addNextArgument(this.cmmTime);
        this.cmmIndex.addNextArgument(this.cmmNTP);
        this.cmmIndex.addNextArgument(this.cmmReset);
        this.cmmIndex.addNextArgument(this.cmmFlash);
        this.cmmIndex.addNextArgument(this.cmmVer);
        this.cmmIndex.addNextArgument(this.cmmIP);
        this.cmmIndex.addNextArgument(this.cmmMAC);
        this.cmmIndex.addNextArgument(this.cmmGateway);
        this.cmmIndex.addNextArgument(this.cmmnetmask);
        this.cmmIndex.addNextArgument(this.cmmSyncfg);
        this.cmmIndex.addNextArgument(this.cmmBladeMode);
        this.cmmIndex.addNextArgument(this.ipmiLanDHCP);
        this.sel.addNextArgument(this.selInfo);
        this.sel.addNextArgument(this.selList);
        this.sel.addNextArgument(this.selClear);
        this.user.addNextArgument(this.userAdd);
        this.user.addNextArgument(this.userList);
        this.user.addNextArgument(this.userDelete);
        this.user.addNextArgument(this.userLevel);
        this.user.addNextArgument(this.userTest);
        this.vm.addNextArgument(this.vmStatus);
        this.vm.addNextArgument(this.vmStop);
        this.vm.addNextArgument(this.vmFloppy);
        this.vm.addNextArgument(this.vmISO);
        this.ipmi.addNextArgument(this.ipmiSensors);
        this.ipmi.addNextArgument(this.ipmiPower);
        this.ipmi.addNextArgument(this.ipmiACPI);
        this.ipmi.addNextArgument(this.ipmiLan);
        this.ipmi.addNextArgument(this.ipmiFRU);
        this.ipmi.addNextArgument(this.ipmiOEM);
        this.ipmi.addNextArgument(this.ipmiReset);
        this.ipmi.addNextArgument(this.ipmiVer);
        this.ipmi.addNextArgument(this.ipmiFlash);
        this.ipmi.addNextArgument(this.ipmiFlashw);
        this.ipmi.addNextArgument(this.ipmiRaw);
        this.ipmi.addNextArgument(this.ipmiIPMB);
        this.ipmi.addNextArgument(this.ipmiIPMBOEM);
        this.ipmiLan.addNextArgument(this.ipmiLanIP);
        this.ipmiLan.addNextArgument(this.ipmiLanMAC);
        this.ipmiLan.addNextArgument(this.ipmiLanGateway);
        this.ipmiLan.addNextArgument(this.ipmiLanNetmask);
        this.ipmiLan.addNextArgument(this.ipmiLanSNMPDest);
        this.ipmiLan.addNextArgument(this.ipmiLanSNMPComm);
        this.ipmiLan.addNextArgument(this.ipmiLanArp);
        this.ipmiLan.addNextArgument(this.ipmiLanDHCP);
        this.ipmiLan.addNextArgument(this.ipmiLanVLAN);
        this.ipmiOEM.addNextArgument(this.ipmiOEMClearChassisIntrusion);
        this.ipmiOEM.addNextArgument(this.ipmiOEMBoardID);
        this.ipmiOEM.addNextArgument(this.ipmiOEMUID);
        this.ipmiOEM.addNextArgument(this.ipmiOEMBackup);
        this.ipmiOEM.addNextArgument(this.ipmiOEMRestore);
        this.host.addNextArgument(this.hostList);
        this.host.addNextArgument(this.hostReload);
        this.host.addNextArgument(this.hostAdd);
        this.host.addNextArgument(this.hostRemove);
        this.host.addNextArgument(this.hostRename);
        this.host.addNextArgument(this.hostGroup);
        this.hostGroup.addNextArgument(this.hostGroupAdd);
        this.hostGroup.addNextArgument(this.hostGroupRemove);
        this.hostGroup.addNextArgument(this.hostGroupRename);
        this.hostGroup.addNextArgument(this.hostGroupAddHost);
        this.hostGroup.addNextArgument(this.hostGroupremoveHost);
        this.trap.addNextArgument(this.trapStart);
        this.trap.addNextArgument(this.trapStop);
        this.trap.addNextArgument(this.trapStatus);
        this.trap.addNextArgument(this.trapList);
        this.trap.addNextArgument(this.trapClear);
        this.trap.addNextArgument(this.trapSave);
        this.trap.addNextArgument(this.trapSavePET);
        this.system.addAlternateValue("sys");
        this.failure.addAlternateValue("fail");
        this.blade.addAlternateValue("bl");
        this.gigabit.addAlternateValue("gb");
        this.power.addAlternateValue("ps");
        this.lstemp.addAlternateValue("lst");
        this.allBladeStatus.addAlternateValue("st");
        this.allGigabitStatus.addAlternateValue("st");
        this.allPowerStatus.addAlternateValue("st");
        this.allIBStatus.addAlternateValue("st");
        this.allCmmStatus.addAlternateValue("st");
        this.bladeStatus.addAlternateValue("st");
        this.gbStatus.addAlternateValue("st");
        this.powerStatus.addAlternateValue("st");
        this.ibStatus.addAlternateValue("st");
        this.cmmStatus.addAlternateValue("st");
        this.vmStatus.addAlternateValue("st");
        this.bladeSensors.addAlternateValue("sr");
        this.ipmiSensors.addAlternateValue("sr");
        this.trapStatus.addAlternateValue("st");
        if (!this.shellMode) {
            this.loadPlugInCommands();
        }
    }

    public void loadPlugInCommands() {
        PlugInJarClassLoader loader = new PlugInJarClassLoader();
        ArrayList<Argument> arguments = loader.load();
        for (int i = 0; i < arguments.size(); ++i) {
            CommandPlugIn commandPlugIn = (CommandPlugIn)arguments.get(i).getCommand();
            if (this.shellMode) {
                if (!commandPlugIn.isSupportShellMode()) continue;
                this.argumentRoot.addNextArgument(arguments.get(i));
                MOut.println("PlugIn Command: \"" + commandPlugIn.getName() + "\" Loaded.");
                continue;
            }
            if (!commandPlugIn.isSupportCLIMode()) continue;
            this.argumentRoot.addNextArgument(arguments.get(i));
        }
    }

    public Command parse(Argument argu, String[] input) {
        Argument currentArgu = argu;
        Argument backupArgu = argu;
        ArrayList<String> preParameters = new ArrayList<String>();
        String[] tailParameters = null;
        for (int i = 0; i < input.length; ++i) {
            preParameters.add(input[i]);
            for (int j = 0; j < currentArgu.getNextArguments().size(); ++j) {
                Argument anArgu = (Argument)currentArgu.getNextArguments().get(j);
                if (anArgu.getValue().length() != 0) {
                    if (this.findAlternate(input[i], anArgu)) {
                        currentArgu = anArgu;
                        break;
                    }
                    if (!anArgu.getValue().equalsIgnoreCase(input[i])) continue;
                    currentArgu = anArgu;
                    break;
                }
                anArgu.setValue(input[i]);
                if (anArgu.validate()) {
                    currentArgu = anArgu;
                    break;
                }
                MOut.println(anArgu.getValue() + "," + anArgu.getName() + " format error ");
                return null;
            }
            if (currentArgu.equals(backupArgu)) {
                MOut.println("Invalid command");
                return null;
            }
            backupArgu = currentArgu;
            if (currentArgu.getNextArguments().size() != 0 || input.length - 1 <= i) continue;
            tailParameters = new String[input.length - i - 1];
            System.arraycopy(input, i + 1, tailParameters, 0, tailParameters.length);
            break;
        }
        if (currentArgu.getNextArguments().size() != 0) {
            this.printPreParameter(preParameters);
            this.helpPrintAvailableCommand(currentArgu);
            return null;
        }
        Command command = currentArgu.getCommand();
        if (command != null) {
            command.clearParameter();
            command.setPreParameters(preParameters);
            if (tailParameters != null) {
                command.setParameters(tailParameters);
            }
        } else {
            MOut.println("Not yet implemented");
        }
        return command;
    }

    private boolean findAlternate(String input, Argument anArgu) {
        boolean result = false;
        if (anArgu.getAlternateValue().size() != 0) {
            for (int i = 0; i < anArgu.getAlternateValue().size(); ++i) {
                if (!anArgu.getAlternateValue().get(i).equalsIgnoreCase(input)) continue;
                result = true;
            }
        }
        return result;
    }

    public void printPreParameter(ArrayList preParameters) {
        MOut.print("Command:");
        for (int i = 0; i < preParameters.size(); ++i) {
            MOut.print(preParameters.get(i) + " ");
        }
        MOut.println("");
    }

    public void helpPrintAvailableCommand(Argument currentArgu) {
        if (currentArgu.getNextArguments().size() != 0) {
            MOut.println("Available command(s): ");
            for (int j = 0; j < currentArgu.getNextArguments().size(); ++j) {
                Argument nextArguments = (Argument)currentArgu.getNextArguments().get(j);
                String name = nextArguments.getName() + nextArguments.getAlternateValueString();
                String comment = nextArguments.getComment();
                Command command = nextArguments.getCommand();
                MOut.printf("%-25s \t %-20s \n", name, (comment == null ? "" : comment) + (command == null && nextArguments.nextArguments.size() == 0 ? " (!)" : ""));
            }
            MOut.println("");
        }
    }

    public void printAllCommandsHelp(Argument argu) {
        if (argu.getNextArguments().size() != 0 && argu.getName().length() != 0) {
            MOut.println("Command: " + this.previousCommandToString() + argu.getName());
        }
        this.helpPrintAvailableCommand(argu);
        ArrayList subArgus = argu.getNextArguments();
        if (subArgus == null) {
            return;
        }
        this.commandListTemp.add(argu.getName());
        for (int i = 0; i < subArgus.size(); ++i) {
            Argument aSubArgu = (Argument)subArgus.get(i);
            this.printAllCommandsHelp(aSubArgu);
        }
        this.commandListTemp.remove(argu.getName());
    }

    public String previousCommandToString() {
        String s = "";
        for (int i = 1; i < this.commandListTemp.size(); ++i) {
            s = s + (String)this.commandListTemp.get(i) + " ";
        }
        return s;
    }

    public void printAllCommandsHelpByKeyword(Argument argu, String keyword) {
        ArrayList subArgus;
        String commandList = "Command: " + this.previousCommandToString() + argu.getName();
        boolean getAnyCommand = false;
        boolean found = false;
        String tempString = "";
        if (argu.getNextArguments().size() != 0) {
            found = false;
            for (int j = 0; j < argu.getNextArguments().size(); ++j) {
                Argument nextArguments = (Argument)argu.getNextArguments().get(j);
                String name = nextArguments.getName() + nextArguments.getAlternateValueString();
                String comment = nextArguments.getComment();
                Command command = nextArguments.getCommand();
                if (name.toUpperCase().indexOf(keyword.toUpperCase()) < 0 && comment.toUpperCase().indexOf(keyword.toUpperCase()) < 0) continue;
                tempString = tempString + String.format("%-25s \t %-20s \n", name, (comment == null ? "" : comment) + (command == null && nextArguments.nextArguments.size() == 0 ? " (!)" : ""));
                found = true;
                getAnyCommand = true;
            }
            if (found) {
                MOut.println(commandList);
                MOut.println(tempString);
            }
        }
        if ((subArgus = argu.getNextArguments()) == null) {
            return;
        }
        this.commandListTemp.add(argu.getName());
        for (int i = 0; i < subArgus.size(); ++i) {
            Argument aSubArgu = (Argument)subArgus.get(i);
            this.printAllCommandsHelpByKeyword(aSubArgu, keyword);
        }
        this.commandListTemp.remove(argu.getName());
    }

    public int complete(String buffer, int cursor, List candidates) {
        String[] input;
        int lastKeyStartPosition = 0;
        StringTokenizer st = new StringTokenizer(buffer, " ");
        if (buffer.length() != 0 && buffer.charAt(buffer.length() - 1) == ' ') {
            input = new String[st.countTokens() + 1];
            input[st.countTokens()] = "";
        } else {
            input = new String[st.countTokens()];
        }
        int count = 0;
        while (st.hasMoreTokens()) {
            String token;
            input[count] = token = st.nextToken();
            ++count;
        }
        if (input.length == 0) {
            this.populateArgument(this.argumentRoot, "", candidates);
            return 0;
        }
        lastKeyStartPosition = buffer.lastIndexOf(" ");
        ++lastKeyStartPosition;
        Argument currentArgu = this.argumentRoot;
        Argument backupArgu = this.argumentRoot;
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < currentArgu.getNextArguments().size(); ++j) {
                Argument anArgu = (Argument)currentArgu.getNextArguments().get(j);
                if (anArgu.getValue().length() != 0) {
                    if (this.findAlternate(input[i], anArgu)) {
                        currentArgu = anArgu;
                        break;
                    }
                    if (!anArgu.getValue().equalsIgnoreCase(input[i])) continue;
                    currentArgu = anArgu;
                    break;
                }
                anArgu.setValue(input[i]);
                if (!anArgu.validate()) continue;
                currentArgu = anArgu;
                break;
            }
            if (currentArgu.equals(backupArgu)) {
                this.populateArgument(currentArgu, input[i], candidates);
                return lastKeyStartPosition;
            }
            backupArgu = currentArgu;
            if (currentArgu.getNextArguments().size() != 0 || i != input.length - 2) continue;
            this.populateSubCommand(currentArgu, input[input.length - 1], candidates);
        }
        return cursor;
    }

    public void populateSubCommand(Argument argu, String key, List candidates) {
        Command command = argu.getCommand();
        String[] subCommands = command.getSubCommandsForTabCompletion();
        if (subCommands == null) {
            return;
        }
        for (int i = 0; i < subCommands.length; ++i) {
            String item = subCommands[i];
            if (!item.startsWith(key) && key.length() != 0) continue;
            candidates.add(item);
        }
    }

    public void populateArgument(Argument argu, String key, List candidates) {
        for (Argument item : argu.getNextArguments()) {
            if (item.getValue().startsWith(key) || key.length() == 0) {
                candidates.add(item.getValue());
            }
            for (String alterString : item.getAlternateValue()) {
                if (!alterString.startsWith(key) && key.length() != 0) continue;
                candidates.add(alterString);
            }
        }
    }

    public static void main(String[] args) {
        Parser p = new Parser();
        p.printAllCommandsHelp(p.argumentRoot);
    }
}

