/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanVLANCommand
extends SuperBladeCommand {
    public void runCommand() {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 2) {
            int vlanTag = 0;
            boolean isEnable = false;
            boolean result = false;
            if (this.parameters[0].equalsIgnoreCase("enable")) {
                isEnable = true;
            } else if (this.parameters[0].equalsIgnoreCase("disable")) {
                isEnable = false;
            } else {
                MOut.println("Parameter error!");
                this.statusCode = 147;
                return;
            }
            try {
                vlanTag = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException ex) {
                MOut.println("VLAN Tag invalid");
                this.statusCode = 147;
                return;
            }
            if (vlanTag > 4094 || vlanTag < 0) {
                MOut.println("VLAN Tag Invalid. 0 < vlanTag < 4095 ");
                this.statusCode = 147;
                return;
            }
            try {
                result = ipmiLanCommand.setVLANEnabled(isEnable, vlanTag);
                if (result) {
                    MOut.println("Done");
                    this.printVLANStatus(ipmiLanCommand);
                    this.statusCode = 0;
                }
                MOut.println("Failed");
                this.statusCode = 149;
            }
            catch (IPMIException ex1) {
                MOut.println(ex1.getMessage());
                this.statusCode = 149;
                return;
            }
        } else {
            this.printVLANStatus(ipmiLanCommand);
        }
    }

    private void printVLANStatus(IPMILanCommand ipmiLanCommand) {
        int vlanTag;
        boolean isEnable;
        try {
            isEnable = ipmiLanCommand.isVLANEnabled();
            vlanTag = ipmiLanCommand.getVLANTag();
        }
        catch (IPMIException ex) {
            MOut.println("failed");
            this.statusCode = 149;
            return;
        }
        MOut.println("VLAN : " + (isEnable ? "Enable" : "Disable"));
        MOut.println("VLAN Tag: " + vlanTag);
    }
}

