/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMIIPMBCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        byte[] data;
        byte cmd;
        byte netfn;
        byte address;
        byte channel;
        if (this.parameters == null || this.parameters.length < 4) {
            MOut.println("<channel> <address> <netFn> <cmd> [data] parameters required.");
            this.statusCode = 147;
            return;
        }
        try {
            channel = (byte)Integer.parseInt(this.parameters[0], 16);
            address = (byte)Integer.parseInt(this.parameters[1], 16);
            netfn = (byte)Integer.parseInt(this.parameters[2], 16);
            cmd = (byte)Integer.parseInt(this.parameters[3], 16);
            int dataSize = this.parameters.length - 4;
            data = new byte[dataSize];
            for (int i = 0; i < dataSize; ++i) {
                data[i] = (byte)Integer.parseInt(this.parameters[4 + i], 16);
            }
        }
        catch (NumberFormatException ex) {
            MOut.println(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        netfn = (byte)(netfn << 2);
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(0);
        this.ipmiCMMOEMCommand.setIPMIInterface(ipmb);
        ipmb.setChannel(channel);
        ipmb.setAddress(address);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
        if (resMessage != null) {
            MOut.println("Completion code = " + ByteUtility.byteToHex(resMessage.completionCode) + "h");
            if (resMessage.completionCode != 0) {
                MOut.println("(" + GlobalDefine.getCompletionCodeString(resMessage.completionCode) + ")");
            }
            if (resMessage.data != null && resMessage.data.length != 0) {
                MOut.println("Return data = " + ByteUtility.bytesToHex(resMessage.data));
            }
            this.statusCode = 0;
        } else {
            this.statusCode = 149;
        }
    }
}

