/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Host;
import com.supermicro.ipmi.text.HostManager;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.ShellCommand;

public class HostRunCommand
extends Command {
    ShellCommand shell = null;

    public void execute() throws Exception {
        String command = "";
        if (this.getParameters() == null || this.getParameters().length < 1) {
            MOut.println("host or group name required");
            this.statusCode = 147;
            return;
        }
        if (this.getParameters().length < 2) {
            MOut.println("command required");
            this.statusCode = 147;
            return;
        }
        Host host = HostManager.getInstance().findHost(this.getParameters()[0]);
        Host group = HostManager.getInstance().findHostGroup(this.getParameters()[0]);
        if (host == null && group == null) {
            MOut.println("cannot find \"" + this.getParameters()[0] + "\" !");
            this.statusCode = 147;
            return;
        }
        for (int i = 1; i < this.getParameters().length; ++i) {
            command = command + this.getParameters()[i] + " ";
        }
        if (this.shell == null) {
            this.shell = new ShellCommand();
            this.shell.newParser();
        }
        if (host != null) {
            this.helpRunCommand(host, this.shell, command);
        }
        if (group != null) {
            for (Host aSubHost : group.subHosts) {
                try {
                    this.helpRunCommand(aSubHost, this.shell, command);
                }
                catch (Exception ex) {
                    MOut.println(ex.getMessage());
                }
            }
        }
        this.statusCode = 0;
    }

    public void helpRunCommand(Host host, ShellCommand shell, String command) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(host.getIp());
        if (host.getUsername() == null) {
            config.setUserName(this.config.getUserName());
        } else {
            config.setUserName(host.getUsername());
        }
        if (host.getPassword() == null) {
            config.setPassword(this.config.getPassword());
        } else {
            config.setPassword(host.getPassword());
        }
        config.setTimeout(this.config.getTimeout());
        config.setRetry(this.config.getRetry());
        shell.setConfig(config);
        MOut.println("[" + host.getName() + ":" + host.getIp() + "]");
        shell.processCommand(command);
    }
}

