/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            MOut.println("Gigabit switch Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryGigabitSwitchEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
        if (gb.getPresent() == 0) {
            MOut.println("Gigabit Switch " + index + " is not present");
            this.statusCode = 151;
            return;
        }
        MOut.print(gb.toFormatedHeader());
        MOut.print(gb.toFormatedString());
        this.statusCode = 0;
    }
}

