/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMBladeModeCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.println("CMM Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            MOut.println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        if (this.parameters != null && this.parameters.length == 1) {
            byte bladeMode;
            String strBladeMode = this.parameters[0];
            try {
                bladeMode = (byte)Integer.parseInt(strBladeMode);
            }
            catch (NumberFormatException ex) {
                this.statusCode = 182;
                MOut.print("Parameter invalid");
                return;
            }
            if (bladeMode > 1 || bladeMode < 0) {
                this.statusCode = 182;
                MOut.print("Parameter invalid");
                return;
            }
            boolean result = this.ipmiCMMOEMCommand.setBladeMode(bladeMode);
            if (result) {
                MOut.print("Done");
                this.statusCode = 0;
            } else {
                MOut.print("Failed");
                this.statusCode = 149;
            }
        } else {
            byte bladeMode = this.ipmiCMMOEMCommand.getBladeMode();
            switch (bladeMode) {
                case 0: {
                    MOut.println("Enterprise Blade Mode");
                    break;
                }
                case 1: {
                    MOut.println("Office Blade Mode");
                    break;
                }
                default: {
                    MOut.println("Unknown");
                }
            }
            this.statusCode = 0;
        }
    }
}

