/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCDHCPCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.println("blade Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.println("Blade " + bladeIndex + " is not present");
            this.statusCode = 151;
            return;
        }
        if (!bladeEntity.isSimCardDetectPin()) {
            MOut.println("BMC Not Installed");
            this.statusCode = 149;
            return;
        }
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        if (this.parameters != null && this.parameters.length == 1) {
            String isOn = this.parameters[0];
            boolean result = false;
            if (isOn.equalsIgnoreCase("enable")) {
                result = ipmiLanCommand.setLanSettingType((byte)2);
            } else if (isOn.equalsIgnoreCase("disable")) {
                result = ipmiLanCommand.setLanSettingType((byte)1);
            } else {
                MOut.println("Parameter error!");
                this.statusCode = 147;
                return;
            }
            if (result) {
                MOut.println("Done");
                this.printDHCPStatus(ipmiLanCommand);
                this.statusCode = 0;
            } else {
                MOut.println("Failed");
                this.statusCode = 149;
            }
        } else {
            this.printDHCPStatus(ipmiLanCommand);
            this.statusCode = 0;
        }
    }

    private void printDHCPStatus(IPMILanCommand ipmiLanCommand) {
        byte data = ipmiLanCommand.getLanSettingType();
        switch (data) {
            case 2: {
                MOut.println("DHCP enabled");
                break;
            }
            case 1: {
                MOut.println("stataic IP enabled");
                break;
            }
            default: {
                MOut.println("unknown LAN setting");
            }
        }
    }
}

