/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.sol;

import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.SOLSessionController;
import com.supermicro.ipmi.lang.L;
import com.supermicro.ipmi.sol.SOLPacketSender;
import com.supermicro.ipmi.sol.SOLPanel_jButton1_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jOffButton_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jPowerOnButton_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jResetButton_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jStopButton_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jToggleButton1_actionAdapter;
import com.supermicro.ipmi.sol.SOLPanel_jutf8CheckBox_actionAdapter;
import com.supermicro.ipmi.sol.Storage;
import com.supermicro.ipmi.sol.VT100;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class SOLPanel
extends JPanel
implements Observer {
    String build = "Build:070801";
    Storage storage;
    VT100 vt100;
    SOLPacketSender solPacketSender;
    SOLSessionController solSessionController;
    ProxyConfig proxyConfig;
    private boolean isApplet;
    public boolean isSOLActivated = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JLabel jHostNameLabel = new JLabel();
    JTextField jIPTextField = new JTextField();
    JPanel jControlPanel = new JPanel();
    FlowLayout flowLayout2 = new FlowLayout();
    JLabel jUsernameLabel = new JLabel();
    JTextField jIDTextField = new JTextField();
    JLabel jPasswordLabel = new JLabel();
    JToggleButton jStartToggleButton = new JToggleButton();
    JPanel jStatusBarPanel = new JPanel();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPasswordField jPasswordField = new JPasswordField();
    JCheckBox jEncodeCheckBox = new JCheckBox();
    JButton jStopButton = new JButton();
    JButton jStartButton = new JButton();
    JPanel jPowerControlPanel = new JPanel();
    JButton jResetButton = new JButton();
    JButton jOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    FlowLayout flowLayout3 = new FlowLayout();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    JComboBox jPrivComboBox = new JComboBox();
    JLabel jPrivLabel = new JLabel();
    JCheckBox jutf8CheckBox = new JCheckBox();
    Font utf8Font = null;
    JComboBox fontComboBox = null;
    JLabel jBaudRateLabel = new JLabel();
    JComboBox jBaudRateComboBox = new JComboBox();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel2 = new JPanel();
    JLabel jBuildLabel = new JLabel();

    public SOLPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setLayout(this.borderLayout3);
        this.jHostNameLabel.setText(L.t("sol.Host_name"));
        this.jControlPanel.setLayout(this.flowLayout2);
        this.jControlPanel.setMinimumSize(new Dimension(50, 50));
        this.jIPTextField.setMinimumSize(new Dimension(130, 20));
        this.jIPTextField.setPreferredSize(new Dimension(90, 20));
        this.jIPTextField.setText("192.168.10.246");
        this.jUsernameLabel.setText("    " + L.t("sol.Username"));
        this.jIDTextField.setPreferredSize(new Dimension(60, 20));
        this.jIDTextField.setText("ADMIN");
        this.jPasswordLabel.setToolTipText("");
        this.jPasswordLabel.setText("    " + L.t("sol.Password"));
        this.jStartToggleButton.setText(L.t("sol.Start"));
        this.jStartToggleButton.addActionListener(new SOLPanel_jToggleButton1_actionAdapter(this));
        this.jStatusBarPanel.setLayout(this.borderLayout2);
        this.jStatusBarPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setText(" ");
        this.jPasswordField.setPreferredSize(new Dimension(60, 20));
        this.jPasswordField.setText("ADMIN");
        this.jEncodeCheckBox.setText(L.t("sol.RMCPPLUS_Encryption"));
        this.jEncodeCheckBox.setToolTipText("");
        this.jEncodeCheckBox.setSelected(true);
        this.jStopButton.setEnabled(false);
        this.jStopButton.setText(L.t("sol.Stop"));
        this.jStopButton.addActionListener(new SOLPanel_jStopButton_actionAdapter(this));
        this.jStartButton.setActionCommand("jStartButton");
        this.jStartButton.setText(L.t("sol.Start"));
        this.jStartButton.addActionListener(new SOLPanel_jButton1_actionAdapter(this));
        this.jResetButton.setEnabled(false);
        this.jResetButton.setMargin(new Insets(2, 2, 2, 2));
        this.jResetButton.setText(L.t("sol.Reset"));
        this.jResetButton.addActionListener(new SOLPanel_jResetButton_actionAdapter(this));
        this.jOffButton.setEnabled(false);
        this.jOffButton.setMargin(new Insets(2, 2, 2, 2));
        this.jOffButton.setText(L.t("sol.Off"));
        this.jOffButton.addActionListener(new SOLPanel_jOffButton_actionAdapter(this));
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOnButton.setActionCommand("jOnButton");
        this.jPowerOnButton.setMargin(new Insets(2, 2, 2, 2));
        this.jPowerOnButton.setText(L.t("sol.On"));
        this.jPowerOnButton.addActionListener(new SOLPanel_jPowerOnButton_actionAdapter(this));
        this.flowLayout2.setHgap(1);
        this.flowLayout2.setVgap(1);
        this.jPowerControlPanel.setLayout(this.flowLayout3);
        this.flowLayout3.setHgap(1);
        this.flowLayout3.setVgap(1);
        this.jLabel3.setText("jLabel3");
        this.jLabel4.setText(L.t("sol.Power_Control") + " :");
        this.jPrivLabel.setText("   Priv");
        this.jutf8CheckBox.setText("UTF-8");
        this.jutf8CheckBox.addActionListener(new SOLPanel_jutf8CheckBox_actionAdapter(this));
        this.jBaudRateLabel.setToolTipText("");
        this.jBaudRateLabel.setText("Baud Rate (bps)");
        this.jControlPanel.add(this.jHostNameLabel);
        this.jControlPanel.add(this.jIPTextField);
        this.jControlPanel.add(this.jUsernameLabel);
        this.jControlPanel.add(this.jIDTextField);
        this.jControlPanel.add(this.jPasswordLabel);
        this.jControlPanel.add(this.jPasswordField);
        this.jControlPanel.add(this.jPrivLabel);
        this.jControlPanel.add(this.jPrivComboBox);
        this.jControlPanel.add(this.jBaudRateLabel);
        this.jControlPanel.add(this.jBaudRateComboBox);
        this.jControlPanel.add(this.jutf8CheckBox);
        this.jControlPanel.add(this.jEncodeCheckBox);
        this.jControlPanel.add(this.jStartToggleButton);
        this.jControlPanel.add(this.jStartButton);
        this.jControlPanel.add(this.jStopButton);
        this.add((Component)this.jStatusBarPanel, "South");
        this.jStatusBarPanel.add((Component)this.statusBar, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jStatusBarPanel.add((Component)this.jPowerControlPanel, "East");
        this.jPowerControlPanel.add(this.jLabel4);
        this.jPowerControlPanel.add(this.jPowerOnButton);
        this.jPowerControlPanel.add(this.jOffButton);
        this.jPowerControlPanel.add(this.jResetButton);
        this.jPanel1.add((Component)this.jControlPanel, "Center");
        this.jPanel1.add((Component)this.jPanel2, "East");
        this.jPanel2.add(this.jBuildLabel);
        this.jStartToggleButton.setVisible(false);
        this.jPrivComboBox.addItem("Administrator");
        this.jPrivComboBox.addItem("Operator");
        this.jPrivComboBox.addItem("User");
        this.jPrivComboBox.setSelectedIndex(0);
    }

    private void myInit() {
        this.storage = new Storage();
        this.vt100 = new VT100(this.storage);
        this.vt100.Console.setEnabled(false);
        MessageCenter.getInstance().addObserver(this);
        JPanel panel = new JPanel();
        panel.add(this.vt100.Console);
        this.add((Component)panel, "Center");
        this.jBaudRateComboBox.addItem("9600");
        this.jBaudRateComboBox.addItem("19200");
        this.jBaudRateComboBox.addItem("38400");
        this.jBaudRateComboBox.addItem("57600");
        this.jBaudRateComboBox.addItem("115200");
        this.jBaudRateComboBox.addItem("default");
        this.jBaudRateComboBox.setSelectedIndex(5);
        this.jBuildLabel.setText(this.build);
        this.invalidate();
    }

    public void jToggleButton1_actionPerformed(ActionEvent e) {
        if (this.jIPTextField.getText() == null || this.jIPTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_host_name"));
            return;
        }
        if (this.jIDTextField.getText() == null || this.jIDTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_user_name"));
            return;
        }
        if (this.jPasswordField.getPassword() == null || this.jPasswordField.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_password"));
            return;
        }
        if (this.jStartToggleButton.isSelected()) {
            boolean result = this.startSOL();
            if (result) {
                this.jStartToggleButton.setText("Stop");
            } else {
                this.jStartToggleButton.setSelected(false);
            }
        } else {
            this.stopSOL();
            this.jStartToggleButton.setText("Start");
        }
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setIsApplet(boolean isApplet) {
        this.isApplet = isApplet;
    }

    public void stopSOL() {
        MessageCenter.getInstance().put(this, (Object)L.t("sol.Stopping_SOL"));
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.jIPTextField.getText());
        config.setUserName(this.jIDTextField.getText());
        config.setPassword(new String(this.jPasswordField.getPassword()));
        config.setRetry(0);
        RMCP rmcp = new RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
        if (ipmiMessagingCommand.GetChannelAuthenticationCapabilitiesCommand() == null) {
            this.isSOLActivated = false;
            MessageCenter.getInstance().put(this, (Object)L.t("sol.Host_did_not_exist_SOL_stoped"));
            return;
        }
        boolean r = this.solSessionController.closeSession();
        if (r) {
            this.vt100.Console.setEnabled(false);
        }
        this.solPacketSender.stopSend();
        this.isSOLActivated = false;
        MessageCenter.getInstance().put(this, (Object)L.t("sol.SOL_stoped"));
    }

    public boolean startSOL() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.jIPTextField.getText());
        config.setUserName(this.jIDTextField.getText());
        config.setPassword(new String(this.jPasswordField.getPassword()));
        config.setRetry(2);
        config.setTimeout(4);
        if (this.jEncodeCheckBox.isSelected()) {
            config.setCipherSuiteID((byte)3);
        } else {
            config.setCipherSuiteID((byte)1);
        }
        if (this.jPrivComboBox.getSelectedItem().equals("Administraotr")) {
            config.setPrivilege((byte)4);
        } else if (this.jPrivComboBox.getSelectedItem().equals("Operator")) {
            config.setPrivilege((byte)3);
        }
        config.setProxyConfig(this.proxyConfig);
        this.solSessionController = new SOLSessionController();
        if (this.jBaudRateComboBox.getSelectedIndex() != 5) {
            this.solSessionController.setBaudRate((byte)(this.jBaudRateComboBox.getSelectedIndex() + 6));
        }
        IPMINetworkInterface ipmiInterface = this.solSessionController.startup(config);
        if (this.solSessionController.isSOLActivated) {
            MessageCenter.getInstance().put(this, (Object)L.t("sol.SOL_activate_OK"));
            this.storage.reset();
            this.solPacketSender = new SOLPacketSender(this.storage, this.solSessionController);
            this.solPacketSender.start();
            ipmiInterface.addObserver(this.solSessionController);
            ipmiInterface.addObserver(this.vt100);
            this.isSOLActivated = true;
            return true;
        }
        MessageCenter.getInstance().put(this, (Object)L.t("sol.SOL_activate_failed"));
        if (ipmiInterface != null) {
            this.solSessionController.closeSession();
        }
        return false;
    }

    public void update(Observable o, Object arg) {
        MessageCenter.ClassMessage cm = (MessageCenter.ClassMessage)arg;
        if (cm.from.equals("com.supermicro.ipmi.RMCPSessionController")) {
            return;
        }
        if (cm.from.equals("com.supermicro.ipmi.RMCPPlusSessionController")) {
            return;
        }
    }

    public boolean isIsApplet() {
        return this.isApplet;
    }

    public void jStartButton_actionPerformed(ActionEvent e) {
        if (this.jIPTextField.getText() == null || this.jIPTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_host_name"));
            return;
        }
        if (this.jIDTextField.getText() == null || this.jIDTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_user_name"));
            return;
        }
        if (this.jPasswordField.getPassword() == null || this.jPasswordField.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this, L.t("sol.Please_input_password"));
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                boolean result = SOLPanel.this.startSOL();
                if (result) {
                    SOLPanel.this.jStopButton.setEnabled(true);
                    SOLPanel.this.jStartButton.setEnabled(false);
                    SOLPanel.this.jPowerOnButton.setEnabled(true);
                    SOLPanel.this.jResetButton.setEnabled(true);
                    SOLPanel.this.jOffButton.setEnabled(true);
                    SOLPanel.this.vt100.Console.setEnabled(true);
                } else {
                    SOLPanel.this.jStopButton.setEnabled(false);
                    SOLPanel.this.jStartButton.setEnabled(true);
                    SOLPanel.this.jPowerOnButton.setEnabled(false);
                    SOLPanel.this.jResetButton.setEnabled(false);
                    SOLPanel.this.jOffButton.setEnabled(false);
                    SOLPanel.this.vt100.Console.setEnabled(false);
                }
            }
        };
        thread.start();
    }

    public boolean startSOLNoThread() {
        boolean result = this.startSOL();
        if (result) {
            this.jStopButton.setEnabled(true);
            this.jStartButton.setEnabled(false);
            this.jPowerOnButton.setEnabled(true);
            this.jResetButton.setEnabled(true);
            this.jOffButton.setEnabled(true);
            this.vt100.Console.setEnabled(true);
        } else {
            this.jStopButton.setEnabled(false);
            this.jStartButton.setEnabled(true);
            this.jPowerOnButton.setEnabled(false);
            this.jResetButton.setEnabled(false);
            this.jOffButton.setEnabled(false);
            this.vt100.Console.setEnabled(false);
        }
        return result;
    }

    public void jStopButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SOLPanel.this.jStopButton.setEnabled(false);
                SOLPanel.this.stopSOL();
                SOLPanel.this.jStartButton.setEnabled(true);
                SOLPanel.this.jPowerOnButton.setEnabled(false);
                SOLPanel.this.jResetButton.setEnabled(false);
                SOLPanel.this.jOffButton.setEnabled(false);
            }
        };
        thread.start();
    }

    public void jResetButton_actionPerformed(ActionEvent e) {
        int dialogResult = JOptionPane.showConfirmDialog(this, L.t("sol.Are_you_sure_to_reset_system"), "", 0);
        if (dialogResult == 0) {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp(this.jIPTextField.getText());
            config.setUserName(this.jIDTextField.getText());
            config.setPassword(new String(this.jPasswordField.getPassword()));
            if (this.jPrivComboBox.getSelectedItem().equals("Administraotr")) {
                config.setPrivilege((byte)4);
            } else if (this.jPrivComboBox.getSelectedItem().equals("Operator")) {
                config.setPrivilege((byte)3);
            }
            if (this.isApplet) {
                config.setProxyConfig(this.proxyConfig);
            }
            ISessionController sessionController = IPMIVersion.getSessionController(config);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            IPMINetworkInterface rmcp = sessionController.startup(config);
            if (rmcp == null) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.reset_failed"));
                return;
            }
            ipmiChassisCommand.setIPMIInterface(rmcp);
            boolean result = ipmiChassisCommand.reset();
            if (result) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.reset_ok"));
            } else {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.reset_failed"));
            }
            sessionController.closeSession();
        }
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        int dialogResult = JOptionPane.showConfirmDialog(this, L.t("sol.Are_you_sure_to_power_on_system"), "", 0);
        if (dialogResult == 0) {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp(this.jIPTextField.getText());
            config.setUserName(this.jIDTextField.getText());
            config.setPassword(new String(this.jPasswordField.getPassword()));
            if (this.jPrivComboBox.getSelectedItem().equals("Administraotr")) {
                config.setPrivilege((byte)4);
            } else if (this.jPrivComboBox.getSelectedItem().equals("Operator")) {
                config.setPrivilege((byte)3);
            }
            if (this.isApplet) {
                config.setProxyConfig(this.proxyConfig);
            }
            ISessionController sessionController = IPMIVersion.getSessionController(config);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            IPMINetworkInterface rmcp = sessionController.startup(config);
            if (rmcp == null) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_on_failed"));
                return;
            }
            ipmiChassisCommand.setIPMIInterface(rmcp);
            boolean result = ipmiChassisCommand.powerUp();
            if (result) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_on_ok"));
            } else {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_on_failed"));
            }
            sessionController.closeSession();
        }
    }

    public void jOffButton_actionPerformed(ActionEvent e) {
        int dialogResult = JOptionPane.showConfirmDialog(this, L.t("sol.Are_you_sure_to_power_off_system"), "", 0);
        if (dialogResult == 0) {
            IPMIInterfaceConfig config = new IPMIInterfaceConfig();
            config.setIp(this.jIPTextField.getText());
            config.setUserName(this.jIDTextField.getText());
            config.setPassword(new String(this.jPasswordField.getPassword()));
            if (this.jPrivComboBox.getSelectedItem().equals("Administraotr")) {
                config.setPrivilege((byte)4);
            } else if (this.jPrivComboBox.getSelectedItem().equals("Operator")) {
                config.setPrivilege((byte)3);
            }
            if (this.isApplet) {
                config.setProxyConfig(this.proxyConfig);
            }
            ISessionController sessionController = IPMIVersion.getSessionController(config);
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
            IPMINetworkInterface rmcp = sessionController.startup(config);
            if (rmcp == null) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_off_failed"));
                return;
            }
            ipmiChassisCommand.setIPMIInterface(rmcp);
            boolean result = ipmiChassisCommand.powerDown();
            if (result) {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_off_ok"));
            } else {
                MessageCenter.getInstance().put(this, (Object)L.t("sol.power_off_failed"));
            }
            sessionController.closeSession();
        }
    }

    public void setIP(String ip) {
        this.jIPTextField.setText(ip);
    }

    public void setUsername(String username) {
        this.jIDTextField.setText(username);
    }

    public void setPassword(String pw) {
        this.jPasswordField.setText(pw);
    }

    public void hideLoginInfo() {
        this.jHostNameLabel.setVisible(false);
        this.jIPTextField.setVisible(false);
        this.jUsernameLabel.setVisible(false);
        this.jIDTextField.setVisible(false);
        this.jPasswordLabel.setVisible(false);
        this.jPasswordField.setVisible(false);
        this.jBaudRateComboBox.setVisible(false);
        this.jBaudRateLabel.setVisible(false);
    }

    public void removeToolBar() {
        this.remove(this.jPanel1);
    }

    public void hideLoginInfoForApplet() {
        this.jHostNameLabel.setVisible(false);
        this.jIPTextField.setVisible(false);
        this.jUsernameLabel.setVisible(false);
        this.jIDTextField.setVisible(false);
        this.jPasswordLabel.setVisible(false);
        this.jPasswordField.setVisible(false);
        this.jPrivLabel.setVisible(false);
        this.jPrivComboBox.setVisible(false);
        this.jutf8CheckBox.setVisible(false);
        this.jEncodeCheckBox.setVisible(false);
    }

    public void hidePowerControlPanel() {
        this.jPowerControlPanel.setVisible(false);
    }

    public void hideUIForCMM() {
        this.jHostNameLabel.setVisible(false);
        this.jIPTextField.setVisible(false);
        this.jUsernameLabel.setVisible(false);
        this.jIDTextField.setVisible(false);
        this.jPasswordLabel.setVisible(false);
        this.jPasswordField.setVisible(false);
        this.jBaudRateComboBox.setVisible(false);
        this.jBaudRateLabel.setVisible(false);
        this.jPrivComboBox.setVisible(false);
        this.jBuildLabel.setVisible(false);
        this.jEncodeCheckBox.setVisible(false);
        this.jPrivLabel.setVisible(false);
        this.jStatusBarPanel.setVisible(false);
        this.jPanel1.setBorder(null);
        this.add((Component)this.jPanel1, "South");
    }

    public void setEditableSOL(boolean isEnable) {
        this.vt100.Console.setEnabled(isEnable);
    }

    public void jutf8CheckBox_actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SOLPanel.this.helpJutf8Change();
            }
        });
    }

    private void helpJutf8Change() {
        Font messageFont = null;
        if (this.vt100 == null) {
            return;
        }
        if (this.jutf8CheckBox.isSelected()) {
            if (this.utf8Font == null) {
                Vector fontCollected = this.testDisplayUTF8Font();
                if (fontCollected == null || fontCollected.size() == 0) {
                    return;
                }
                this.utf8Font = (Font)fontCollected.get(0);
                this.utf8Font = new Font(this.utf8Font.getFontName(), 0, 12);
                if (fontCollected.size() > 1) {
                    this.helpAddFont(fontCollected);
                }
            }
            if (this.utf8Font == null) {
                this.utf8Font = new Font("SimSun", 0, 12);
            }
            messageFont = this.utf8Font;
            this.vt100.setEnableUTF8(true);
            if (this.fontComboBox != null) {
                this.fontComboBox.setEnabled(true);
            }
        } else {
            messageFont = new Font("Courier New", 0, 12);
            FontMetrics fm = this.getFontMetrics(messageFont);
            if (fm.charWidth('i') != fm.charWidth('W')) {
                messageFont = new Font("Courier", 0, 12);
            }
            this.vt100.setEnableUTF8(false);
            if (this.fontComboBox != null) {
                this.fontComboBox.setEnabled(false);
            }
        }
        this.vt100.Console.setFont(messageFont);
        this.vt100.InvalidateRect();
    }

    public void helpAddFont(Vector fontCollected) {
        this.fontComboBox = new JComboBox();
        for (Font item : fontCollected) {
            this.fontComboBox.addItem(item.getFontName());
        }
        this.fontComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String fontString = (String)SOLPanel.this.fontComboBox.getSelectedItem();
                        SOLPanel.this.utf8Font = new Font(fontString, 0, 12);
                        SOLPanel.this.vt100.Console.setFont(SOLPanel.this.utf8Font);
                        SOLPanel.this.vt100.InvalidateRect();
                    }
                });
            }
        });
        Vector<Component> controls = new Vector<Component>();
        for (int i = 0; i < this.jControlPanel.getComponentCount(); ++i) {
            controls.add(this.jControlPanel.getComponent(i));
        }
        controls.insertElementAt(this.fontComboBox, 9);
        this.jControlPanel.removeAll();
        for (Component item : controls) {
            this.jControlPanel.add(item);
        }
    }

    public Vector testDisplayUTF8Font() {
        Vector<Font> fontCollected = new Vector<Font>();
        String sample = "\u3057\u307e\u3057\u305f";
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int q = 0;
        this.setCursor(new Cursor(3));
        for (int j = 0; j < fonts.length; ++j) {
            q = fonts[j].canDisplayUpTo(sample);
            if (q != -1 && q != sample.length()) continue;
            fontCollected.add(fonts[j]);
        }
        this.setCursor(new Cursor(0));
        return fontCollected;
    }
}

