/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;
import java.util.ArrayList;

public class CommandForReadingSensors
extends Command {
    public static String SENSOR_RESULTS = "SENSOR_RESULTS";

    public Result execute(Host host) {
        ArrayList sensorResults = new ArrayList();
        byte sensorType = 0;
        if (this.option != null && this.option instanceof Byte) {
            sensorType = (Byte)this.option;
        }
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.description = L.t("group.Cannot_login_to") + host.getIp();
        }
        ipmiSDRCommand.setIPMIInterface(rmcp);
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        if (host.sdrInfo == null) {
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                result.booleanResult = false;
                result.description = L.t("group.Cannot_execute_get_SDR_info_command");
                sessionController.closeSession();
                return result;
            }
            host.sdrInfo = sdrInfo;
            ArrayList sdrRecords = ipmiSDRCommand.getSDRs(host.sdrInfo.getRecordCount());
            if (sdrRecords != null) {
                host.sdrRecords = sdrRecords;
            } else {
                result.booleanResult = false;
                result.description = L.t("group.Cannot_execute_get_SDR_Records_command");
                sessionController.closeSession();
                return result;
            }
        }
        result.description = result.description + "\n";
        for (SDRRecord item : host.sdrRecords) {
            if (this.option != null && sensorType != 0 && !(sensorType != SDRRecord.SENSOR_TYPE_POWER_SUPPLY_AND_INTRUSION ? item.getSensorType() == sensorType || sensorType == SDRRecord.SENSOR_TYPE_TEMPERATURE && item.getSensorType() == SDRRecord.SENSOR_TYPE_TEXT_TEMPERATURE : item.getSensorType() == SDRRecord.SENSOR_TYPE_INTRUSION || item.getSensorType() == SDRRecord.SENSOR_TYPE_POWER_SUPPLY)) continue;
            if (item.getSensorType() != 5 && item.getSensorType() != 8 && item.getSensorType() != -64) {
                byte value = 0;
                String reading = "";
                String hi = "";
                String low = "";
                boolean isValueAvailable = true;
                value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
                if (value != -1) {
                    reading = item.doubleToString(item.calSensorReading(value & 0xFF));
                } else {
                    reading = "?";
                    isValueAvailable = false;
                }
                hi = item.doubleToString(item.getHiLimit());
                low = item.doubleToString(item.getLowLimit());
                result.description = result.description + item.getSensorName() + " \t" + "value = " + reading + "(" + item.getUnit() + ") \t Low = " + low + " \t Hi = " + hi + "\n";
                item.setCurrentValue(value);
                item.setIsValueAvailable(isValueAvailable);
                continue;
            }
            byte[] value = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
            if (item.getSensorType() == SDRRecord.SENSOR_TYPE_TEXT_TEMPERATURE) {
                if (value == null) continue;
                byte rawValue = value[2];
                rawValue = (value[1] & 0x20) > 0 ? (byte)7 : value[2];
                item.setCurrentValue(rawValue);
                continue;
            }
            if (item.getSensorType() == SDRRecord.SENSOR_TYPE_INTRUSION) {
                if (value != null) {
                    result.description = (value[2] & 1) == 1 ? result.description + "Chassis Opened ! \n" : result.description + "Chassis OK \n";
                    item.setCurrentValue(value[2]);
                    item.setIsValueAvailable(true);
                    continue;
                }
                result.description = result.description + "Chassis Intrusion state unknown ! \n";
                item.setCurrentValue((byte)-1);
                item.setIsValueAvailable(false);
                continue;
            }
            if (item.getSensorType() != SDRRecord.SENSOR_TYPE_POWER_SUPPLY) continue;
            if (value != null) {
                if (ipmiGlobalCommand.isOSA()) {
                    result.description = (value[2] & 2) == 0 ? result.description + "Power Supply Failed !\n" : result.description + "Power Supply OK\n";
                    item.setCurrentValue(value[2]);
                } else {
                    result.description = value[2] == 0 ? result.description + "Power Supply OK !\n" : result.description + "Power Supply Failed\n";
                    item.setCurrentValue((byte)2);
                }
                item.setIsValueAvailable(true);
                continue;
            }
            result.description = result.description + "Power Supply state unknown ! \n";
            item.setCurrentValue((byte)-1);
            item.setIsValueAvailable(false);
        }
        result.booleanResult = true;
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get Sensors Reading";
    }
}

