/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.FRUInfo;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingFRU
extends Command {
    public static final String FRU_INFO = "FRU_INFO";

    public Result execute(Host host) {
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiFRUCommand.setIPMIInterface(rmcp);
        FRUInfo fruInfo = ipmiFRUCommand.getFRUData();
        if (fruInfo != null) {
            result.booleanResult = true;
            result.description = result.description + "\n";
            result.description = result.description + fruInfo.toString();
            result.setSingleData(FRU_INFO, fruInfo);
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Get_FRU_info_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get FRU Info";
    }
}

