/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;

public class SessionInfo {
    private byte sessionHandle;
    private byte numberOfPossibleActiveSessions;
    private byte numberOfCurrentlyActiveSessions;
    private byte userID;
    private byte operatingPrivilegeLevel;
    private byte sessionProtocol;
    private byte[] ipAddress = new byte[4];
    private byte[] macAddress = new byte[6];
    private byte[] portNumber = new byte[2];

    public static SessionInfo fromRaw(byte[] raw) {
        if (raw.length != 18) {
            return null;
        }
        SessionInfo sessionInfo = new SessionInfo();
        int index = 0;
        sessionInfo.sessionHandle = raw[index];
        sessionInfo.numberOfPossibleActiveSessions = raw[++index];
        sessionInfo.numberOfCurrentlyActiveSessions = raw[++index];
        sessionInfo.userID = raw[++index];
        sessionInfo.operatingPrivilegeLevel = raw[++index];
        sessionInfo.sessionProtocol = raw[++index];
        System.arraycopy(raw, ++index, sessionInfo.ipAddress, 0, 4);
        System.arraycopy(raw, index += 4, sessionInfo.macAddress, 0, 6);
        System.arraycopy(raw, index += 6, sessionInfo.portNumber, 0, 2);
        return sessionInfo;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n SessionHandler = " + ByteUtility.byteToHex(this.sessionHandle) + "h");
        sb.append("\n Number of possible active sessions = " + this.numberOfPossibleActiveSessions);
        sb.append("\n Number of currently active sessions = " + this.numberOfCurrentlyActiveSessions);
        sb.append("\n User ID = " + ByteUtility.byteToHex(this.userID) + "h");
        sb.append("\n Operating Privilege Level = " + ByteUtility.byteToHex(this.operatingPrivilegeLevel) + "h");
        sb.append("\n Session protocol auxiliary data = " + ByteUtility.byteToHex(this.sessionProtocol) + "h");
        sb.append("\n IP Address of remote console = " + ByteUtility.bytesToHex(this.ipAddress) + "(" + this.getFormatedIPAddress() + ")");
        sb.append("\n Mac Address of remote console= " + ByteUtility.bytesToHex(this.macAddress) + "(" + this.getFormatedMACAddress() + ")");
        sb.append("\n Port Number = " + ByteUtility.bytesToHex(this.portNumber) + "(" + this.getFormatedPortNumber() + ")");
        return sb.toString();
    }

    public void setSessionHandle(byte sessionHandle) {
        this.sessionHandle = sessionHandle;
    }

    public void setNumberOfPossibleActiveSessions(byte numberOfPossibleActiveSessions) {
        this.numberOfPossibleActiveSessions = numberOfPossibleActiveSessions;
    }

    public void setNumberOfCurrentlyActiveSession(byte numberOfCurrentlyActiveSession) {
        this.numberOfCurrentlyActiveSessions = numberOfCurrentlyActiveSession;
    }

    public void setUserID(byte userID) {
        this.userID = userID;
    }

    public void setOperatingPrivilegeLevel(byte operatingPrivilegeLevel) {
        this.operatingPrivilegeLevel = operatingPrivilegeLevel;
    }

    public void setSessionProtocol(byte sessionProtocol) {
        this.sessionProtocol = sessionProtocol;
    }

    public void setIpAddress(byte[] ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setMacAddress(byte[] macAddress) {
        this.macAddress = macAddress;
    }

    public void setPortNumber(byte[] portNumber) {
        this.portNumber = portNumber;
    }

    public byte getSessionHandle() {
        return this.sessionHandle;
    }

    public byte getNumberOfPossibleActiveSessions() {
        return this.numberOfPossibleActiveSessions;
    }

    public byte getNumberOfCurrentlyActiveSession() {
        return this.numberOfCurrentlyActiveSessions;
    }

    public byte getUserID() {
        return this.userID;
    }

    public byte getOperatingPrivilegeLevel() {
        return this.operatingPrivilegeLevel;
    }

    public byte getSessionProtocol() {
        return this.sessionProtocol;
    }

    public byte[] getIpAddress() {
        return this.ipAddress;
    }

    public byte[] getMacAddress() {
        return this.macAddress;
    }

    public byte[] getPortNumber() {
        return this.portNumber;
    }

    public String getFormatedMACAddress() {
        String mac = ByteUtility.byteToHex(this.macAddress[0]) + ":" + ByteUtility.byteToHex(this.macAddress[1]) + ":" + ByteUtility.byteToHex(this.macAddress[2]) + ":" + ByteUtility.byteToHex(this.macAddress[3]) + ":" + ByteUtility.byteToHex(this.macAddress[4]) + ":" + ByteUtility.byteToHex(this.macAddress[5]);
        return mac;
    }

    public String getFormatedIPAddress() {
        String ip = "" + (this.ipAddress[0] & 0xFF) + "." + (this.ipAddress[1] & 0xFF) + "." + (this.ipAddress[2] & 0xFF) + "." + (this.ipAddress[3] & 0xFF);
        return ip;
    }

    public int getFormatedPortNumber() {
        return ByteUtility.twoBytesToIntMSB(this.portNumber);
    }
}

