/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.lang.L;
import java.util.ArrayList;
import java.util.Calendar;

public class IPMISELCommand
extends IPMICommand {
    public IPMISELCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getSELInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ReserveSELCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)66, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSELEntryCommand(byte[] reservationID, byte[] recordID, byte offset) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 2, 2);
        data[4] = offset;
        data[5] = -1;
        ipmiMessage.setCommandAndData((byte)40, (byte)67, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage addSELEntryCommand(byte[] record) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[16];
        System.arraycopy(record, 0, data, 0, 16);
        ipmiMessage.setCommandAndData((byte)40, (byte)68, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearSELEntryCommand(byte[] reservationID, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        data[2] = 67;
        data[3] = 76;
        data[4] = 82;
        data[5] = action;
        ipmiMessage.setCommandAndData((byte)40, (byte)71, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage deleteSELEntryCommand(byte[] reservationID, byte[] recordID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 0, 2);
        ipmiMessage.setCommandAndData((byte)40, (byte)70, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSELTimeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)72, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSELTimeCommand(byte[] time) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(time, 0, data, 0, 4);
        ipmiMessage.setCommandAndData((byte)40, (byte)73, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public SELInfo getSELInfoModal() {
        IPMIMessage resMessage = this.getSELInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return SELInfo.fromRaw(resMessage.data);
            }
            if (resMessage.completionCode == 129) {
                MessageCenter.getInstance().put(this, (Object)"cannot execute command, SEL erase in progress");
            } else {
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get sel info");
        return null;
    }

    public ArrayList getSELEntries(int length) {
        ArrayList<SELRecord> list = new ArrayList<SELRecord>();
        byte[] recordID = new byte[2];
        byte offset = 0;
        byte[] reservationID = this.getSELReservationID();
        if (reservationID == null) {
            reservationID = new byte[]{0, 0};
        }
        for (int i = 0; i < length; ++i) {
            MessageCenter.getInstance().put(this, (Object)(L.t("sel.Getting_SEL_entry") + " (" + (i + 1) + "/" + length + ")"));
            IPMIMessage resMessage = this.getSELEntryCommand(reservationID, recordID, offset);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    byte[] byte16 = new byte[16];
                    System.arraycopy(resMessage.data, 2, byte16, 0, 16);
                    list.add(SELRecord.fromRaw(byte16));
                    System.arraycopy(resMessage.data, 0, recordID, 0, 2);
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SEL entry");
            break;
        }
        return list;
    }

    public ArrayList getSELEntriesByRange(int from, int to) {
        ArrayList<SELRecord> list = new ArrayList<SELRecord>();
        byte[] recordID = new byte[2];
        byte offset = 0;
        recordID[0] = (byte)from;
        recordID[1] = (byte)(from >> 8);
        byte[] reservationID = this.getSELReservationID();
        if (reservationID == null) {
            reservationID = new byte[]{0, 0};
        }
        for (int i = from - 1; i < to; ++i) {
            MessageCenter.getInstance().put(this, (Object)(L.t("sel.Getting_SEL_entry") + " (" + (i - from + 2) + "/" + (to - from + 1) + ")"));
            IPMIMessage resMessage = this.getSELEntryCommand(reservationID, recordID, offset);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    byte[] byte16 = new byte[16];
                    System.arraycopy(resMessage.data, 2, byte16, 0, 16);
                    list.add(SELRecord.fromRaw(byte16));
                    System.arraycopy(resMessage.data, 0, recordID, 0, 2);
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SEL entry");
            break;
        }
        return list;
    }

    public byte[] getSELReservationID() {
        IPMIMessage resMessage = this.ReserveSELCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Reserve SEL ID");
        return null;
    }

    public String getSELTimeWithFormat() {
        IPMIMessage resMessage = this.getSELTimeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return ByteUtility.fourByteToDate(resMessage.data);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get SEL Time");
        return null;
    }

    public boolean setSELTimeByCalendar(Calendar c) {
        long time = c.getTime().getTime();
        time += (long)Calendar.getInstance().get(15);
        byte[] byte4 = new byte[4];
        ByteUtility.intTo4Bytes(byte4, 0, (int)(time /= 1000L));
        IPMIMessage resMessage = this.setSELTimeCommand(byte4);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set SEL Time");
        return false;
    }

    public boolean clearSEL() {
        byte[] reservationID = this.getSELReservationID();
        if (reservationID == null) {
            return false;
        }
        byte action = -86;
        IPMIMessage resMessage = this.clearSELEntryCommand(reservationID, action);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Clear SEL entry");
        return false;
    }

    public boolean deleteSEL(int index) {
        byte[] reservationID = this.getSELReservationID();
        byte[] recordID = new byte[2];
        if (reservationID == null) {
            return false;
        }
        recordID[0] = (byte)index;
        recordID[1] = (byte)(index >> 8);
        IPMIMessage resMessage = this.deleteSELEntryCommand(reservationID, recordID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Delete SEL entry");
        return false;
    }

    public boolean addSEL(byte[] record) {
        IPMIMessage resMessage = this.addSELEntryCommand(record);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"operation not supported for this Record Type");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"cannot execute command, SEL erase in progress");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Add SEL Time");
        return false;
    }

    public static void main_addsel(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.192");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSELCommand.setIPMIInterface(rmcp);
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        byte[] selRecord = new byte[]{3, 0, 2, 17, -84, -53, 67, 32, 0, 4, 4, 12, 1, 84, 0, 18};
        boolean result = ipmiSELCommand.addSEL(selRecord);
        if (result) {
            System.out.println("Add SEL ok");
        } else {
            System.out.println("add SEL failed");
        }
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        System.out.println("log entrys after add = " + selInfo.getLogEntries());
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        ArrayList list;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.157");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSELCommand.setIPMIInterface(rmcp);
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        if (selInfo != null) {
            MessageCenter.getInstance().put(selInfo.toString());
        }
        if ((list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries())).size() != 0) {
            for (SELRecord item : list) {
                MessageCenter.getInstance().put(item.toString());
                String msg = ByteUtility.fourByteToDate(item.getTimeStamp()) + "\t" + GlobalDefine.getSensorType(item.getSensorType() & 0xFF) + "\t" + SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF)) + "\t" + GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3());
                if (item.getEventType() == 1) {
                    String compare = "";
                    byte offset = item.getEventData1();
                    double reading = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData2() & 0xFF);
                    double threshold = ((SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF))).calSensorReading(item.getEventData3() & 0xFF);
                    msg = msg + " (reading =" + reading + ",threshold =" + threshold + ") ";
                }
                MessageCenter.getInstance().put(msg);
            }
        } else {
            MessageCenter.getInstance().put("get sel entry failed");
        }
        sessionController.closeSession();
    }

    public static void main_set_test(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        for (int i = 0; i < 100000; ++i) {
            System.out.println("i =" + i);
            IPMISELCommand.getSELTest();
            if (i % 1000 != 0) continue;
        }
    }

    public static void getSELTest() {
        ArrayList list;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.237");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSELCommand.setIPMIInterface(rmcp);
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        if (selInfo != null) {
            MessageCenter.getInstance().put(selInfo.toString());
        }
        if ((list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries())).size() != 0) {
            for (SELRecord item : list) {
                String msg = ByteUtility.fourByteToDate(item.getTimeStamp()) + "\t" + GlobalDefine.getSensorType(item.getSensorType() & 0xFF) + "\t" + SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF)) + "\t" + GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3());
                MessageCenter.getInstance().put(msg);
            }
        } else {
            MessageCenter.getInstance().put("get sel entry failed");
        }
        sessionController.closeSession();
    }
}

