/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.KIRAConfiguration;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.algo.AES_CBC_128;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class IPMIOEMCommand
extends IPMICommand {
    static AES_CBC_128 aes = new AES_CBC_128();
    static byte[] iv = new byte[16];
    static byte[] key = new byte[16];
    public static final byte SIM_LAN_TYPE_DEDICATED = 0;
    public static final byte SIM_LAN_TYPE_SHARED = 1;
    public static final byte SIM_LAN_ETH0 = 1;
    public static final byte SIM_LAN_ETH1 = 2;
    public static final byte SIM_LAN_TCO_FML = 3;
    public static final byte SIM_LAN_MCP55 = 4;
    public static final byte SIM_LAN_ECO_I2C = 5;
    public String[][] idToBoard = new String[][]{{"X7DB8", "80", "80"}, {"X7DA8", "81", "80"}, {"PDSMI-LN4", "82", "80"}, {"X7DBP-X", "83", "80"}, {"X7DBR-8+", "84", "80"}, {"H8DCR-3", "11", "11"}, {"PDSML", "85", "80"}, {"H8DC8", "12", "11"}, {"X7DVL", "86", "80"}, {"PDSBA", "87", "80"}, {"X7DBX", "88", "80"}, {"X7DBP-8", "89", "80"}, {"X7DB8-X", "90", "80"}, {"PDSME+", "91", "80"}, {"X7DBR-3", "92", "80"}, {"PDSLM", "93", "80"}, {"X7DAL-E", "94", "80"}, {"H8QM8-2", "13", "11"}, {"H8DA8-2", "14", "11"}, {"H8DMR-82", "15", "11"}, {"H8DM8-2", "16", "11"}, {"H8SMI-2", "17", "11"}, {"X6QT8", "95", "80"}, {"X7DBN", "96", "80"}, {"X7DBU", "97", "80"}, {"X7DVL-3", "A0", "80"}, {"PDSMU+", "98", "80"}, {"X7DBT", "99", "80"}, {"B7DBE", "B0", "80"}, {"H8SSL-I2", "18", "11"}, {"H8DM3-2", "A0", "11"}, {"X7DBI+", "B1", "80"}, {"H8DMU", "19", "11"}, {"H8DA3-2", "A1", "11"}, {"H8SMU", "20", "11"}, {"X7DVL-L", "B2", "80"}, {"X7DWN", "B3", "80"}, {"AOC-UG-i4", "B4", "80"}, {"X7DW3+", "A2", "80"}, {"PDSBM-LN2", "B5", "80"}, {"X7DGT-ATOKAP ", "B6", "80"}, {"AOC-USAS-L8I", "A5", "80"}, {"C2SBA", "B7", "80"}, {"X7SBi", "D1", "80"}, {"X7QC3", "A3", "80"}, {"H8QM3-2", "A2", "11"}, {"X7DCL-3", "A4", "80"}, {"X7DCA-3/i", "D6", "80"}, {"C2SBX", "BA", "80"}, {"X7SB4/E", "D2", "80"}, {"M8QME", "21", "11"}, {"X7SBA", "D3", "80"}, {"X7DWT/-INF", "BC", "80"}, {"C2SBM", "BD", "80"}, {"C2SBC", "BE", "80"}, {"AOC-USAS-H4i", "C0", "80"}, {"AOC-USAS-H8i", "C1", "80"}, {"X7SBL-LN1/LN2", "AA", "80"}, {"C2SBC", "BE", "80"}, {"C2SBi", "BF", "80"}, {"C2SBM-Q", "AB", "80"}, {"X7SBi-LN4", "D4", "80"}, {"BHQME", "AD", "11"}, {"X7SBF", "D5", "80"}, {"AOC-UTG-I2", "AF", "80"}, {"PDSMP-JN001", "AE", "80"}, {"B7DW3", "C2", "80"}, {"X7DWU", "AC", "8080"}, {"X7DWP", "D0", "80"}, {"C2SBM-Q", "DA", "80"}, {"X7DCU", "DB", "80"}, {"X7DCA-L", "DC", "80"}, {"X7SBX", "DD", "80"}, {"X7DCA-3/i", "A6", "80"}, {"X7DCT-10G", "DE", "80"}, {"X7DWT-C-SG007", "AA", "80"}, {"X7DWE", "DF", "80"}, {"B7DCE", "BB", "80"}, {"H8DMT", "22", "11"}, {"B7DC3", "A7", "80"}, {"X7SBT", "F0", "80"}, {"X7SBU", "F1", "80"}};

    public IPMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage clearChassisIntrusionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)3, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage gracefulPowerControlCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isUIDPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)13, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage disableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)14, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getProductIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setProductIDCommand(byte[] productID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0, 0, 2, 0, 0, 0, 0, 0};
        data[0] = productID[1];
        data[1] = productID[0];
        ipmiMessage.setCommandAndData((byte)-64, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSIMxxLanDriverCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)20, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkNoVMandWebCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOEMCommandSupported(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)41, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isOfficeBladeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)65, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isBackupAndRestoreFuncExistCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)40, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean gracefulPowerCycle() {
        byte command = 3;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerCycle");
        return false;
    }

    public boolean gracefulPowerReset() {
        byte command = 2;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerReset");
        return false;
    }

    public boolean gracefulPowerShutDown() {
        byte command = 1;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerShutDown");
        return false;
    }

    public boolean clearChassisIntrusion() {
        IPMIMessage resMessage = this.clearChassisIntrusionCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute clear chassis intrusion command");
        return false;
    }

    public boolean enableUIDLED() {
        IPMIMessage resMessage = this.enableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute enable UID LED");
        return false;
    }

    public boolean disableUIDLED() {
        IPMIMessage resMessage = this.disableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute disable UID LED");
        return false;
    }

    public boolean isUIDPresent() {
        IPMIMessage resMessage = this.isUIDPresentCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isUIDPresent");
        return false;
    }

    public byte[] getProductID() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[0], resMessage.data[1]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Product ID");
        return null;
    }

    public boolean setProductID(byte[] productID) {
        IPMIMessage resMessage = this.setProductIDCommand(productID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute set Product ID");
        return false;
    }

    public byte[] getBoardModelByte() {
        byte[] productID = this.getProductID();
        return productID;
    }

    public String getBoardModel() {
        byte[] productID = this.getProductID();
        if (productID != null) {
            for (int i = 0; i < this.idToBoard.length; ++i) {
                if (!this.idToBoard[i][1].equals(ByteUtility.byteToHex(productID[0])) || !this.idToBoard[i][2].equals(ByteUtility.byteToHex(productID[1]))) continue;
                return this.idToBoard[i][0];
            }
        }
        return null;
    }

    public byte[] getSensors() {
        IPMIMessage resMessage = this.getSensorsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Sensors");
        return null;
    }

    public byte[] getSIMxxLanDriver() {
        IPMIMessage resMessage = this.getSIMxxLanDriverCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get getSIMxxLanDriver");
        return null;
    }

    public boolean checkNoVMAndWeb() {
        IPMIMessage resMessage = this.checkNoVMandWebCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute checkNoVMandWebCommand");
        return false;
    }

    public boolean isOfficeBlade() {
        IPMIMessage resMessage = this.isOfficeBladeCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOfficeBlade");
        return false;
    }

    public boolean isBackupAndRestoreFuncExist() {
        IPMIMessage resMessage = this.isBackupAndRestoreFuncExistCommand();
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isBackupAndRestoreFuncExist");
        return false;
    }

    public boolean backupConfiguration(File selFile, boolean isEncrypt) throws IPMIException, IOException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        byte[] configData = config.backupConfiguration();
        byte[] configCRC = config.getconfigCRC();
        byte[] data = new byte[configData.length + configCRC.length];
        System.arraycopy(configData, 0, data, 0, configData.length);
        System.arraycopy(configCRC, 0, data, configData.length, configCRC.length);
        if (isEncrypt) {
            data = config.encrypt(data);
        }
        FileChannel wChannel = new FileOutputStream(selFile, false).getChannel();
        wChannel.write(ByteBuffer.wrap(data));
        wChannel.close();
        return true;
    }

    public boolean restoreConfiguration(File selFile, boolean isDecrypt, byte restoreOption) throws IPMIException, IOException {
        int offset;
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        int numRead = 0;
        FileInputStream is = new FileInputStream(selFile);
        for (offset = 0; offset < inputs.length && (numRead = ((InputStream)is).read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < inputs.length) {
            throw new IOException("Could not completely read file " + selFile.getName());
        }
        if (isDecrypt) {
            inputs = config.decrypt(inputs);
        }
        configCRC = new byte[4];
        configData = new byte[inputs.length - 4];
        System.arraycopy(inputs, 0, configData, 0, configData.length);
        System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        return config.restoreConfiguration(configData, configCRC, true, restoreOption);
    }

    public void listDecryptedConfigurationFile(File selFile) throws IPMIException, IOException {
        int offset;
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        if (selFile.length() > Integer.MAX_VALUE) {
            throw new IOException("File size is more than Integer.MAX_VALUE" + selFile.length());
        }
        byte[] inputs = new byte[(int)selFile.length()];
        byte[] configCRC = null;
        byte[] configData = null;
        int numRead = 0;
        FileInputStream is = new FileInputStream(selFile);
        for (offset = 0; offset < inputs.length && (numRead = ((InputStream)is).read(inputs, offset, inputs.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < inputs.length) {
            throw new IOException("Could not completely read file " + selFile.getName());
        }
        inputs = config.decrypt(inputs);
        configCRC = new byte[4];
        configData = new byte[inputs.length - 4];
        System.arraycopy(inputs, 0, configData, 0, configData.length);
        System.arraycopy(inputs, inputs.length - 4, configCRC, 0, 4);
        System.out.println(new String(configData));
        System.out.println("CRC= " + ByteUtility.bytesToHex(configCRC));
    }

    public boolean syncCMMCoinfiguration() throws IPMIException {
        KIRAConfiguration config = new KIRAConfiguration(this.ipmiInterface);
        return config.syncCMMConfiguration();
    }

    public boolean isVLANCommandSupported() {
        IPMIMessage resMessage = this.isOEMCommandSupported((byte)1);
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isOEMCommandSupported");
        return false;
    }

    public NetworkInfo createNetworkInfo() {
        return new NetworkInfo();
    }

    public IPMIMessage getAllNetworkInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllNetworkInfoCommand(byte[] networkRawData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + networkRawData.length];
        data[0] = 1;
        System.arraycopy(networkRawData, 0, data, 1, networkRawData.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)43, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public NetworkInfo getAllNetworkInfo() throws IPMIException {
        IPMIMessage resMessage = this.getAllNetworkInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            NetworkInfo networkInfo = new NetworkInfo();
            networkInfo.fromRaw(resMessage.data);
            return networkInfo;
        }
        throw new IPMIException("Call getAllNetworkInfoCommand failed");
    }

    public void setAllNetworkInfo(NetworkInfo networkInfo) throws IPMIException {
        IPMIMessage resMessage = this.setAllNetworkInfoCommand(networkInfo.toRaw());
        if (resMessage != null && resMessage.completionCode == 0) {
            return;
        }
        throw new IPMIException("Call setAllNetworkInfoCommand failed");
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.16");
        config.setUserName("ADMIN");
        config.setPassword("23456");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte[] boardModelByte = ipmiOEMCommand.getBoardModelByte();
        String boardModel = ipmiOEMCommand.getBoardModel();
        System.out.println("board model is " + ByteUtility.bytesToHex(boardModelByte) + "[" + boardModel + "]");
        System.out.println("is UID present ? " + ipmiOEMCommand.isUIDPresent());
        System.out.println("is vlan command support ? " + ipmiOEMCommand.isVLANCommandSupported());
        try {
            NetworkInfo networkInfo = ipmiOEMCommand.getAllNetworkInfo();
            System.out.println(networkInfo.toString());
        }
        catch (IPMIException ex) {
            // empty catch block
        }
    }

    public static void main_(String[] args) {
        byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        KIRAConfiguration k = new KIRAConfiguration(null);
        byte[] encData = k.encrypt(data);
        System.out.println("encdata =" + ByteUtility.bytesToHex(encData));
        byte[] decData = k.decrypt(encData);
        System.out.println("decdata =" + ByteUtility.bytesToHex(decData));
    }

    public class NetworkInfo {
        public byte ipSource;
        public String ip;
        public String subnet;
        public String gateway;
        public boolean isVLANEnabled;
        public int vLanID;
        byte[] raw;

        public void fromRaw(byte[] data) {
            this.ipSource = data[0];
            this.ip = (data[1] & 0xFF) + "." + (data[2] & 0xFF) + "." + (data[3] & 0xFF) + "." + (data[4] & 0xFF);
            this.subnet = (data[5] & 0xFF) + "." + (data[6] & 0xFF) + "." + (data[7] & 0xFF) + "." + (data[8] & 0xFF);
            this.gateway = (data[9] & 0xFF) + "." + (data[10] & 0xFF) + "." + (data[11] & 0xFF) + "." + (data[12] & 0xFF);
            this.vLanID = (data[13] & 0xFF) + ((data[14] & 0xF) << 8);
            if ((byte)(data[14] & 0x80) == -128) {
                this.isVLANEnabled = true;
            }
            this.raw = data;
        }

        public byte[] toRaw() {
            int index = 0;
            byte[] raw = new byte[15];
            raw[index] = this.ipSource;
            System.arraycopy(ByteUtility.ipToBytes(this.ip), 0, raw, ++index, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.subnet), 0, raw, index += 4, 4);
            System.arraycopy(ByteUtility.ipToBytes(this.gateway), 0, raw, index += 4, 4);
            raw[index += 4] = (byte)this.vLanID;
            raw[++index] = (byte)(this.vLanID >> 8);
            if (this.isVLANEnabled) {
                raw[index] = (byte)(raw[index] | 0x80);
            }
            return raw;
        }

        public String toString() {
            String result = "";
            result = result + "\n IP Source = 0X" + ByteUtility.byteToHex(this.ipSource);
            result = result + "\n IP = " + this.ip;
            result = result + "\n Subnet = " + this.subnet;
            result = result + "\n gateway  = " + this.gateway;
            result = result + "\n vLanID  = " + this.vLanID;
            result = result + "\n isVlanEnable  = " + this.isVLANEnabled;
            result = result + "\n raw  = " + ByteUtility.bytesToHex(this.raw);
            return result;
        }
    }
}

