/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class ByteUtility {
    public static final char[] hex = "0123456789ABCDEF".toCharArray();
    static SecureRandom random = new SecureRandom();

    public static byte[] hexToBytes(String s) {
        byte[] ret = new byte[s.length() / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return ret;
    }

    public static String bytesToHex(byte[] b) {
        if (b == null) {
            return "";
        }
        char[] ret = new char[b.length * 3];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            ret[j++] = hex[(b[i] & 0xF0) >> 4];
            ret[j++] = hex[b[i] & 0xF];
            ret[j++] = 32;
        }
        return new String(ret);
    }

    public static String bytesToHex(byte[] b, int length) {
        if (b == null) {
            return "";
        }
        char[] ret = new char[length * 3];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            ret[j++] = hex[(b[i] & 0xF0) >> 4];
            ret[j++] = hex[b[i] & 0xF];
            ret[j++] = 32;
        }
        return new String(ret);
    }

    public static String byteToHex(byte b) {
        int i = b & 0xFF;
        String strByte = Integer.toHexString(i);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public static String bytesToBin(byte[] b) {
        if (b == null) {
            return "";
        }
        String ret = "";
        boolean j = false;
        for (int i = 0; i < b.length; ++i) {
            for (int ii = 0; ii < 8; ++ii) {
                ret = ret + ((b[i] & 128 >> ii) > 0 ? "1" : "0");
            }
            ret = ret + "(" + ByteUtility.byteToHex(b[i]) + "h)" + " ";
        }
        return ret;
    }

    public static void intTo4Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public static void longTo4Bytes(byte[] bytedest, int offset, long longsrc) {
        bytedest[offset + 0] = (byte)longsrc;
        bytedest[offset + 1] = (byte)(longsrc >> 8);
        bytedest[offset + 2] = (byte)(longsrc >> 16);
        bytedest[offset + 3] = (byte)(longsrc >> 24);
    }

    public static byte[] longToBytes(long input) {
        String hex = Long.toHexString(input);
        byte[] result = new byte[8];
        if (hex.length() < 16) {
            int length = hex.length();
            for (int loop = 0; loop < 16 - length; ++loop) {
                hex = "0" + hex;
            }
        }
        for (int loop = 0; loop < 16; loop += 2) {
            String temp = hex.substring(loop, loop + 2);
            result[loop / 2] = new Integer(Integer.parseInt(temp, 16)).byteValue();
        }
        return result;
    }

    public static void intTo2Bytes(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
    }

    public static int twoBytesToInt(byte[] b) {
        int b1 = b[1] & 0xFF;
        int b0 = b[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntLSB(byte[] b) {
        int b1 = b[1] & 0xFF;
        int b0 = b[0] & 0xFF;
        return (b1 << 8) + b0;
    }

    public static int twoBytesToIntMSB(byte[] b) {
        int b1 = b[1] & 0xFF;
        int b0 = b[0] & 0xFF;
        return (b0 << 8) + b1;
    }

    public static long fourBytesToLong(byte[] b) {
        long b3 = b[3] & 0xFF;
        long b2 = b[2] & 0xFF;
        long b1 = b[1] & 0xFF;
        long b0 = b[0] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    public static int fourBytesToiInt(byte[] b) {
        int b3 = b[3] & 0xFF;
        int b2 = b[2] & 0xFF;
        int b1 = b[1] & 0xFF;
        int b0 = b[0] & 0xFF;
        return (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
    }

    public static long fourBytesToLongByLSBFirst(byte[] b) {
        long b3 = b[3] & 0xFF;
        long b2 = b[2] & 0xFF;
        long b1 = b[1] & 0xFF;
        long b0 = b[0] & 0xFF;
        return (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
    }

    public static int fourBytesToIntByLSBFirst(byte[] b) {
        long b3 = b[3] & 0xFF;
        long b2 = b[2] & 0xFF;
        long b1 = b[1] & 0xFF;
        long b0 = b[0] & 0xFF;
        return (int)((b3 << 24) + (b2 << 16) + (b1 << 8) + b0);
    }

    public static byte[] random16Bytes() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String fourByteToDate(byte[] date) {
        long timeStamp = ByteUtility.fourBytesToLongByLSBFirst(date);
        String dateString = null;
        if (timeStamp < 0x20000000L) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss");
            f.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            long k = timeStamp * 1000L;
            Date d = new Date(k);
            dateString = "Pre-Init " + f.format(d);
        } else {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
            f.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            long k = timeStamp * 1000L;
            Date d = new Date(k);
            dateString = f.format(d);
        }
        return dateString;
    }

    private static long addTimeZoneOffset(long time) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTimeInMillis(time);
        long zoneOffset = 0L;
        zoneOffset = c.get(15) + c.get(16);
        return time - zoneOffset;
    }

    public static byte[] toBinArray(String hexStr) {
        char[] hexChars = hexStr.toCharArray();
        int startIndex = 0;
        int length = hexChars.length;
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Length must be even");
        }
        byte[] result = new byte[length / 2];
        for (int j = 0; j < result.length; ++j) {
            result[j] = (byte)(ByteUtility.hexCharToNibble(hexChars[startIndex++]) * 16 + ByteUtility.hexCharToNibble(hexChars[startIndex++]));
        }
        return result;
    }

    public static boolean isNumeric(String str) {
        char[] chars = str.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') continue;
            return false;
        }
        return true;
    }

    private static int hexCharToNibble(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IllegalArgumentException("Not a hex char - '" + ch + "'");
    }

    public static int bcdToInt(byte b) {
        int d0 = b & 0xF;
        int d1 = b & 0xF0;
        return 10 * (d1 >>= 4) + d0;
    }

    public static byte intToBCD(int i) {
        int b1 = i / 10;
        int b0 = i % 10;
        return (byte)((b1 <<= 4) + b0);
    }

    public static int ipToInt(String ip) {
        int intValue = 0;
        StringTokenizer st = new StringTokenizer(ip, ".");
        intValue = (Integer.parseInt(st.nextToken()) << 24) + (Integer.parseInt(st.nextToken()) << 16) + (Integer.parseInt(st.nextToken()) << 8) + Integer.parseInt(st.nextToken());
        return intValue;
    }

    public static byte[] ipToBytes(String ip) {
        byte[] bytes = new byte[4];
        boolean intValue = false;
        StringTokenizer st = new StringTokenizer(ip, ".");
        bytes[0] = (byte)Integer.parseInt(st.nextToken());
        bytes[1] = (byte)Integer.parseInt(st.nextToken());
        bytes[2] = (byte)Integer.parseInt(st.nextToken());
        bytes[3] = (byte)Integer.parseInt(st.nextToken());
        return bytes;
    }

    public static String bytesToHexNoSpace(byte[] b) {
        char[] ret = new char[b.length * 2];
        int j = 0;
        for (int i = 0; i < b.length; ++i) {
            ret[j++] = hex[(b[i] & 0xF0) >> 4];
            ret[j++] = hex[b[i] & 0xF];
        }
        return new String(ret);
    }

    public static void main(String[] args) {
        byte[] c = new byte[]{-102, 0};
        System.out.println(ByteUtility.twoBytesToInt(c));
        byte[] a = new byte[20];
        System.out.println(ByteUtility.bytesToHex(a));
        System.out.println(ByteUtility.byteToHex(ByteUtility.intToBCD(33)));
        System.out.println(Calendar.getInstance().get(1));
        int ip = ByteUtility.ipToInt("192.168.1.1");
        int gw = ByteUtility.ipToInt("192.168.127.254");
        int nm = ByteUtility.ipToInt("255.255.128.0");
        System.out.println("ip =" + ip);
        System.out.println("gw =" + gw);
        System.out.println("nm =" + nm);
        if ((ip & nm) == (gw & nm)) {
            System.out.println("yes");
        } else {
            System.out.println("no");
        }
        System.out.println(ByteUtility.bytesToHex(ByteUtility.random16Bytes()));
    }
}

