/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import sun.net.ftp.FtpClient;

public class SunFtpWrapper
extends FtpClient {
    public long fileSize = 0L;
    MyObservable observable = new MyObservable();

    public void addObserver(Observer o) {
        this.observable.addObserver(o);
    }

    public String pwd() throws IOException {
        this.issueCommand("PWD");
        if (this.isValidResponse()) {
            String response = this.getResponseString().substring(4).trim();
            if (response.startsWith("\"")) {
                response = response.substring(1);
            }
            if (response.endsWith("\"")) {
                response = response.substring(0, response.length() - 1);
            }
            return response;
        }
        return "";
    }

    public boolean cdup() throws IOException {
        this.issueCommand("CDUP");
        return this.isValidResponse();
    }

    public boolean mkdir(String newDir) throws IOException {
        this.issueCommand("MKDIR " + newDir);
        return this.isValidResponse();
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.issueCommand("DELE " + fileName);
        return this.isValidResponse();
    }

    public Vector listRaw() throws IOException {
        String fileName;
        Vector<String> ftpList = new Vector<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.list()));
        while ((fileName = reader.readLine()) != null) {
            ftpList.add(fileName);
        }
        return ftpList;
    }

    public int getResponseCode() throws NumberFormatException {
        return Integer.parseInt(this.getResponseString().substring(0, 3));
    }

    public boolean isValidResponse() {
        try {
            int respCode = this.getResponseCode();
            return respCode >= 200 && respCode < 300;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int issueRawCommand(String command) throws IOException {
        return this.issueCommand(command);
    }

    public boolean downloadFile(String serverFile, String localFile) throws IOException {
        int i = 0;
        int total = 0;
        byte[] bytesIn = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(this.get(serverFile));
        FileOutputStream out = new FileOutputStream(localFile);
        while ((i = in.read(bytesIn)) >= 0) {
            out.write(bytesIn, 0, i);
            if (this.fileSize == 0L) continue;
            int percent = (int)((double)(total += i) / (double)this.fileSize * 100.0);
            this.observable.setChanged();
            this.observable.notifyObservers(new Integer(percent));
        }
        out.close();
        return true;
    }

    public boolean uploadFile(String localFile, String serverFile) throws IOException {
        int i = 0;
        byte[] bytesIn = new byte[1024];
        FileInputStream in = new FileInputStream(localFile);
        BufferedOutputStream out = new BufferedOutputStream(this.put(serverFile));
        while ((i = in.read(bytesIn)) >= 0) {
            out.write(bytesIn, 0, i);
        }
        in.close();
        out.close();
        return true;
    }

    public long getFileSize(String fileName) throws IOException {
        this.issueCommand("size " + fileName);
        if (this.isValidResponse()) {
            String response = this.getResponseString().substring(4).trim();
            return Long.parseLong(response);
        }
        return 0L;
    }

    public static void main(String[] args) throws Exception {
        SunFtpWrapper ftp = new SunFtpWrapper();
        ftp.openServer("ftp.supermicro.com");
        ftp.login("anonymous", "ddd");
        ftp.cd("update/IPMIViews");
        ftp.binary();
        boolean b = ftp.downloadFile("IPMIView20.jar", "IPMIView20.jar");
        System.out.println("b =" + b);
    }

    class MyObservable
    extends Observable {
        MyObservable() {
        }

        public void setChanged() {
            super.setChanged();
        }
    }
}

