/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CMMDebug;
import IPMIView20.CMMLoginUI_jLoginIDTextField_actionAdapter;
import IPMIView20.CMMLoginUI_jLoginPasswordField_actionAdapter;
import IPMIView20.CMMLoginUI_jRegisterButton_actionAdapter;
import IPMIView20.CMMLoginUI_jUnregisterButton_actionAdapter;
import IPMIView20.CMMSessionPanel;
import IPMIView20.CMMUIPanel;
import IPMIView20.DeviceNameAccount;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class CMMLoginUI
extends CMMUIPanel {
    Icon registeredIcon = new ImageIcon(this.getClass().getResource("/images/Registered.gif"));
    Icon connectIcon = new ImageIcon(this.getClass().getResource("/images/connect2.gif"));
    JButton jRegisterButton = new JButton();
    JLabel jSupermicroIBladeLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jLabel4 = new JLabel();
    public JLabel jSystemNameLabel = new JLabel();
    public JLabel jIPAddressLabel = new JLabel();
    public JLabel jDescriptionLabel = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel jLabel9 = new JLabel();
    JTextField jLoginIDTextField = new JTextField();
    JPasswordField jLoginPasswordField = new JPasswordField();
    JButton jUnregisterButton = new JButton();
    JCheckBox jSaveIDandPasswordCheckBox = new JCheckBox();
    JPanel jPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JLabel jRegisteredLabel = new JLabel();
    JLabel jConnectLabel = new JLabel();
    JLabel jLoginStepsLabel = new JLabel();

    public CMMLoginUI() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.jLoginStepsLabel.setVisible(false);
    }

    public void enableFocusOnLoginID() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                CMMLoginUI.this.jLoginIDTextField.requestFocusInWindow();
            }
        });
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
        this.jRegisterButton.setBounds(new Rectangle(96, 337, 106, 27));
        this.jRegisterButton.setText(L.t("cmm.login.login"));
        this.jRegisterButton.addActionListener(new CMMLoginUI_jRegisterButton_actionAdapter(this));
        this.jSupermicroIBladeLabel.setBackground(SystemColor.inactiveCaptionText);
        this.jSupermicroIBladeLabel.setFont(new Font("Arial", 1, 26));
        this.jSupermicroIBladeLabel.setForeground(Color.blue);
        this.jSupermicroIBladeLabel.setHorizontalAlignment(0);
        IPMIView20.getInstance();
        if (IPMIView20.inspur) {
            this.jSupermicroIBladeLabel.setText("Inspur Blade");
        } else {
            IPMIView20.getInstance();
            if (IPMIView20.clearCube) {
                this.jSupermicroIBladeLabel.setText("");
            } else {
                this.jSupermicroIBladeLabel.setText("SuperBlade");
            }
        }
        this.jSupermicroIBladeLabel.setBounds(new Rectangle(11, 25, 408, 30));
        this.jLabel2.setHorizontalAlignment(11);
        this.jLabel2.setText(L.t("cmm.login.system_name"));
        this.jLabel2.setBounds(new Rectangle(51, 91, 132, 15));
        this.jLabel3.setHorizontalAlignment(11);
        this.jLabel3.setText(L.t("cmm.login.ip_address"));
        this.jLabel3.setBounds(new Rectangle(55, 123, 128, 15));
        this.jLabel4.setHorizontalAlignment(11);
        this.jLabel4.setText(L.t("cmm.login.desc"));
        this.jLabel4.setBounds(new Rectangle(50, 155, 133, 15));
        this.jSystemNameLabel.setForeground(Color.blue);
        this.jSystemNameLabel.setText("192.168.10.1");
        this.jSystemNameLabel.setBounds(new Rectangle(196, 92, 110, 15));
        this.jIPAddressLabel.setForeground(Color.blue);
        this.jIPAddressLabel.setText("192.168.10.1");
        this.jIPAddressLabel.setBounds(new Rectangle(196, 124, 111, 15));
        this.jDescriptionLabel.setForeground(Color.blue);
        this.jDescriptionLabel.setText("DESCRIPTION");
        this.jDescriptionLabel.setBounds(new Rectangle(196, 156, 137, 15));
        this.jLabel8.setToolTipText("");
        this.jLabel8.setHorizontalAlignment(11);
        this.jLabel8.setText(L.t("cmm.login.login_id"));
        this.jLabel8.setBounds(new Rectangle(66, 215, 85, 15));
        this.jLabel9.setHorizontalAlignment(11);
        this.jLabel9.setText(L.t("cmm.login.password"));
        this.jLabel9.setBounds(new Rectangle(55, 250, 96, 15));
        this.jLoginIDTextField.setBounds(new Rectangle(168, 212, 126, 20));
        this.jLoginIDTextField.addActionListener(new CMMLoginUI_jLoginIDTextField_actionAdapter(this));
        this.jLoginPasswordField.setBounds(new Rectangle(168, 247, 126, 21));
        this.jLoginPasswordField.addActionListener(new CMMLoginUI_jLoginPasswordField_actionAdapter(this));
        this.jUnregisterButton.setBounds(new Rectangle(213, 337, 107, 27));
        this.jUnregisterButton.setText(L.t("cmm.login.logout"));
        this.jUnregisterButton.addActionListener(new CMMLoginUI_jUnregisterButton_actionAdapter(this));
        this.jSaveIDandPasswordCheckBox.setText(L.t("cmm.login.save_id_and_password"));
        this.jSaveIDandPasswordCheckBox.setBounds(new Rectangle(95, 280, 193, 23));
        this.jPanel.setBackground(Color.white);
        this.jPanel.setBorder(this.titledBorder1);
        this.jPanel.setBounds(new Rectangle(34, 66, 355, 119));
        this.setPreferredSize(new Dimension(420, 484));
        this.jRegisteredLabel.setToolTipText("");
        this.jRegisteredLabel.setIcon(this.registeredIcon);
        this.jRegisteredLabel.setBounds(new Rectangle(297, 211, 350, 22));
        this.jRegisteredLabel.setVisible(false);
        this.jRegisteredLabel.setForeground(Color.blue);
        this.jConnectLabel.setToolTipText("");
        this.jConnectLabel.setIcon(this.connectIcon);
        this.jConnectLabel.setBounds(new Rectangle(55, 358, 299, 41));
        this.jConnectLabel.setVisible(false);
        this.jLoginStepsLabel.setForeground(Color.blue);
        this.jLoginStepsLabel.setHorizontalAlignment(0);
        this.jLoginStepsLabel.setHorizontalTextPosition(0);
        this.jLoginStepsLabel.setText("Message:");
        this.jLoginStepsLabel.setBounds(new Rectangle(97, 375, 221, 15));
        this.add(this.jDescriptionLabel);
        this.add(this.jLabel2);
        this.add(this.jLabel3);
        this.add(this.jLabel4);
        this.add(this.jIPAddressLabel);
        this.add(this.jSystemNameLabel);
        this.add(this.jPanel);
        this.add(this.jSupermicroIBladeLabel);
        this.add(this.jLoginPasswordField);
        this.add(this.jRegisteredLabel);
        this.add(this.jLoginIDTextField);
        this.add(this.jSaveIDandPasswordCheckBox);
        this.add(this.jLabel8);
        this.add(this.jLabel9);
        this.add(this.jUnregisterButton);
        this.add((Component)this.jRegisterButton, null);
        this.add(this.jConnectLabel);
        this.add(this.jLoginStepsLabel);
    }

    public void preset(CMMSessionPanel cmmSessionPanel, JLabel xMessage) {
        super.preset(cmmSessionPanel, xMessage);
        if (DeviceNameAccount.getID(cmmSessionPanel.hostname) != null) {
            String id = DeviceNameAccount.getID(cmmSessionPanel.hostname);
            String password = DeviceNameAccount.getDecryptedPassword(cmmSessionPanel.hostname);
            this.jLoginIDTextField.setText(id);
            this.jLoginPasswordField.setText(password);
            this.jSaveIDandPasswordCheckBox.setSelected(true);
        }
        this.jUnregisterButton.setEnabled(false);
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(cmmSessionPanel.ip);
        if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
            IPMIView20.getInstance();
            if (IPMIView20.inspur) {
                this.jSupermicroIBladeLabel.setText("Inspur Blade");
            } else {
                IPMIView20.getInstance();
                if (IPMIView20.clearCube) {
                    this.jSupermicroIBladeLabel.setText("");
                } else {
                    this.jSupermicroIBladeLabel.setText("SuperBlade");
                }
            }
        } else if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
            IPMIView20.getInstance();
            if (IPMIView20.inspur) {
                this.jSupermicroIBladeLabel.setText("Inspur Blade (Office Blade)");
            } else {
                IPMIView20.getInstance();
                if (IPMIView20.clearCube) {
                    this.jSupermicroIBladeLabel.setText("ClearCube (Office Blade)");
                } else {
                    this.jSupermicroIBladeLabel.setText("SuperBlade (Office Blade)");
                }
            }
        }
    }

    public void present() {
    }

    public void setDefaultButton() {
        this.getRootPane().setDefaultButton(this.jRegisterButton);
    }

    public void closeLoginUI() {
        this.jUnregisterButton_actionPerformed(null);
    }

    public void jUnregisterButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                CMMLoginUI.this.jRegisterButton.setEnabled(false);
                CMMLoginUI.this.jUnregisterButton.setEnabled(false);
                CMMLoginUI.this.jRegisteredLabel.setVisible(false);
                CMMLoginUI.this.xMessage.setText(L.t("cmm.login.disconnecting") + "...");
                CMMLoginUI.this.cmmSessionPanel.bladeSystemEntity.stopPooling();
                CMMLoginUI.this.cmmSessionPanel.bladeSystemEntity.deleteObservers();
                CMMLoginUI.this.cmmSessionPanel.bladeSystemEntity.removeallDisconnectListener();
                CMMLoginUI.this.cmmSessionPanel.reInitialTab();
                CMMLoginUI.this.cmmSessionPanel.selPanel.closePanel();
                CMMLoginUI.this.cmmSessionPanel.cmmSOLPanel.closeSOLUI();
                CMMLoginUI.this.cmmSessionPanel.cmmKVMPanel.closeKVMUI();
                CMMLoginUI.this.cmmSessionPanel.cmmBladeSystemPanel.closePanel();
                CMMLoginUI.this.cmmSessionPanel.virtualMediaPanel.stop();
                CMMLoginUI.this.cmmSessionPanel.setReduntantPanelVisible(false);
                LabelBladeComponent.globalLabelBladeGroup = null;
                CMMLoginUI.this.cmmSessionPanel.bladeSystemEntity = null;
                CMMLoginUI.this.cmmSessionPanel.cmmBladeSystemPanel = null;
                CMMLoginUI.this.cmmSessionPanel.cmmSOLPanel = null;
                CMMLoginUI.this.cmmSessionPanel.cmmKVMPanel = null;
                CMMLoginUI.this.cmmSessionPanel.selPanel = null;
                CMMLoginUI.this.cmmSessionPanel.userManagementPanel = null;
                CMMLoginUI.this.cmmSessionPanel.cmmConfigPanel = null;
                CMMLoginUI.this.cmmSessionPanel.virtualMediaPanel = null;
                CMMLoginUI.this.xMessage.setText(" ");
                CMMLoginUI.this.jRegisterButton.setEnabled(true);
                System.gc();
            }
        };
        thread.start();
    }

    public void jRegisterButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                boolean check = CMMLoginUI.this.checkIDandPassword();
                if (!check) {
                    return;
                }
                CMMLoginUI.this.register();
            }
        };
        thread.start();
    }

    public boolean checkIDandPassword() {
        if (this.jLoginIDTextField.getText().length() == 0) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("login.The_Login_ID_cannot_be_empty"));
            return false;
        }
        if (this.jLoginPasswordField.getPassword().length == 0) {
            JOptionPane.showMessageDialog(this.findParentFrame(), L.t("The_Login_Password_cannot_be_empty"));
            return false;
        }
        return true;
    }

    public boolean register() {
        if (IPMIView20.availableMemory() < 0x1900000L) {
            JOptionPane.showMessageDialog(this, L.t("cmm.login.cannot_login") + "\n");
            return false;
        }
        this.jRegisterButton.setEnabled(false);
        this.jLoginStepsLabel.setText("");
        this.jLoginStepsLabel.setVisible(true);
        this.jLoginStepsLabel.setText(L.t("cmm.login.logining") + "...");
        this.cmmSessionPanel.createAllPanel();
        if (CMMDebug.registerDebug) {
            Logger.printLog("[CMMLoginUI] start login");
        }
        this.xMessage.setText(L.t("cmm.login.login_to") + this.cmmSessionPanel.hostname + " ...");
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setTimeout(IPMIView20.getInstance().socketTimeout);
        config.setRetry(IPMIView20.getInstance().retryTime);
        config.setIp(this.cmmSessionPanel.ip);
        config.setUserName(this.jLoginIDTextField.getText().trim());
        config.setPassword(new String(this.jLoginPasswordField.getPassword()).trim());
        config.setPrivilege((byte)4);
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiGlobalCommand);
        if (CMMDebug.registerDebug) {
            Logger.printLog("[CMMLoginUI] Login OK");
        }
        if (sessionController == null) {
            this.xMessage.setText(L.t("cmm.login.cannot_comm") + this.cmmSessionPanel.hostname);
            this.jLoginStepsLabel.setVisible(false);
            this.jRegisterButton.setEnabled(true);
            return false;
        }
        IPMIInterface rmcp = ipmiGlobalCommand.getIPMIInterface();
        if (rmcp != null) {
            sessionController.closeSession();
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] closeSession() ok");
            }
            this.cmmSessionPanel.loginID = this.jLoginIDTextField.getText().trim();
            this.cmmSessionPanel.loginPassword = new String(this.jLoginPasswordField.getPassword()).trim();
            if (this.jSaveIDandPasswordCheckBox.isSelected()) {
                DeviceNameAccount.save(this.cmmSessionPanel.hostname, this.cmmSessionPanel.loginID, this.cmmSessionPanel.loginPassword);
            } else {
                DeviceNameAccount.remove(this.cmmSessionPanel.hostname);
            }
            this.cmmSessionPanel.ipmiInterfaceConfig = config;
            switch (config.getPrivilege()) {
                case 4: {
                    this.jRegisteredLabel.setText("[Administrator]");
                    break;
                }
                case 3: {
                    this.jRegisteredLabel.setText("[Operator]");
                    break;
                }
                case 2: {
                    this.jRegisteredLabel.setText("[User]");
                }
            }
            this.jLoginStepsLabel.setText(L.t("cmm.login.retrieving") + "...");
            this.cmmSessionPanel.getBladeSystemEntityData();
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] cmmSessionPanel.getBladeSystemEntityData() ok");
            }
            int bladeSize = this.cmmSessionPanel.bladeSystemEntity.getBlades().length;
            this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.getBladeSystemFront().resetBladeSize(bladeSize);
            this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.addBladeToLabelBladeGroup();
            this.jLoginStepsLabel.setText(L.t("cmm.login.checkMS") + "...");
            boolean isMaster = this.isMaster();
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] isMaster() ok");
            }
            this.jLoginStepsLabel.setText(L.t("cmm.login.prepareingUI") + "...");
            this.cmmSessionPanel.showAllTab(isMaster);
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] showAllTab() ok");
            }
            this.cmmSessionPanel.addCMMSessionPanelToObservable();
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] addCMMSessionPanelToObservable() ok");
            }
            this.cmmSessionPanel.startPoolingData();
            if (CMMDebug.registerDebug) {
                Logger.printLog("[CMMLoginUI] startPoolingData() ok");
            }
            if (!isMaster) {
                this.adjustSlaveUI();
            }
            this.jUnregisterButton.setEnabled(true);
            this.jLoginStepsLabel.setText(L.t("cmm.login.finished"));
            this.jRegisteredLabel.setVisible(true);
            this.jLoginStepsLabel.setVisible(false);
            this.xMessage.setText(L.t("cmm.login.login_to") + " " + this.cmmSessionPanel.hostname + "(" + this.cmmSessionPanel.ip + ") " + L.t("successfully"));
            return true;
        }
        this.jLoginStepsLabel.setVisible(false);
        this.jRegisterButton.setEnabled(true);
        this.xMessage.setText(L.t("cmm.login.login_to") + " " + this.cmmSessionPanel.hostname + "(" + this.cmmSessionPanel.ip + ") " + L.t("cmm.login.failed"));
        try {
            sessionController.closeSession();
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public void adjustSlave2MasterUI() throws HeadlessException {
        int i;
        this.cmmSessionPanel.cmmKVMPanel.cmmKVMSwitchSubPanel.setEnableControls(true);
        this.cmmSessionPanel.cmmSOLPanel.cmmKVMSwitchSubPanel.setEnableControls(true);
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleBladePanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleBladePanels[i].setEnableControls(true);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleGigabitSwitchPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleGigabitSwitchPanels[i].setEnableControls(true);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singlePowerSupplyPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singlePowerSupplyPanels[i].setEnableControls(true);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleInfiniBandPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleInfiniBandPanels[i].setEnableControls(true);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.single10gPassThruPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.single10gPassThruPanels[i].setEnableControls(true);
        }
        this.cmmSessionPanel.setReduntantPanelVisible(false);
    }

    public void adjustMaster2SlaveUI() throws HeadlessException {
        int i;
        this.cmmSessionPanel.cmmKVMPanel.cmmKVMSwitchSubPanel.setEnableControls(false);
        this.cmmSessionPanel.cmmSOLPanel.cmmKVMSwitchSubPanel.setEnableControls(false);
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleBladePanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleBladePanels[i].setEnableControls(false);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleGigabitSwitchPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleGigabitSwitchPanels[i].setEnableControls(false);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singlePowerSupplyPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singlePowerSupplyPanels[i].setEnableControls(false);
        }
        for (i = 0; i < this.cmmSessionPanel.cmmBladeSystemPanel.singleInfiniBandPanels.length; ++i) {
            this.cmmSessionPanel.cmmBladeSystemPanel.singleInfiniBandPanels[i].setEnableControls(false);
        }
        String ip = this.getOtherCMMIP();
        String barMessage = "";
        barMessage = ip != null ? L.t("cmm.login.redundant1") + ip + ")" : L.t("cmm.login.redundant2");
        this.cmmSessionPanel.setReduntantPanelString(barMessage);
        this.cmmSessionPanel.setReduntantPanelVisible(true);
    }

    public void adjustSlaveUI() throws HeadlessException {
        String msg = L.t("cmm.login.adjustSlaveMsg1") + " \n";
        msg = msg + L.t("cmm.login.adjustSlaveMsg2") + " \n";
        msg = msg + L.t("cmm.login.adjustSlaveMsg3");
        String ip = this.getOtherCMMIP();
        String barMessage = "";
        barMessage = ip != null ? L.t("cmm.login.redundant1") + ip + ")" : L.t("cmm.login.redundant2");
        this.cmmSessionPanel.setReduntantPanelString(barMessage);
        this.cmmSessionPanel.setReduntantPanelVisible(true);
    }

    public String getOtherCMMIP() {
        String ip = "";
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                ip = ipmiCMMOEMCommand.getCMMOtherIP();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
            sessionController.closeSession();
        }
        return ip;
    }

    public boolean isMaster() {
        int slot = -1;
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                slot = ipmiCMMOEMCommand.getCMMSlot();
            }
            catch (IPMIException ex1) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex1.getMessage());
            }
            sessionController.closeSession();
        }
        if (slot != -1) {
            byte isMaster = this.cmmSessionPanel.bladeSystemEntity.getCmmModules()[slot].getMasterSlave();
            return isMaster == 0;
        }
        return true;
    }

    public void jLoginPasswordField_actionPerformed(ActionEvent e) {
        if (this.jRegisterButton.isEnabled()) {
            this.jRegisterButton_actionPerformed(null);
        }
    }

    public void jLoginIDTextField_actionPerformed(ActionEvent e) {
        if (this.jRegisterButton.isEnabled()) {
            this.jRegisterButton_actionPerformed(null);
        }
    }
}

