/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.BMC_Manage20ConfigModel;
import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SizeRequirements;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class BMC_Manage20
extends JPanel {
    boolean bLoaded = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    CSession Session;
    int TabId;
    UDPSocket udpSocket;
    int ServerCount = 0;
    int iNumRec = 0;
    String[][] SNMPServers;
    String[] ColumnHead = new String[]{L.t("bmc.IP_Address"), L.t("bmc.MAC_Address")};
    int[] BRate = new int[]{4800, 9600, 19200, 38400, 57600, 115200};
    String[] BKSetting = new String[2];
    String[][] BKSNMPServers;
    String BKCommunity;
    String BKSMTPServer;
    boolean[] RWChangable = new boolean[2];
    boolean AnyChangableSNMP = false;
    String IPAddress;
    String MACAddress;
    String NetMask;
    String Gateway;
    String GWMAC;
    String vlanTag;
    boolean isEnableVLAN;
    boolean isDHCP;
    JButton backupButton;
    JButton restoreButton;
    private JPanel jALERT;
    private JComboBox jComboBox1;
    private JTextField jCommunity;
    private JTextField jGWMAC;
    private JTextField jGateway;
    private JTextField jIPAddress;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JTextField jMACAddress;
    private JTextField jNetMask;
    private JTextField jPPPInit;
    private JPanel jPanel2;
    private JPanel configurationPanel;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jRS232;
    private JButton jRefresh;
    private JTable jSNMPTable;
    private JScrollPane jScrollPane1;
    private JButton jUpdateLAN;
    private JCheckBox jDHCPCheckBox;
    private JButton jUpdateRS232;
    private JButton jUpdateSNMP;
    private BMC_Manage20ConfigModel configModel;
    private JLabel jVLANLabel;
    private JTextField jVLANTagTextField;
    private JCheckBox jVLANIsEnabledCheckBox;
    TableModel dataModel = new AbstractTableModel(){

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (BMC_Manage20.this.Session.isPeppercon || BMC_Manage20.this.Session.isAMI) {
                return BMC_Manage20.this.iNumRec;
            }
            return 3;
        }

        public Object getValueAt(int row, int col) {
            return BMC_Manage20.this.SNMPServers[row][col];
        }

        public String getColumnName(int column) {
            return BMC_Manage20.this.ColumnHead[column];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1) {
                byte[] macadd;
                if (((String)aValue).length() > 0 && ((macadd = ((String)aValue).getBytes())[2] != 58 || macadd[5] != 58 || macadd[8] != 58 || macadd[11] != 58 || macadd[14] != 58)) {
                    JOptionPane MBox = new JOptionPane();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("bmc.MAC_address_must_be_format"));
                    return;
                }
            } else if (column == 0 && ((String)aValue).length() > 0) {
                String ip = (String)aValue;
                int dotCount = 0;
                StringTokenizer st = new StringTokenizer(ip, ".");
                while (st.hasMoreTokens()) {
                    st.nextToken();
                    ++dotCount;
                }
                if (dotCount != 4) {
                    JOptionPane MBox = new JOptionPane();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("bmc.IP_address_must_be_format"));
                    return;
                }
            }
            BMC_Manage20.this.SNMPServers[row][column] = (String)aValue;
        }
    };

    public BMC_Manage20() {
        this.initComponents();
        for (int j = 0; j < this.BRate.length; ++j) {
            this.jComboBox1.insertItemAt(new String(this.BRate[j] + ""), j);
        }
        this.jScrollPane1.setVisible(false);
        this.jRS232.setVisible(false);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        if (this.Session.isPeppercon || this.Session.isAMI) {
            this.jLabel8.setVisible(false);
            this.jGWMAC.setVisible(false);
            this.jDHCPCheckBox.setVisible(true);
        }
        if (this.Session.isVLANSupported) {
            this.jVLANIsEnabledCheckBox.setVisible(true);
            this.jVLANLabel.setVisible(true);
            this.jVLANTagTextField.setVisible(true);
        } else {
            this.jVLANIsEnabledCheckBox.setVisible(false);
            this.jVLANLabel.setVisible(false);
            this.jVLANTagTextField.setVisible(false);
        }
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = iSession.Loading;
        this.reload();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GetLANConfiguration() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{1, 3, 0, 0};
        int[] length = new int[1];
        byte[] ParaSeq = new byte[]{3, 5, 6, 12, 13, 20, 4};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        for (int i = 0; i < ParaSeq.length; ++i) {
            CSession cSession = this.Session;
            synchronized (cSession) {
                this.Session.lockout();
                Para.removeAllElements();
                Para.addElement(AuthType);
                Para.addElement(this.Session.SessionSeq);
                Para.addElement(this.Session.SessionID);
                reqdata[1] = ParaSeq[i];
                Para.addElement(reqdata);
                this.SIP = this.Session.SIP;
                switch (ParaSeq[i]) {
                    case 3: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_IP_Address"));
                        break;
                    }
                    case 5: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_MAC_Address"));
                        break;
                    }
                    case 6: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_Subnet_Mask"));
                        break;
                    }
                    case 12: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_Default_Gateway_Address"));
                        break;
                    }
                    case 13: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_Default_Gateway_MAC_Address"));
                        break;
                    }
                    case 20: {
                        this.Message.setText(L.t("Getting VLAN Configuration"));
                        break;
                    }
                    case 4: {
                        this.Message.setText("Getting IP Source");
                    }
                }
                this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)65, Para, this.Session, rawdata, length);
                if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                    this.Session.IncreaseSessionSeq();
                    this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                    if (this.rmcpPacket.compeletecode == 0) {
                        byte[] BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                        switch (ParaSeq[i]) {
                            case 3: {
                                this.IPAddress = (BMCIP[0] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[3] & 0xFF);
                                this.jIPAddress.setText(this.IPAddress);
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_IP_Address"));
                                break;
                            }
                            case 5: {
                                this.MACAddress = this.ByteToMAC(BMCIP, 0);
                                this.jMACAddress.setText(this.MACAddress);
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_MAC_Address"));
                                break;
                            }
                            case 6: {
                                this.NetMask = (BMCIP[0] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[3] & 0xFF);
                                this.jNetMask.setText(this.NetMask);
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_Subnet_Mask"));
                                break;
                            }
                            case 12: {
                                this.Gateway = (BMCIP[0] & 0xFF) + "." + (BMCIP[1] & 0xFF) + "." + (BMCIP[2] & 0xFF) + "." + (BMCIP[3] & 0xFF);
                                this.jGateway.setText(this.Gateway);
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_Default_Gateway_Address"));
                                break;
                            }
                            case 13: {
                                this.GWMAC = this.ByteToMAC(BMCIP, 0);
                                this.jGWMAC.setText(this.GWMAC);
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_Default_Gateway_MAC_Address"));
                                break;
                            }
                            case 4: {
                                if (BMCIP[0] == 1) {
                                    this.jDHCPCheckBox.setSelected(false);
                                    this.setDHCPUIStatus(false);
                                    this.isDHCP = false;
                                    break;
                                }
                                if (BMCIP[0] != 2) break;
                                this.jDHCPCheckBox.setSelected(true);
                                this.setDHCPUIStatus(true);
                                this.isDHCP = true;
                                break;
                            }
                            case 20: {
                                byte data1 = BMCIP[0];
                                byte data2 = BMCIP[1];
                                this.isEnableVLAN = (byte)(data2 & 0x80) == -128;
                                int tag = ((data2 & 0xF) << 8) + (data1 & 0xFF);
                                this.jVLANIsEnabledCheckBox.setSelected(this.isEnableVLAN);
                                this.jVLANTagTextField.setText("" + tag);
                                this.vlanTag = "" + tag;
                                if (this.isEnableVLAN) {
                                    this.jVLANTagTextField.setEditable(true);
                                    break;
                                }
                                this.jVLANTagTextField.setEditable(false);
                            }
                        }
                    } else {
                        switch (ParaSeq[i]) {
                            case 3: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_IP_Address"));
                                break;
                            }
                            case 5: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_MAC_Address"));
                                break;
                            }
                            case 6: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_MAC_Address"));
                                break;
                            }
                            case 12: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Default_Gateway_Address"));
                                break;
                            }
                            case 13: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Default_Gateway_MAC_Address"));
                            }
                        }
                    }
                } else {
                    switch (ParaSeq[i]) {
                        case 3: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_IP_Address"));
                            break;
                        }
                        case 5: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_MAC_Address"));
                            break;
                        }
                        case 6: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_MAC_Address"));
                            break;
                        }
                        case 12: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Default_Gateway_Address"));
                            break;
                        }
                        case 13: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Default_Gateway_MAC_Address"));
                        }
                    }
                }
                this.Session.releaselock();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void GetSNMPConfiguration() {
        byte[] BMCIP;
        CSession cSession;
        int i;
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{1, 3, 0, 0};
        int[] length = new int[1];
        boolean intTemp = false;
        byte[] ParaSeq = new byte[]{16, 17};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        this.iNumRec = 0;
        for (i = 0; i < ParaSeq.length; ++i) {
            cSession = this.Session;
            synchronized (cSession) {
                this.Session.lockout();
                Para.removeAllElements();
                Para.addElement(AuthType);
                Para.addElement(this.Session.SessionSeq);
                Para.addElement(this.Session.SessionID);
                reqdata[1] = ParaSeq[i];
                Para.addElement(reqdata);
                this.SIP = this.Session.SIP;
                switch (ParaSeq[i]) {
                    case 16: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_SNMP_Community"));
                        break;
                    }
                    case 17: {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_Number_of_SNMP_Alerting_Destinations"));
                    }
                }
                this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)65, Para, this.Session, rawdata, length);
                if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                    this.Session.IncreaseSessionSeq();
                    this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                    if (this.rmcpPacket.compeletecode == 0) {
                        BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                        switch (ParaSeq[i]) {
                            case 16: {
                                ByteArrayOutputStream strout = new ByteArrayOutputStream();
                                strout.write(BMCIP, 0, BMCIP.length);
                                this.jCommunity.setText(strout.toString().trim());
                                this.BKCommunity = strout.toString();
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_SNMP_Community"));
                                break;
                            }
                            case 17: {
                                this.iNumRec = BMCIP[0] & 0xF;
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_Number_of_SNMP_Alerting_Destinations"));
                            }
                        }
                    } else {
                        switch (ParaSeq[i]) {
                            case 16: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_SNMP_Community"));
                                break;
                            }
                            case 17: {
                                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Number_of_SNMP_Alerting_Destinations"));
                            }
                        }
                    }
                } else {
                    switch (ParaSeq[i]) {
                        case 16: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_SNMP_Community"));
                            break;
                        }
                        case 17: {
                            this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_Number_of_SNMP_Alerting_Destinations"));
                        }
                    }
                }
                this.Session.releaselock();
                continue;
            }
        }
        this.SNMPServers = new String[15][2];
        this.BKSNMPServers = new String[15][2];
        for (i = 0; i < 15; ++i) {
            this.SNMPServers[i][0] = "";
            this.SNMPServers[i][1] = "";
            this.BKSNMPServers[i][0] = "";
            this.BKSNMPServers[i][1] = "";
        }
        int j = 0;
        for (i = 1; i <= this.iNumRec; ++i) {
            cSession = this.Session;
            synchronized (cSession) {
                this.Session.lockout();
                Para.removeAllElements();
                Para.addElement(AuthType);
                Para.addElement(this.Session.SessionSeq);
                Para.addElement(this.Session.SessionID);
                reqdata[1] = 19;
                reqdata[2] = (byte)(i & 0xFF);
                Para.addElement(reqdata);
                this.SIP = this.Session.SIP;
                this.Message.setText(L.t("bmc.Getting_LAN_Configuration_SNMP_Alerting_Destinations_-_") + (i + 1));
                this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)2, (byte)65, Para, this.Session, rawdata, length);
                if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                    this.Session.IncreaseSessionSeq();
                    this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                    if (this.rmcpPacket.compeletecode == 0) {
                        String xxt;
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_succeeded_SNMP_Alerting_Destinations_-_") + (i + 1));
                        BMCIP = (byte[])this.rmcpPacket.retValue.get(1);
                        this.SNMPServers[j][0] = xxt = (BMCIP[3] & 0xFF) + "." + (BMCIP[4] & 0xFF) + "." + (BMCIP[5] & 0xFF) + "." + (BMCIP[6] & 0xFF);
                        this.BKSNMPServers[j][0] = xxt;
                        this.SNMPServers[j][1] = xxt = this.ByteToMAC(BMCIP, 7);
                        this.BKSNMPServers[j][1] = xxt;
                        ++j;
                    } else {
                        this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_SNMP_Alerting_Destinations_-_") + (i + 1));
                    }
                } else {
                    this.Message.setText(L.t("bmc.Getting_LAN_Configuration_failed_SNMP_Alerting_Destinations_-_") + (i + 1));
                }
                this.Session.releaselock();
                continue;
            }
        }
        String[] toolTipStr = new String[]{L.t("bmc.SNMP_trap_receivers_IP_address"), L.t("bmc.SNMP_trap_receivers_MAC_address")};
        this.jSNMPTable = new JTable(this.SNMPServers, this.ColumnHead);
        this.jSNMPTable.setAutoResizeMode(0);
        this.jSNMPTable.setModel(this.dataModel);
        this.jScrollPane1.setVisible(true);
        ToolTipHeader header = new ToolTipHeader(this.jSNMPTable.getColumnModel());
        header.setToolTipStrings(toolTipStr);
        header.setToolTipText("Default ToolTip TEXT");
        this.jSNMPTable.setTableHeader(header);
        TableColumn tc = this.jSNMPTable.getColumn(L.t("bmc.IP_Address"));
        tc.setPreferredWidth(140);
        tc = this.jSNMPTable.getColumn(L.t("bmc.MAC_Address"));
        tc.setPreferredWidth(140);
        this.jSNMPTable.setFont(new Font("Courier New", 0, 12));
        this.jSNMPTable.setForeground(Color.blue);
        this.jScrollPane1.setViewportView(this.jSNMPTable);
        if (this.Session.isPeppercon || this.Session.isAMI) {
            SizeRequirements size = new SizeRequirements();
            TableColumn col = this.jSNMPTable.getColumnModel().getColumn(1);
            SizeRequirements temp = new SizeRequirements();
            temp.preferred = col.getPreferredWidth();
            temp.minimum = col.getMinWidth();
            temp.maximum = col.getMaxWidth();
            col.setMinWidth(size.minimum);
            col.setMaxWidth(size.maximum);
            col.setPreferredWidth(size.preferred);
            this.jSNMPTable.getColumn(L.t("bmc.IP_Address")).setPreferredWidth(200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SetLANConfiguration(byte Selector, byte[] value) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{1, 0};
        int[] length = new int[1];
        boolean intTemp = false;
        boolean iNumRec = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            reqdata[1] = Selector;
            Para.addElement(reqdata);
            Para.addElement(value);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)1, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    // empty if block
                }
                Logger.writeLog("code =" + this.rmcpPacket.compeletecode);
            }
            this.Session.releaselock();
        }
    }

    private boolean LongAsciiCmd(String Keyword) {
        Vector[] retValue = new Vector[1];
        boolean bFirst = true;
        boolean bResult = false;
        int offset = 0;
        while (Keyword.length() > 0) {
            if (Keyword.length() > 36) {
                String tempString = Keyword.substring(0, 36);
                bResult = bFirst ? this._LongAsciiCmd(tempString, bFirst, false, Keyword.length()) : this._LongAsciiCmd(tempString, bFirst, false, offset);
                Keyword = Keyword.substring(36);
                offset += 36;
                bFirst = false;
                continue;
            }
            bResult = this._LongAsciiCmd(Keyword, bFirst, true, offset);
            Keyword = "";
        }
        return bResult;
    }

    private boolean _LongAsciiCmd(String Keyword, boolean bFirst, boolean bLast, int length_offset) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        int stroutlen = Keyword.length();
        byte[] cmddata = new byte[stroutlen + 2];
        cmddata[0] = (byte)(length_offset >> 8 & 0xFFF);
        cmddata[0] = (byte)(cmddata[0] | (byte)((bFirst ? 128 : 0) | (bLast ? 64 : 0)));
        cmddata[1] = (byte)(length_offset & 0xFFFFFFFF);
        System.arraycopy(Keyword.getBytes(), 0, cmddata, 2, stroutlen);
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.Session.IncreaseSessionSeq();
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean LongAsciiCmdGo(Vector retValue) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Vector retTemp = new Vector(1);
        boolean bResult = false;
        String retString = "";
        byte[] cmddata = new byte[]{0, 0};
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        byte retbyte = 0;
        do {
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    retTemp = this.rmcpPacket.retValue;
                    bResult = true;
                }
                byte[] retbytes = (byte[])retTemp.get(0);
                retbyte = retbytes[0];
                retString = retString + (String)retTemp.get(1);
            }
            cmddata[0] = (byte)(cmddata[0] | (byte)(retString.length() >> 8 & 0xFFFFFFFF));
            cmddata[1] = (byte)(retString.length() & 0xFFFFFFFF);
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(cmddata);
        } while ((retbyte & 0x40) == 0);
        this.Session.releaselock();
        cmddata[0] = (byte)(retString.length() >> 8 & 0xFFFFFFFF);
        cmddata[1] = (byte)(retString.length() & 0xFFFFFFFF);
        retValue.removeAllElements();
        retValue.addElement(cmddata);
        retValue.addElement(retString);
        return bResult;
    }

    private void initComponents() {
        Font borderFont = new Font("default", 0, 11);
        this.jPanel5 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jIPAddress = new JTextField();
        this.jLabel5 = new JLabel();
        this.jMACAddress = new JTextField();
        this.jLabel6 = new JLabel();
        this.jNetMask = new JTextField();
        this.jLabel7 = new JLabel();
        this.jGateway = new JTextField();
        this.jLabel8 = new JLabel();
        this.jGWMAC = new JTextField();
        this.jUpdateLAN = new JButton();
        this.jDHCPCheckBox = new JCheckBox();
        this.jLabel10 = new JLabel();
        this.jALERT = new JPanel();
        this.jUpdateSNMP = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jCommunity = new JTextField();
        this.jPanel6 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jSNMPTable = new JTable();
        this.jPanel2 = new JPanel();
        this.jRS232 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel9 = new JLabel();
        this.jPPPInit = new JTextField();
        this.jUpdateRS232 = new JButton();
        this.jPanel3 = new JPanel();
        this.jRefresh = new JButton();
        this.jVLANLabel = new JLabel();
        this.jVLANTagTextField = new JTextField();
        this.jVLANIsEnabledCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(3, 0));
        this.add((Component)contentPanel, "North");
        this.jPanel5.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel5.setBorder(new TitledBorder(null, L.t("bmc.BMC_LAN_Configuration"), 0, 2, borderFont, Color.BLUE));
        this.jLabel4.setText(L.t("bmc.IP_Address"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel4, new AbsoluteConstraints(12, 30, 80, -1));
        this.jIPAddress.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jIPAddress, new AbsoluteConstraints(100, 30, 110, -1));
        this.jLabel5.setText(L.t("bmc.LAN_MAC"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel5, new AbsoluteConstraints(220, 30, 90, -1));
        this.jMACAddress.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jMACAddress, new AbsoluteConstraints(320, 30, 110, -1));
        this.jLabel6.setText(L.t("bmc.Subnet_Mask"));
        this.jLabel6.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel6, new AbsoluteConstraints(10, 90, 80, -1));
        this.jNetMask.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jNetMask, new AbsoluteConstraints(100, 90, 110, -1));
        this.jVLANLabel.setText("VLAN Tag");
        this.jVLANLabel.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jVLANLabel, new AbsoluteConstraints(10, 120, 80, -1));
        this.jVLANTagTextField.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jVLANTagTextField, new AbsoluteConstraints(100, 120, 110, -1));
        this.jVLANIsEnabledCheckBox.setText("Enable VLAN tagging");
        this.jPanel5.add((Component)this.jVLANIsEnabledCheckBox, new AbsoluteConstraints(215, 120, 150, -1));
        this.jVLANIsEnabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (BMC_Manage20.this.jVLANIsEnabledCheckBox.isSelected()) {
                    BMC_Manage20.this.jVLANTagTextField.setEditable(true);
                } else {
                    BMC_Manage20.this.jVLANTagTextField.setEditable(false);
                }
            }
        });
        this.jLabel7.setText(L.t("bmc.Gateway_IP"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel7, new AbsoluteConstraints(10, 60, 80, -1));
        this.jGateway.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jGateway, new AbsoluteConstraints(100, 60, 110, -1));
        this.jLabel8.setText(L.t("bmc.Gateway_MAC"));
        this.jLabel8.setHorizontalAlignment(4);
        this.jPanel5.add((Component)this.jLabel8, new AbsoluteConstraints(220, 60, 90, -1));
        this.jGWMAC.setForeground(Color.blue);
        this.jPanel5.add((Component)this.jGWMAC, new AbsoluteConstraints(320, 60, 110, -1));
        this.jUpdateLAN.setText(L.t("bmc.Update"));
        this.jUpdateLAN.setEnabled(false);
        this.jUpdateLAN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BMC_Manage20.this.jUpdateLANActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.jUpdateLAN, new AbsoluteConstraints(460, 30, -1, -1));
        this.jDHCPCheckBox.setText("DHCP");
        this.jDHCPCheckBox.setEnabled(true);
        this.jDHCPCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BMC_Manage20.this.jDHCPActionPerformed(evt);
            }
        });
        this.jPanel5.add((Component)this.jDHCPCheckBox, new AbsoluteConstraints(460, 60, -1, -1));
        this.jLabel10.setText(L.t("bmc.LAN_MAC_must_be_correct_while_update"));
        this.jLabel10.setForeground(Color.magenta);
        this.jLabel10.setBackground(Color.white);
        this.jLabel10.setHorizontalAlignment(0);
        this.jLabel10.setBorder(new EtchedBorder());
        this.jLabel10.setOpaque(true);
        this.jPanel5.add((Component)this.jLabel10, new AbsoluteConstraints(220, 90, 260, -1));
        contentPanel.add(this.jPanel5);
        this.jALERT.setLayout((LayoutManager)new AbsoluteLayout());
        this.jALERT.setBorder(new TitledBorder(null, L.t("bmc.SNMP"), 0, 2, borderFont, Color.BLUE));
        this.jUpdateSNMP.setText(L.t("bmc.Update"));
        this.jUpdateSNMP.setEnabled(false);
        this.jUpdateSNMP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BMC_Manage20.this.jUpdateSNMPActionPerformed(evt);
            }
        });
        this.jALERT.add((Component)this.jUpdateSNMP, new AbsoluteConstraints(460, 20, -1, -1));
        this.jLabel1.setText(L.t("bmc.Community"));
        this.jLabel1.setHorizontalAlignment(4);
        this.jALERT.add((Component)this.jLabel1, new AbsoluteConstraints(30, 20, 120, -1));
        this.jLabel2.setText(L.t("bmc.SNMP_Trap_Receivers"));
        this.jLabel2.setHorizontalAlignment(4);
        this.jALERT.add((Component)this.jLabel2, new AbsoluteConstraints(30, 50, -1, -1));
        this.jCommunity.setForeground(Color.blue);
        this.jALERT.add((Component)this.jCommunity, new AbsoluteConstraints(170, 20, 150, -1));
        this.jPanel6.setLayout(new FlowLayout(0));
        this.jScrollPane1.setPreferredSize(new Dimension(278, 85));
        this.jSNMPTable.setForeground(Color.blue);
        this.jSNMPTable.setFont(new Font("Courier New", 0, 12));
        this.jSNMPTable.setPreferredSize(new Dimension(278, 80));
        this.jSNMPTable.setPreferredScrollableViewportSize(new Dimension(278, 80));
        this.jScrollPane1.setViewportView(this.jSNMPTable);
        this.jPanel6.add(this.jScrollPane1);
        this.jALERT.add((Component)this.jPanel6, new AbsoluteConstraints(160, 50, 285, 100));
        contentPanel.add(this.jALERT);
        this.jPanel2.setLayout(new BorderLayout());
        this.jRS232.setLayout((LayoutManager)new AbsoluteLayout());
        this.jRS232.setBorder(new TitledBorder("RS232 / MODEM"));
        this.jLabel3.setText("Baud Rate");
        this.jLabel3.setHorizontalAlignment(4);
        this.jRS232.add((Component)this.jLabel3, new AbsoluteConstraints(40, 40, 120, -1));
        this.jComboBox1.setBackground(Color.white);
        this.jRS232.add((Component)this.jComboBox1, new AbsoluteConstraints(170, 40, 130, -1));
        this.jLabel9.setText("Modem Init String");
        this.jLabel9.setHorizontalAlignment(4);
        this.jRS232.add((Component)this.jLabel9, new AbsoluteConstraints(40, 80, 120, -1));
        this.jRS232.add((Component)this.jPPPInit, new AbsoluteConstraints(170, 80, 130, -1));
        this.jUpdateRS232.setText("Update");
        this.jUpdateRS232.setEnabled(false);
        this.jUpdateRS232.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BMC_Manage20.this.jUpdateRS232ActionPerformed(evt);
            }
        });
        this.jRS232.add((Component)this.jUpdateRS232, new AbsoluteConstraints(460, 40, -1, -1));
        this.jPanel2.add((Component)this.jRS232, "Center");
        this.jRefresh.setText(L.t("bmc.Refresh"));
        this.jRefresh.setEnabled(false);
        this.jRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BMC_Manage20.this.jRefreshActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jRefresh);
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.initModels();
        this.initConfigurationPanel(this.configModel);
        contentPanel.add(this.configurationPanel);
        this.add((Component)this.jPanel2, "South");
    }

    private void initModels() {
        this.configModel = new BMC_Manage20ConfigModel(this, null);
    }

    private IPMIInterfaceConfig getIPMIConfig() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.Session.SIP);
        config.setUserName(this.Session.userID);
        config.setPassword(new String(this.Session.UserPassword));
        config.setPrivilege(this.Session.MaxLevel[0]);
        return config;
    }

    private void initConfigurationPanel(BMC_Manage20ConfigModel model) {
        this.configurationPanel = new JPanel();
        this.configurationPanel.setVisible(false);
        this.configurationPanel.setBorder(new TitledBorder(null, L.t("bmc.BMC_CONFIGURATION_MANIPULATION"), 0, 2, new Font("default", 0, 11), Color.BLUE));
        this.configurationPanel.setLayout(new GridLayout(2, 1));
        this.configurationPanel.add(new JLabel("Backup/Restore configuration data"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        this.backupButton = new JButton("Backup");
        this.backupButton.addActionListener(model);
        this.backupButton.setToolTipText("Backup configuration");
        buttonPanel.add(this.backupButton);
        this.restoreButton = new JButton("Restore");
        this.restoreButton.addActionListener(model);
        this.restoreButton.setToolTipText("Restore configuration");
        buttonPanel.add(this.restoreButton);
        this.configurationPanel.add(buttonPanel);
    }

    private void updateConfigurationPanel() {
        IPMIInterfaceConfig config = this.getIPMIConfig();
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        if (sessionController == null) {
            return;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return;
        }
        ipmiOEMCommand.setIPMIInterface(rmcp);
        boolean isExist = ipmiOEMCommand.isBackupAndRestoreFuncExist();
        if (isExist) {
            this.configurationPanel.setVisible(true);
        } else {
            this.configurationPanel.setVisible(false);
        }
        this.configModel.setIPMIConfig(config);
    }

    private void jUpdateRS232ActionPerformed(ActionEvent evt) {
        String[] cmd = new String[]{"BAUDRATE", "PPP_INIT"};
        Vector retValue = new Vector(1);
        this.Session.Loading = this.TabId;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        for (int i = 0; i < cmd.length; ++i) {
            String xxs = "";
            switch (i) {
                case 0: {
                    int seli = this.jComboBox1.getSelectedIndex();
                    xxs = "0x" + Integer.toHexString(this.BRate[seli]);
                    break;
                }
                case 1: {
                    xxs = this.jPPPInit.getText();
                }
            }
            if (xxs.compareTo(this.BKSetting[i]) == 0) continue;
            String strout = "propset\u0007" + cmd[i] + '\u0007' + xxs + '\u0007';
            if (this.LongAsciiCmd(strout)) {
                this.LongAsciiCmdGo(retValue);
            }
            this.BKSetting[i] = xxs;
        }
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        this.Message.setText("RS232 Information Update done");
        this.Session.Loading = -1;
    }

    private void jUpdateSNMPActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                boolean length = false;
                boolean prindex = false;
                boolean lastpacket = false;
                boolean parseStatus = false;
                BMC_Manage20.this.Session.Loading = BMC_Manage20.this.TabId;
                Cursor csrTemp = new Cursor(3);
                BMC_Manage20.this.setCursor(csrTemp);
                boolean Changed = false;
                Vector[] retValue = new Vector[1];
                String strout = new String();
                if (BMC_Manage20.this.jCommunity.getText().compareTo(BMC_Manage20.this.BKCommunity) != 0) {
                    byte[] value = new byte[18];
                    System.arraycopy(BMC_Manage20.this.jCommunity.getText().getBytes(), 0, value, 0, BMC_Manage20.this.jCommunity.getText().length());
                    BMC_Manage20.this.SetLANConfiguration((byte)16, value);
                    Changed = true;
                }
                byte[] value1 = new byte[13];
                for (int i = 0; i < BMC_Manage20.this.jSNMPTable.getRowCount(); ++i) {
                    boolean b;
                    value1[0] = (byte)(i + 1 & 0xF);
                    value1[2] = 0;
                    value1[1] = 0;
                    String IPx = (String)BMC_Manage20.this.jSNMPTable.getValueAt(i, 0);
                    if (IPx == null || IPx.length() == 0) continue;
                    System.arraycopy(BMC_Manage20.this.IPToByte(IPx), 0, value1, 3, 4);
                    String MACx = (String)BMC_Manage20.this.jSNMPTable.getValueAt(i, 1);
                    if (MACx == null || MACx.length() == 0) {
                        MACx = "00:00:00:00:00:00";
                    }
                    System.arraycopy(BMC_Manage20.this.MACToByte(MACx), 0, value1, 7, 6);
                    BMC_Manage20.this.SetLANConfiguration((byte)19, value1);
                    if (BMC_Manage20.this.Session.isPeppercon) {
                        b = BMC_Manage20.this.helpAddSNMPforPeppercon((byte)(i + 1));
                    } else if (BMC_Manage20.this.Session.isAMI) {
                        b = IPx.equals("0.0.0.0") ? BMC_Manage20.this.helpAddSNMPforAMI((byte)(i + 1), false) : BMC_Manage20.this.helpAddSNMPforAMI((byte)(i + 1), true);
                    }
                    Changed = true;
                }
                csrTemp = new Cursor(0);
                BMC_Manage20.this.setCursor(csrTemp);
                if (Changed) {
                    BMC_Manage20.this.reloadSNMPCfg();
                }
                BMC_Manage20.this.Session.Loading = -1;
            }
        };
        th.start();
    }

    private boolean helpAddSNMPforPeppercon(byte destinationIndex) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.Session.SIP);
        config.setUserName(this.Session.userID);
        config.setPassword(new String(this.Session.UserPassword));
        config.setPrivilege(this.Session.MaxLevel[0]);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return false;
        }
        ipmiPEFCommand.setIPMIInterface(rmcp);
        ipmiLanCommand.setIPMIInterface(rmcp);
        byte policyNumber = 0;
        boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(destinationIndex, policyNumber, destinationIndex);
        boolean b3 = ipmiLanCommand.setDefaultPEFDestinationType(destinationIndex);
        sessionController.closeSession();
        return b1 & b2 & b3;
    }

    private boolean helpAddSNMPforAMI(byte destinationIndex, boolean isSet) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.Session.SIP);
        config.setUserName(this.Session.userID);
        config.setPassword(new String(this.Session.UserPassword));
        config.setPrivilege(this.Session.MaxLevel[0]);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(null);
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            return false;
        }
        ipmiPEFCommand.setIPMIInterface(rmcp);
        ipmiLanCommand.setIPMIInterface(rmcp);
        boolean policyNumber = false;
        boolean b1 = true;
        boolean b2 = true;
        for (int i = 1; i <= 4; ++i) {
            if (isSet) {
                boolean isEnable = false;
                byte channel = 0;
                isEnable = true;
                channel = 1;
                b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((destinationIndex - 1) * 4 + i), (byte)i, isEnable, channel, destinationIndex);
                continue;
            }
            b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((destinationIndex - 1) * 4 + i), (byte)i, false, (byte)0, destinationIndex);
        }
        boolean b3 = ipmiLanCommand.setDefaultPEFDestinationType(destinationIndex);
        sessionController.closeSession();
        return b1 & b2 & b3;
    }

    private void jDHCPActionPerformed(ActionEvent evt) {
        this.setDHCPUIStatus(this.jDHCPCheckBox.isSelected());
    }

    public void setDHCPUIStatus(boolean isEnable) {
        this.jIPAddress.setEnabled(!isEnable);
        this.jMACAddress.setEnabled(!isEnable);
        this.jGateway.setEnabled(!isEnable);
        this.jNetMask.setEnabled(!isEnable);
    }

    private void jUpdateLANActionPerformed(ActionEvent evt) {
        if (0 != JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("bmc.LAN_MAC_must_be_correct_while_update_Are_you_sure") + "\n This session will be terminated.", "", 0)) {
            return;
        }
        Thread th = new Thread(){

            public void run() {
                byte[] value;
                boolean length = false;
                boolean prindex = false;
                boolean lastpacket = false;
                boolean parseStatus = false;
                BMC_Manage20.this.Session.Loading = BMC_Manage20.this.TabId;
                Cursor csrTemp = new Cursor(3);
                BMC_Manage20.this.setCursor(csrTemp);
                boolean Changed = false;
                if (BMC_Manage20.this.jDHCPCheckBox.isSelected() != BMC_Manage20.this.isDHCP) {
                    value = new byte[]{BMC_Manage20.this.jDHCPCheckBox.isSelected() ? (byte)2 : 1};
                    BMC_Manage20.this.Message.setText(L.t("Changing DHCP setting"));
                    BMC_Manage20.this.SetLANConfiguration((byte)4, value);
                    BMC_Manage20.this.Message.setText(L.t("Changing DHCP setting done"));
                    Changed = true;
                }
                if (BMC_Manage20.this.jMACAddress.getText().compareTo(BMC_Manage20.this.MACAddress) != 0) {
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_MAC_Address_in_BMC"));
                    value = new byte[6];
                    System.arraycopy(BMC_Manage20.this.MACToByte(BMC_Manage20.this.jMACAddress.getText()), 0, value, 0, 6);
                    BMC_Manage20.this.SetLANConfiguration((byte)5, value);
                    Changed = true;
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_MAC_Address_in_BMC_done"));
                }
                if (BMC_Manage20.this.jIPAddress.getText().compareTo(BMC_Manage20.this.IPAddress) != 0) {
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_IP_Address_in_BMC"));
                    value = new byte[4];
                    System.arraycopy(BMC_Manage20.this.IPToByte(BMC_Manage20.this.jIPAddress.getText()), 0, value, 0, 4);
                    BMC_Manage20.this.SetLANConfiguration((byte)3, value);
                    Changed = true;
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_IP_Address_in_BMC_done"));
                }
                if (BMC_Manage20.this.jNetMask.getText().compareTo(BMC_Manage20.this.NetMask) != 0) {
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Netmask_in_BMC"));
                    value = new byte[4];
                    System.arraycopy(BMC_Manage20.this.IPToByte(BMC_Manage20.this.jNetMask.getText()), 0, value, 0, 4);
                    BMC_Manage20.this.SetLANConfiguration((byte)6, value);
                    Changed = true;
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Netmask_in_BMC_done"));
                }
                if (BMC_Manage20.this.jGateway.getText().compareTo(BMC_Manage20.this.Gateway) != 0) {
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Default_Gateway_in_BMC"));
                    value = new byte[4];
                    System.arraycopy(BMC_Manage20.this.IPToByte(BMC_Manage20.this.jGateway.getText()), 0, value, 0, 4);
                    BMC_Manage20.this.SetLANConfiguration((byte)12, value);
                    Changed = true;
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Default_Gateway_in_BMC_done"));
                }
                if (BMC_Manage20.this.jGWMAC.getText().compareTo(BMC_Manage20.this.GWMAC) != 0) {
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Default_Gateway_MAC_Address_in_BMC"));
                    value = new byte[6];
                    System.arraycopy(BMC_Manage20.this.MACToByte(BMC_Manage20.this.jGWMAC.getText()), 0, value, 0, 6);
                    BMC_Manage20.this.SetLANConfiguration((byte)13, value);
                    Changed = true;
                    BMC_Manage20.this.Message.setText(L.t("bmc.Changing_LAN_Default_Gateway_MAC_Address_in_BMC_done"));
                }
                if (BMC_Manage20.this.jVLANIsEnabledCheckBox.isSelected() != BMC_Manage20.this.isEnableVLAN || BMC_Manage20.this.jVLANTagTextField.getText().compareTo(BMC_Manage20.this.vlanTag) != 0) {
                    int vlanTag = 0;
                    boolean isEnable = BMC_Manage20.this.jVLANIsEnabledCheckBox.isSelected();
                    boolean isValidatePass = true;
                    try {
                        vlanTag = Integer.parseInt(BMC_Manage20.this.jVLANTagTextField.getText());
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), "VLAN Tag should be Integer", "error", 0);
                        isValidatePass = false;
                    }
                    if (vlanTag > 4094 || vlanTag < 0) {
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), "VLAN Tag Invalid. 0 < vlanTag < 4095 ", "error", 0);
                        isValidatePass = false;
                    }
                    if (isValidatePass) {
                        byte[] data = new byte[]{(byte)vlanTag, (byte)(vlanTag >> 8)};
                        if (isEnable) {
                            data[1] = (byte)(data[1] | 0x80);
                        }
                        BMC_Manage20.this.Message.setText(L.t("Changing VLAN setting"));
                        BMC_Manage20.this.SetLANConfiguration((byte)20, data);
                        BMC_Manage20.this.Message.setText(L.t("Changing VLAN setting done"));
                        Changed = true;
                    }
                }
                csrTemp = new Cursor(0);
                BMC_Manage20.this.setCursor(csrTemp);
                Changed = true;
                if (true) {
                    IPMIView20.getInstance().closeActivatelySession();
                }
            }
        };
        th.start();
    }

    private void jRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                BMC_Manage20.this.reload();
            }
        };
        th.start();
    }

    private void reloadLanCfg() {
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        this.Message.setText(L.t("bmc.Loading_LAN_Configuration_Information"));
        this.AnyChangableSNMP = false;
        this.IPAddress = "";
        this.MACAddress = "";
        this.NetMask = "";
        this.Gateway = "";
        this.GWMAC = "";
        this.GetLANConfiguration();
        this.Message.setText(L.t("bmc.Loading_LAN_Configuration_Information_done"));
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reloadSNMPCfg() {
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        this.Message.setText(L.t("bmc.Loading_SNMP_Information"));
        this.BKSMTPServer = "";
        this.BKCommunity = "";
        this.RWChangable[0] = false;
        this.RWChangable[1] = false;
        this.GetSNMPConfiguration();
        this.Message.setText(L.t("bmc.Loading_SNMP_Information_done"));
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reloadRS232() {
        Cursor csrTemp;
        block21: {
            block18: {
                block19: {
                    int i;
                    String[] cmd = new String[]{"propget", "BAUDRATE", "PPP_INIT"};
                    Vector retValue = new Vector(1);
                    csrTemp = new Cursor(3);
                    this.setCursor(csrTemp);
                    this.Message.setText("Loading RS232 Information");
                    String strout = "";
                    for (i = 0; i < cmd.length; ++i) {
                        strout = strout + cmd[i] + '\u0007';
                    }
                    if (!this.LongAsciiCmd(strout)) break block18;
                    if (!this.LongAsciiCmdGo(retValue)) break block19;
                    byte[] retbytes = (byte[])retValue.get(0);
                    String retString = (String)retValue.get(1);
                    int length = retString.length();
                    int prindex = 0;
                    int parseStatus = 0;
                    while (prindex < length) {
                        int ipos;
                        block20: {
                            ipos = retString.indexOf(7, prindex);
                            if (ipos < 0) break block20;
                            String tempString = retString.substring(prindex, ipos);
                            switch (parseStatus) {
                                case 0: {
                                    for (i = 0; i < cmd.length; ++i) {
                                        if (tempString.compareTo(cmd[i]) != 0) continue;
                                        parseStatus = i + 1;
                                    }
                                    break;
                                }
                                case 1: {
                                    parseStatus = 0;
                                    break;
                                }
                                case 2: {
                                    boolean AnyChangable;
                                    if (tempString.compareTo("RW") == 0) {
                                        AnyChangable = true;
                                        this.jComboBox1.setEnabled(true);
                                    } else {
                                        this.jComboBox1.setEnabled(false);
                                    }
                                    parseStatus = 21;
                                    break;
                                }
                                case 21: {
                                    long l = 0L;
                                    try {
                                        l = Long.parseLong(tempString.substring(2), 16);
                                        for (int kk = 0; kk < this.BRate.length; ++kk) {
                                            if ((long)this.BRate[kk] != l) continue;
                                            this.jComboBox1.setSelectedIndex(kk);
                                            break;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        // empty catch block
                                    }
                                    this.BKSetting[parseStatus / 10 - 2] = tempString;
                                    parseStatus = 0;
                                    break;
                                }
                                case 3: {
                                    boolean AnyChangable;
                                    if (tempString.compareTo("RW") == 0) {
                                        AnyChangable = true;
                                        this.jPPPInit.setEditable(true);
                                    } else {
                                        this.jPPPInit.setEditable(false);
                                    }
                                    parseStatus = 31;
                                    break;
                                }
                                case 31: {
                                    this.jPPPInit.setText(tempString);
                                    this.BKSetting[parseStatus / 10 - 2] = tempString;
                                    parseStatus = 0;
                                }
                            }
                        }
                        prindex = ipos + 1;
                    }
                    this.Message.setText("Loading RS232 Information done");
                    break block21;
                }
                this.Message.setText("Loading RS232 Information failed");
                break block21;
            }
            this.Message.setText("Loading RS232 Information failed");
        }
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
    }

    private void reload() {
        this.Session.Loading = this.TabId;
        Thread th = new Thread(){

            public void run() {
                BMC_Manage20.this.jUpdateLAN.setEnabled(false);
                BMC_Manage20.this.jUpdateSNMP.setEnabled(false);
                BMC_Manage20.this.jUpdateRS232.setEnabled(false);
                BMC_Manage20.this.jRefresh.setEnabled(false);
            }
        };
        th.start();
        this.reloadLanCfg();
        this.reloadSNMPCfg();
        if (this.Session.isPeppercon) {
            this.updateConfigurationPanel();
        }
        th = new Thread(){

            public void run() {
                BMC_Manage20.this.jUpdateLAN.setEnabled(true);
                BMC_Manage20.this.jUpdateSNMP.setEnabled(true);
                BMC_Manage20.this.jUpdateRS232.setEnabled(true);
                BMC_Manage20.this.jRefresh.setEnabled(true);
                BMC_Manage20.this.Message.setText(L.t("bmc.Loading_BMC_Setting_Information_done"));
            }
        };
        th.start();
        this.Session.Loading = -1;
    }

    private String ByteToMAC(byte[] macbyte, int offset) {
        String xx = "";
        String xxs = "0" + Integer.toHexString(macbyte[offset] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 1] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 2] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 3] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 4] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2) + ":";
        xxs = "0" + Integer.toHexString(macbyte[offset + 5] & 0xFF);
        xx = xx + xxs.toUpperCase().substring(xxs.length() - 2);
        return xx;
    }

    private byte[] MACToByte(String MACx) {
        int i;
        byte[] xx = new byte[6];
        byte[] zz = new byte[17];
        if (MACx.length() == 0) {
            return xx;
        }
        String xxt = "";
        for (i = 0; i < 5; ++i) {
            xxt = xxt + MACx.substring(i * 3, i * 3 + 2);
        }
        xxt = xxt + MACx.substring(15);
        long l = 0L;
        try {
            l = Long.parseLong(xxt, 16);
        }
        catch (NumberFormatException e) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("bmc.Invalid_character_in_MAC"));
        }
        for (i = 0; i < 6; ++i) {
            xx[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        byte[] xx_rev = new byte[6];
        for (i = 0; i < 6; ++i) {
            xx_rev[i] = xx[5 - i];
        }
        return xx_rev;
    }

    private byte[] IPToByte(String IPx) {
        byte[] xx = new byte[4];
        if (IPx.length() == 0) {
            return xx;
        }
        int yy = IPx.indexOf(46, 0);
        try {
            xx[3] = (byte)(Integer.parseInt(IPx.substring(0, yy).trim()) & 0xFF);
            int yy1 = IPx.indexOf(46, yy + 1);
            xx[2] = (byte)(Integer.parseInt(IPx.substring(yy + 1, yy1).trim()) & 0xFF);
            yy = yy1;
            yy1 = IPx.indexOf(46, yy + 1);
            xx[1] = (byte)(Integer.parseInt(IPx.substring(yy + 1, yy1).trim()) & 0xFF);
            yy = yy1;
            xx[0] = (byte)(Integer.parseInt(IPx.substring(yy1 + 1).trim()) & 0xFF);
        }
        catch (NumberFormatException ne) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("bmc.Invalid_character_in_IP"));
        }
        byte[] xx_rev = new byte[4];
        for (int i = 0; i < 4; ++i) {
            xx_rev[i] = xx[3 - i];
        }
        return xx_rev;
    }

    class ToolTipHeader
    extends JTableHeader {
        String[] toolTips;

        public ToolTipHeader(TableColumnModel model) {
            super(model);
        }

        public String getToolTipText(MouseEvent e) {
            String retStr;
            int col = this.columnAtPoint(e.getPoint());
            int modelCol = this.getTable().convertColumnIndexToModel(col);
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
            return retStr;
        }

        public void setToolTipStrings(String[] toolTips) {
            this.toolTips = toolTips;
        }
    }
}

