/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.JViewerPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AMIKVMPanel
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    String userID;
    String userPassword;
    String ip;
    boolean isCreateUI = false;
    public JViewerApp app = null;
    public JViewerPanel jviewerPanel = null;

    public AMIKVMPanel(String userID, String userPassword, String ip) {
        this.userID = userID;
        this.userPassword = userPassword;
        this.ip = ip;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
    }

    public void createUI() {
        if (this.isCreateUI) {
            return;
        }
        this.setCursor(new Cursor(3));
        JButton label = new JButton(L.t("kvm.Loading"));
        label.setEnabled(false);
        this.add((Component)label, "Center");
        this.app = new JViewerApp();
        this.app.getParams().SetUserPriv(511);
        this.app.getParams().SetKVMEnabled(1);
        this.app.createUI();
        this.app.setFrame((JFrame)IPMIView20.getInstance());
        this.app.setPanelMode(true);
        try {
            this.app.helpConnectToServer(this.ip, this.userID, this.userPassword);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Failed to connect to KVM server", "Error", 0);
        }
        this.remove(label);
        this.jviewerPanel = this.app.getJViewerPanel((JFrame)IPMIView20.getInstance());
        this.add((Component)this.jviewerPanel, "Center");
        this.setCursor(new Cursor(0));
        this.getParent().repaint();
        this.jviewerPanel.getWindowFocus();
        this.isCreateUI = true;
    }

    private static byte[] getServerIP(String ipStr) {
        boolean invalidIP = false;
        try {
            InetAddress hostAddress = InetAddress.getByName(ipStr);
            ipStr = hostAddress.getHostAddress();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        if (ipStr.trim().length() <= 0) {
            return null;
        }
        String[] ipDgtStr = ipStr.split("\\.");
        if (ipDgtStr.length != 4) {
            return null;
        }
        byte[] ipDgt = new byte[4];
        for (int i = 0; i < 4; ++i) {
            try {
                ipDgt[i] = (byte)Short.parseShort(ipDgtStr[i]);
            }
            catch (NumberFormatException e) {
                return null;
            }
            if (ipDgt[i] <= 255) continue;
            return null;
        }
        return ipDgt;
    }

    public void stopVM() {
        if (this.app != null) {
            this.app.stopVM();
        }
    }

    public void close() {
        if (this.app != null) {
            this.app.OnVideoStopRedirection();
        }
    }
}

