/*
 * Decompiled with CFR 0.152.
 */
package smc.ext;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.awt.event.KeyEvent;
import smc.ext.BladeKVMSwitch;
import smc.ext.KVMType;
import smc.ext.OSDBladeKVMStatusMessage;
import smc.ext.OSDMessage;
import smc.ext.OSDMessageManager;

public class KeyboardHook {
    OSDMessage osdMessage;
    OSDBladeKVMStatusMessage bladeKVMStatusMessage = new OSDBladeKVMStatusMessage();
    OSDMessageManager osdManager;
    BladeKVMSwitch bladeKVMSwitch;
    KVMType kvmType;
    int tempSelectedKVMIndex;
    boolean isSwitchingBladeKVM = false;
    long lastLeftKey = 0L;
    long lastRightKey = 0L;

    public KeyboardHook() {
        this.osdMessage = new OSDMessage("", 25, 40);
    }

    public void initBladeKVMSwitch(String ip, String id, String password) {
        this.bladeKVMSwitch = new BladeKVMSwitch();
        this.kvmType = new KVMType();
        this.bladeKVMSwitch.init(ip, id, password);
        this.kvmType.init(ip, id, password);
    }

    public boolean keyboardHook(KeyEvent k) {
        if (k.getID() == 402) {
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 112) {
                    this.switchBladeKVM(1);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 113) {
                    this.switchBladeKVM(2);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 114) {
                    this.switchBladeKVM(3);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 115) {
                    this.switchBladeKVM(4);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 116) {
                    this.switchBladeKVM(5);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 117) {
                    this.switchBladeKVM(6);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 118) {
                    this.switchBladeKVM(7);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 119) {
                    this.switchBladeKVM(8);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 120) {
                    this.switchBladeKVM(9);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 121) {
                    this.switchBladeKVM(10);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 122) {
                    this.switchBladeKVM(11);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 123) {
                    this.switchBladeKVM(12);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 51) {
                    this.switchBladeKVM(13);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 52) {
                    this.switchBladeKVM(14);
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 37) {
                    this.switchKVMToLeftBlade();
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 39) {
                    this.switchKVMToRightBlade();
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 38) {
                    this.showBladeStatusInfo();
                    return true;
                }
            }
            if (k.isControlDown() && !k.isAltDown() && !k.isShiftDown()) {
                if (k.getKeyCode() == 40) {
                    this.closeBladeStatusInfo();
                    return true;
                }
            }
        }
        return false;
    }

    private void showBladeStatusInfo() {
        if (this.kvmType.getKVMType() != 20) {
            return;
        }
        this.showBladeNumberOSD();
        this.bladeKVMStatusMessage.x = 20;
        this.bladeKVMStatusMessage.y = 120;
        BladeSystemEntity bladeSystemEntity = this.bladeKVMSwitch.getBladeSystemEntity();
        if (bladeSystemEntity != null) {
            this.bladeKVMStatusMessage.setBladeSystemEntity(bladeSystemEntity);
            this.bladeKVMStatusMessage.setCmmIP(this.bladeKVMSwitch.config.getIp());
            this.osdManager.addOSDMessage(this.bladeKVMStatusMessage);
        }
    }

    private void closeBladeStatusInfo() {
        this.osdManager.removeAllOSD();
    }

    private void switchKVMToRightBlade() {
        if (this.isSwitchingBladeKVM) {
            return;
        }
        if (this.kvmType.getKVMType() != 20) {
            return;
        }
        this.isSwitchingBladeKVM = true;
        Thread thread = new Thread(){

            public void run() {
                KeyboardHook.this.helpSwitchRightBlade();
                KeyboardHook.this.isSwitchingBladeKVM = false;
            }
        };
        thread.start();
    }

    private void helpSwitchRightBlade() {
        int nextIndex = 0;
        try {
            nextIndex = this.bladeKVMSwitch.switchToRight();
        }
        catch (Exception ex) {
            return;
        }
        this.osdMessage.message = "Blade " + nextIndex;
        this.showBladeNumberOSD();
    }

    private void switchKVMToLeftBlade() {
        if (this.isSwitchingBladeKVM) {
            return;
        }
        if (this.kvmType.getKVMType() != 20) {
            return;
        }
        this.isSwitchingBladeKVM = true;
        Thread thread = new Thread(){

            public void run() {
                KeyboardHook.this.helpSwitchLeftBlade();
                KeyboardHook.this.isSwitchingBladeKVM = false;
            }
        };
        thread.start();
    }

    private void helpSwitchLeftBlade() {
        int nextIndex = 0;
        try {
            nextIndex = this.bladeKVMSwitch.switchToLeft();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.osdMessage.message = "Blade " + nextIndex;
        this.showBladeNumberOSD();
    }

    private void switchBladeKVM(int index) {
        if (this.isSwitchingBladeKVM) {
            return;
        }
        if (this.kvmType.getKVMType() != 20) {
            return;
        }
        this.isSwitchingBladeKVM = true;
        this.tempSelectedKVMIndex = index;
        Thread thread = new Thread(){

            public void run() {
                KeyboardHook.this.helpSwitchBladeKVM();
                KeyboardHook.this.isSwitchingBladeKVM = false;
            }
        };
        thread.start();
    }

    private void helpSwitchBladeKVM() {
        try {
            boolean isPresent = this.bladeKVMSwitch.isBladePresent(this.tempSelectedKVMIndex);
            if (!isPresent) {
                this.osdMessage.message = "N/A";
                this.osdManager.removeAllOSD();
                this.osdManager.addOSDMessage(this.osdMessage);
                return;
            }
            this.bladeKVMSwitch.requestKVM(this.tempSelectedKVMIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.osdMessage.message = "Blade " + this.tempSelectedKVMIndex;
        this.showBladeNumberOSD();
    }

    private void showBladeNumberOSD() {
        try {
            BladeKVMSwitch.CurrentAndNextKVM currentAndNextKVM = this.bladeKVMSwitch.getCurrentAndNextKVM();
            this.osdMessage.message = "Blade " + currentAndNextKVM.current;
        }
        catch (Exception ex) {
            return;
        }
        this.osdManager.removeAllOSD();
        this.osdManager.addOSDMessage(this.osdMessage);
    }

    public void setOsdManager(OSDMessageManager osdManager) {
        this.osdManager = osdManager;
    }

    public OSDMessageManager getOsdManager() {
        return this.osdManager;
    }
}

