/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import nn.pp.rc.RFBRenderer;
import nn.pp.rc.T;

public abstract class TrueColorRFBRenderer
extends RFBRenderer
implements ImageObserver {
    static final int sh = 16;
    static final int sw = 16;
    protected Dimension mysize;
    protected Dimension padsize;
    protected Image simg;
    private MemoryImageSource simgsrc;
    private int[] simgmem;
    private byte[] simgmemb;
    private int transx = 0;
    private int transy = 0;
    private int[] intcolors;
    private boolean lrle_debug = false;
    private LRLEColorDecoder lrle_dec;
    private int lrle_subenc = -1;
    private byte[] rimgmemb;
    private byte[] rimgtempb;

    public abstract void setInterpol(boolean var1);

    public abstract void paint(Graphics var1, boolean var2, Dimension var3);

    public abstract void repaint();

    public abstract void sendUpdateMsg() throws IOException;

    public TrueColorRFBRenderer(Component comp) {
        super(comp);
        DirectColorModel colormodel = new DirectColorModel(16, 63488, 2016, 31);
        this.intcolors = new int[65536];
        for (int i = 0; i < 65536; ++i) {
            this.intcolors[i] = colormodel.getRGB(i);
        }
        colormodel = new DirectColorModel(15, 31744, 992, 31);
        colormodel = new DirectColorModel(6, 63, 63, 63);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPixelMsg() throws IOException {
        TrueColorRFBRenderer trueColorRFBRenderer = this;
        synchronized (trueColorRFBRenderer) {
            this.rfb.writeSetPixelFormat(16, 16, true, true, 31, 63, 31, 11, 5, 0);
        }
    }

    public void setRenderSize(Dimension d) {
        super.setRenderSize(d);
        this.mysize = d;
        this.createSImg(d);
    }

    private void createSImg(Dimension d) {
        if (this.simg != null) {
            this.simg.flush();
        }
        this.padsize = new Dimension(d);
        if (this.padsize.width % 16 != 0) {
            this.padsize.width = (this.padsize.width / 16 + 1) * 16;
        }
        if (this.padsize.height % 16 != 0) {
            this.padsize.height = (this.padsize.height / 16 + 1) * 16;
        }
        this.simgmemb = new byte[2 * this.padsize.width * this.padsize.height];
        this.simgmem = new int[this.padsize.width * this.padsize.height];
        this.jimgsrc = this.simgsrc = new MemoryImageSource(d.width, d.height, this.simgmem, 0, d.width);
        this.simgsrc.setAnimated(true);
        this.simg = this.comp.createImage(this.simgsrc);
    }

    void checkRawBufSize(int newSize) {
        if (this.rimgmemb == null || this.rimgmemb.length < newSize) {
            this.rimgmemb = new byte[newSize];
        }
    }

    void checkRawTmpBufSize(int newSize) {
        if (this.rimgtempb == null || this.rimgtempb.length < newSize) {
            this.rimgtempb = new byte[newSize];
        }
    }

    private void byteToIntBuffer(byte[] bb, int off_in, int[] ib, int off, int c, boolean is_be) {
        for (int i = 0; i < c; ++i) {
            int bi = 2 * i + off_in;
            int index = is_be ? (bb[bi + 0] & 0xFF) << 8 | bb[bi + 1] & 0xFF : (bb[bi + 1] & 0xFF) << 8 | bb[bi + 0] & 0xFF;
            ib[off + i] = this.intcolors[index];
        }
    }

    public void drawRawRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        this.finishBufferedReading(this.rfb.is_rect);
        for (int i = y; i < y + h; ++i) {
            this.rfb.is_rect.readFully(this.simgmemb, 0, 2 * w);
            this.byteToIntBuffer(this.simgmemb, 0, this.simgmem, i * this.mysize.width + x, w, bigEndian);
        }
        this.simgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.simg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
    }

    public void drawRawVSCRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int i;
        int TILE_WIDTH = 16;
        int TILE_HEIGHT = 16;
        byte flags = this.rfb.is_rect.readByte();
        if ((flags & 1) == 0) {
            this.drawRawRect(x, y, w, h, bigEndian);
            return;
        }
        int c = 2 * w * h;
        this.checkRawTmpBufSize(c);
        this.rfb.is_rect.readFully(this.rimgtempb, 0, c);
        w = Math.min(w, this.mysize.width - x);
        h = Math.min(h, this.mysize.height - y);
        c = 2 * w * h;
        this.checkRawBufSize(c);
        int indexsrc = 0;
        int indexdst = 0;
        int indexsrcstart = 0;
        int lines = 0;
        int rows = 0;
        for (i = 0; i < h; ++i) {
            int cols = 0;
            for (int j = 0; j < w; ++j) {
                this.rimgmemb[indexdst++] = this.rimgtempb[indexsrc++];
                this.rimgmemb[indexdst++] = this.rimgtempb[indexsrc++];
                if (++cols != TILE_WIDTH) continue;
                indexsrc += (TILE_HEIGHT - 1) * TILE_WIDTH * 2;
                cols = 0;
            }
            indexsrc = indexsrcstart + ++lines * TILE_WIDTH * 2;
            if (lines != TILE_HEIGHT) continue;
            indexsrc = indexsrcstart = ++rows * TILE_HEIGHT * w * 2;
            lines = 0;
        }
        for (i = y; i < y + h; ++i) {
            this.byteToIntBuffer(this.rimgmemb, (i - y) * w * 2, this.simgmem, i * this.mysize.width + x, w, (flags & 4) == 4);
        }
        this.simgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.simg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
    }

    public void drawCopyRect(int srcX, int srcY, int x, int y, int w, int h) throws IOException {
        throw new IOException(T._("True color CopyRect encoding not implemented"));
    }

    public void drawHextileRect(int x, int y, int w, int h, boolean bigEndian) throws IOException {
        int bg = 0;
        int fg = 0;
        int counter = 0;
        for (int ty = y; ty < y + h; ty += 16) {
            for (int tx = x; tx < x + w; tx += 16) {
                int uh;
                int uw;
                int uy;
                int ux;
                int b2;
                int b1;
                int j;
                int tw = 16;
                int th = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                if (y + h - ty < 16) {
                    th = y + h - ty;
                }
                int subencoding = this.readBufferedByte(this.rfb.is_rect);
                ++counter;
                if ((subencoding & 1) != 0) {
                    this.drawRawRect(tx, ty, tw, th, bigEndian);
                    continue;
                }
                if ((subencoding & 2) != 0) {
                    bg = bigEndian ? this.intcolors[(this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8 | this.readBufferedByte(this.rfb.is_rect) & 0xFF] : this.intcolors[this.readBufferedByte(this.rfb.is_rect) & 0xFF | (this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8];
                }
                this.fillRect(bg, tx, ty, tw, th);
                if ((subencoding & 4) != 0) {
                    fg = bigEndian ? this.intcolors[(this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8 | this.readBufferedByte(this.rfb.is_rect) & 0xFF] : this.intcolors[this.readBufferedByte(this.rfb.is_rect) & 0xFF | (this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8];
                }
                if ((subencoding & 8) == 0) continue;
                int nSubrects = this.readBufferedByte(this.rfb.is_rect);
                ++counter;
                this.translate(tx, ty);
                if ((subencoding & 0x10) != 0) {
                    for (j = 0; j < nSubrects; ++j) {
                        fg = bigEndian ? this.intcolors[(this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8 | this.readBufferedByte(this.rfb.is_rect) & 0xFF] : this.intcolors[this.readBufferedByte(this.rfb.is_rect) & 0xFF | (this.readBufferedByte(this.rfb.is_rect) & 0xFF) << 8];
                        b1 = this.readBufferedByte(this.rfb.is_rect);
                        b2 = this.readBufferedByte(this.rfb.is_rect);
                        ux = b1 >> 4;
                        uy = b1 & 0xF;
                        uw = (b2 >> 4) + 1;
                        uh = (b2 & 0xF) + 1;
                        this.fillRect(fg, ux, uy, uw, uh);
                    }
                    counter += nSubrects * 2;
                } else {
                    for (j = 0; j < nSubrects; ++j) {
                        b1 = this.readBufferedByte(this.rfb.is_rect);
                        b2 = this.readBufferedByte(this.rfb.is_rect);
                        ux = b1 >> 4;
                        uy = b1 & 0xF;
                        uw = (b2 >> 4) + 1;
                        uh = (b2 & 0xF) + 1;
                        this.fillRect(fg, ux, uy, uw, uh);
                    }
                    counter += nSubrects * 2;
                }
                this.translate(-tx, -ty);
            }
        }
        this.finishBufferedReading(this.rfb.is_rect);
        this.rfb.min.increaseCounters(counter);
        this.simgsrc.newPixels(x, y, w, h);
        this.gvimg.setClip(x, y, w, h);
        this.gvimg.drawImage(this.simg, 0, 0, null);
        this.gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
    }

    public void drawTightRect(int x, int y, int w, int h) throws IOException {
        throw new IOException(T._("True color tight encoding not implemented"));
    }

    public void drawTightCachedRect(int x, int y, int w, int h) throws IOException {
        throw new IOException(T._("True color tight encoding not implemented"));
    }

    public void dispose() {
        this.simg.flush();
    }

    public void fillRect(int color, int x, int y, int w, int h) {
        for (int iy = y; iy < y + h; ++iy) {
            int off = (this.transy + iy) * this.mysize.width + this.transx;
            for (int ix = x; ix < x + w; ++ix) {
                this.simgmem[off + ix] = color;
            }
        }
    }

    public void translate(int tx, int ty) {
        this.transx += tx;
        this.transy += ty;
    }

    public void setNewTightCacheSize() {
    }

    public void enableTightCache(boolean enable) {
    }

    private void drawLRLEMap(int offset, int x, int y, int w, int h) throws IOException {
        int steps = 8 / this.lrle_dec.conf.grey_depth;
        int mask = (1 << this.lrle_dec.conf.grey_depth) - 1;
        int lineBytes = w / steps;
        int lineRest = w % steps;
        for (int dy = 0; dy < h; ++dy) {
            int k;
            int code;
            for (int segment = 0; segment < lineBytes; ++segment) {
                code = this.readBufferedByte(this.rfb.is_rect);
                for (k = steps - 1; k >= 0; --k) {
                    this.simgmem[offset + dy * this.mysize.width + segment * steps + k] = this.lrle_dec.greys[code & mask];
                    code >>= this.lrle_dec.conf.grey_depth;
                }
            }
            if (lineRest == 0) continue;
            code = this.readBufferedByte(this.rfb.is_rect);
            for (k = lineRest - 1; k >= 0; --k) {
                this.simgmem[offset + dy * this.mysize.width + lineBytes * steps + k] = this.lrle_dec.greys[code & mask];
                code >>= this.lrle_dec.conf.grey_depth;
            }
        }
    }

    public void drawLRLERect(long encoding, int x, int y, int w, int h) throws IOException {
        int run = 0;
        boolean copy = false;
        int color = -16777216;
        Graphics gvimg = this.gvimg;
        int[] eot = new int[2];
        int[] prevLine = new int[w];
        int subenc = (int)(encoding & 0xF000L) >> 12;
        if (this.lrle_subenc == -1 || this.lrle_subenc != subenc) {
            this.lrle_subenc = subenc;
            this.lrle_dec = new LRLEColorDecoder(this.lrle_subenc);
        }
        for (int ty = y; ty < y + h; ty += 16) {
            block6: for (int tx = x; tx < x + w; tx += 16) {
                int tile_offset = ty * this.mysize.width + tx;
                int tw = 16;
                int th = 16;
                if (x + w - tx < 16) {
                    tw = x + w - tx;
                }
                if (y + h - ty < 16) {
                    th = y + h - ty;
                }
                if (this.lrle_dec.conf.is_map) {
                    this.drawLRLEMap(tile_offset, tx, ty, tw, th);
                    continue;
                }
                int dy = 0;
                int dx = 0;
                int cy = 0;
                int cx = 0;
                if (this.lrle_debug) {
                    System.out.println("Tile (" + tx + "," + ty + ")");
                }
                block7: while (true) {
                    if (this.lrle_debug) {
                        System.out.print("(" + dx + "," + dy + ")");
                    }
                    if (dx == 0 && cy + dy == th) {
                        if (!this.lrle_debug) continue block6;
                        System.out.println(" >>END OF TILE");
                        continue block6;
                    }
                    int code = this.readBufferedByte(this.rfb.is_rect);
                    if (this.lrle_debug) {
                        System.out.print(" Code=0x" + Integer.toHexString(code) + " -> ");
                    }
                    if ((code & 0xE0) == 224) {
                        copy = true;
                        int n = run = code == 255 ? this.readBufferedByte(this.rfb.is_rect) : code & 0x1F;
                        if (this.lrle_debug) {
                            System.out.println("COPY " + (run + 1));
                        }
                    } else if (this.lrle_dec.conf.is_compact) {
                        copy = false;
                        if (this.lrle_dec.conf.depth <= 3) {
                            color = this.lrle_dec.colors[code & 7];
                            run = code >> 3;
                            if (this.lrle_debug) {
                                System.out.println("PIXEL=0x" + Integer.toHexString(code & 7) + " (RUN=" + (run + 1) + ") -> 0x" + Integer.toHexString(color));
                            }
                        } else {
                            color = this.lrle_dec.colors[code & 0xF];
                            run = code >> 4;
                            if (this.lrle_debug) {
                                System.out.println("PIXEL=0x" + Integer.toHexString(code & 0xF) + " (RUN=" + (run + 1) + ") -> 0x" + Integer.toHexString(color));
                            }
                        }
                    } else {
                        switch ((code & 0xC0) >> 6) {
                            case 0: 
                            case 1: {
                                if (this.lrle_dec.conf.depth > 7) {
                                    code = code << 8 | this.readBufferedByte(this.rfb.is_rect);
                                }
                                color = this.lrle_dec.colors[code];
                                if (this.lrle_debug) {
                                    System.out.println("PIXEL=0x" + Integer.toHexString(code) + " -> 0x" + Integer.toHexString(color));
                                }
                                run = 0;
                                copy = false;
                                break;
                            }
                            case 2: {
                                color = this.lrle_dec.greys[code & 0x3F];
                                if (this.lrle_debug) {
                                    System.out.println("GREY=0x" + Integer.toHexString(code) + " -> 0x" + Integer.toHexString(color));
                                }
                                run = 0;
                                copy = false;
                                break;
                            }
                            case 3: {
                                run = code & 0x1F;
                                if (!this.lrle_debug) break;
                                System.out.println("RUN " + (run + 1));
                                break;
                            }
                        }
                    }
                    int j = 0;
                    while (true) {
                        if (j > run) continue block7;
                        if (!copy) {
                            prevLine[dx] = color;
                        }
                        this.simgmem[tile_offset + (cy + dy) * this.mysize.width + cx + dx] = prevLine[dx];
                        if (cx + ++dx == tw) {
                            dx = 0;
                            ++dy;
                        }
                        ++j;
                    }
                    break;
                }
            }
        }
        this.simgsrc.newPixels(x, y, w, h);
        gvimg.setClip(x, y, w, h);
        gvimg.drawImage(this.simg, 0, 0, null);
        gvimg.setClip(0, 0, this.mysize.width, this.mysize.height);
        this.finishBufferedReading(this.rfb.is_rect);
    }

    private class LRLEColorDecoder {
        public int subenc;
        public int[] colors;
        public int[] greys;
        public LRLEColorDecoderConf conf;
        private LRLEColorDecoderConf[] configs;

        public LRLEColorDecoder(int new_subenc) {
            this.configs = new LRLEColorDecoderConf[]{new LRLEColorDecoderConf(false, false, false, 15, 6), new LRLEColorDecoderConf(false, false, false, 15, 6), new LRLEColorDecoderConf(false, false, false, 7, 4), new LRLEColorDecoderConf(false, false, false, 7, 4), new LRLEColorDecoderConf(false, true, false, 4, 4), new LRLEColorDecoderConf(false, true, false, 4, 4), new LRLEColorDecoderConf(false, true, true, 4, 4), new LRLEColorDecoderConf(false, true, true, 4, 4), new LRLEColorDecoderConf(false, true, true, 3, 3), new LRLEColorDecoderConf(false, true, true, 3, 3), new LRLEColorDecoderConf(true, false, true, 2, 2), new LRLEColorDecoderConf(true, false, true, 2, 2), new LRLEColorDecoderConf(true, false, true, 1, 1), new LRLEColorDecoderConf(true, false, true, 1, 1)};
            this.subenc = new_subenc;
            this.createLRLEData();
            this.createLRLEColorTables();
        }

        private void createLRLEData() {
            if (this.subenc < this.configs.length) {
                this.conf = this.configs[this.subenc];
            } else {
                System.out.println("ERROR: unsupported color decoder type");
            }
        }

        private void createLRLEColorTables() {
            int i;
            this.greys = new int[1 << this.conf.grey_depth];
            if (this.conf.is_grey) {
                this.colors = new int[1 << this.conf.grey_depth];
            }
            for (i = 0; i < 1 << this.conf.grey_depth; ++i) {
                this.greys[i] = -16777216;
                switch (this.conf.grey_depth) {
                    case 1: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 255 << 16 | i * 255 << 8 | i * 255);
                        break;
                    }
                    case 2: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 85 << 16 | i * 85 << 8 | i * 85);
                        break;
                    }
                    case 3: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 73 / 2 << 16 | i * 73 / 2 << 8 | i * 73 / 2);
                        break;
                    }
                    case 4: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 17 << 16 | i * 17 << 8 | i * 17);
                        break;
                    }
                    case 5: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 33 / 4 << 16 | i * 33 / 4 << 8 | i * 33 / 4);
                        break;
                    }
                    case 6: {
                        int n = i;
                        this.greys[n] = this.greys[n] | (i * 64 / 16 << 16 | i * 65 / 16 << 8 | i * 65 / 16);
                        break;
                    }
                    default: {
                        int n = i;
                        this.greys[n] = this.greys[n] | 0xFF00FF;
                    }
                }
                if (!this.conf.is_grey) continue;
                this.colors[i] = this.greys[i];
            }
            if (this.conf.is_grey) {
                return;
            }
            this.colors = new int[1 << this.conf.depth];
            switch (this.conf.depth) {
                case 4: {
                    this.colors[0] = -16777216;
                    this.colors[1] = -8454144;
                    this.colors[2] = -16744704;
                    this.colors[3] = -8421632;
                    this.colors[4] = -16777089;
                    this.colors[5] = -8454017;
                    this.colors[6] = -16744577;
                    this.colors[7] = -8421505;
                    this.colors[8] = -4144960;
                    this.colors[9] = -65536;
                    this.colors[10] = -16711936;
                    this.colors[11] = -256;
                    this.colors[12] = -16776961;
                    this.colors[13] = -65281;
                    this.colors[14] = -16711681;
                    this.colors[15] = -1;
                    break;
                }
                case 7: {
                    int[] c7Table = new int[]{0, 64, 128, 192, 255};
                    for (i = 0; i < 125; ++i) {
                        this.colors[i] = 0xFF000000 | c7Table[i / 25] << 16 | c7Table[i / 5 % 5] << 8 | c7Table[i % 5];
                    }
                    for (i = 125; i < 128; ++i) {
                        this.colors[i] = -65536;
                    }
                    break;
                }
                case 15: {
                    for (i = 0; i < 1 << this.conf.depth; ++i) {
                        this.colors[i] = 0xFF000000 | ((i & 0x7C00) >> 10) * 33 / 4 << 16 | ((i & 0x3E0) >> 5) * 33 / 4 << 8 | (i & 0x1F) * 33 / 4;
                    }
                    break;
                }
            }
        }
    }

    private class LRLEColorDecoderConf {
        public boolean is_compact;
        public boolean is_grey;
        public boolean is_map;
        public int depth;
        public int grey_depth;

        public LRLEColorDecoderConf(boolean is_map, boolean is_compact, boolean is_grey, int depth, int grey_depth) {
            this.is_map = is_map;
            this.is_compact = is_compact;
            this.is_grey = is_grey;
            this.depth = depth;
            this.grey_depth = grey_depth;
        }

        public String toString() {
            return new String("Compact=" + this.is_compact + ",Grey=" + this.is_grey + ",Depth=" + this.depth + ",GreyDepth=" + this.grey_depth);
        }
    }
}

