/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nn.pp.rc.ChatFrame;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.RCCanvasPanel;
import nn.pp.rc.RCHandler;
import nn.pp.rc.RFBHandler;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.RFBRenderer;
import nn.pp.rc.RFBproto;
import nn.pp.rc.RFBproto_01_16;
import nn.pp.rc.SasEvent;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.SpEvent;
import nn.pp.rc.StopWatch;
import nn.pp.rc.T;
import nn.pp.rc.TrafficMonitor;
import nn.pp.rc.VideoSettingsFrame;

public class RFBHandler_01_16
extends RFBHandler {
    Dimension mysize;
    RFBproto_01_16 rfbProto;
    static final int REPAINT_TIMEOUT = 300;
    private int no = 0;
    static boolean sasDebug = true;

    public RFBHandler_01_16(RCHandler parent, RFBProfile profile) {
        super(parent, profile);
        this.loadClasses();
    }

    public RFBHandler_01_16(ServerConsolePanelBase scp, RCCanvasPanel canvas, ChatFrame chat, TrafficMonitor tmoni, VideoSettingsFrame vsframe, MouseHandler mhandler1, MouseHandler mhandler2, PrintStream logger, RFBProfile profile) {
        super(scp, canvas, chat, tmoni, vsframe, mhandler1, mhandler2, logger, profile);
        tmoni.enableFPS(true);
        this.loadClasses();
    }

    public RFBHandler_01_16() {
    }

    public void init(ServerConsolePanelBase scp, RCCanvasPanel canvas, ChatFrame chat, TrafficMonitor tmoni, VideoSettingsFrame vsframe, MouseHandler mhandler1, MouseHandler mhandler2, PrintStream logger, RFBProfile profile) {
        this.setClasses(scp, canvas, chat, tmoni, vsframe, mhandler1, mhandler2, logger, profile);
        tmoni.enableFPS(true);
        this.loadClasses();
    }

    private void loadClasses() {
        this.rdr = this.loadRFBRenderer(this.canvas, this.profile.encoding.needsTrueColor());
        this.rfbProto = new RFBproto_01_16(this.profile, this.logger, this);
        ((RFBHandler)this).rfbProto = this.rfbProto;
        this.proto = this.rfbProto;
        this.repaint_timer = new GenericTimer(300, this);
    }

    protected void showQuitMsg(int q) {
        this.logger.println(this.mode() + ": " + T._("terminated") + ": " + RFBproto.getQuitReasonMsg(q));
    }

    private void changeSpTimes() {
        if (this.forensicPanel != null && this.rfbProto.start != null && this.rfbProto.end != null) {
            SpEvent sp = new SpEvent();
            sp.setSessionTimes(this.rfbProto.start, this.rfbProto.end);
            this.forensicPanel.handleSpEvent(sp);
            sp.played();
            this.forensicPanel.handleSpEvent(sp);
        }
    }

    protected void establishConnection() throws IOException {
        this.rfbProto.establishConnection();
        this.scp.setSoftKbdLayout(this.rfbProto.kbdlayout);
        if ((this.rfbProto.connectionFlags & 6) != 0) {
            boolean localOnly = (this.rfbProto.connectionFlags & 8) != 0;
            boolean noKbd = (this.rfbProto.connectionFlags >> 4 & 3) == 1;
            this.forensicPanel = this.scp.addForensicButton((this.rfbProto.connectionFlags & 2) != 0, localOnly, noKbd, (this.rfbProto.connectionFlags & 4) != 0);
            if (this.forensicPanel != null) {
                this.forensicPanel.setRCHandler(this);
            }
            this.changeSpTimes();
        }
    }

    protected void writeKeyboardEvent(byte keycode) throws IOException {
        this.rfbProto.writeKeyboardEvent(keycode);
    }

    protected void writeKvmSwitchEvent(short newport) throws IOException {
        this.rfbProto.writeKvmSwitchEvent(newport);
    }

    private void processFbFormatUpdate(boolean force) {
        this.mysize = new Dimension(this.rfbProto.framebufferWidth, this.rfbProto.framebufferHeight);
        this.canvas.adjustSize(this.mysize, force);
    }

    protected void parseServerCommand() {
        if (this.rfbProto.serverCommand == null || this.rfbProto.serverCommandParams == null) {
            return;
        }
        String command = this.rfbProto.serverCommand.toLowerCase();
        String params = this.rfbProto.serverCommandParams;
        if (command.equals("exclusive_mode")) {
            if (params.equals("active")) {
                this.scp.setExclusiveMode(true);
            } else {
                this.scp.setExclusiveMode(false);
            }
        } else if (command.equals("rc_users")) {
            this.scp.setShareMode(Integer.parseInt(params));
        } else if (command.equals("wlan_quality")) {
            this.scp.setWLANQuality(Integer.parseInt(params));
        } else {
            System.out.println("got unknown RFB command: " + command);
        }
    }

    void sendFramebufferUpdateRequest() throws IOException {
        this.rfbProto.writeFramebufferUpdateRequest(0, 0, this.rfbProto.framebufferWidthPadded, this.rfbProto.framebufferHeightPadded, true);
    }

    void sendFullFramebufferUpdateRequest() throws IOException {
        this.rfbProto.writeFullFramebufferUpdateRequest();
    }

    protected void readScreenUpdate() throws IOException {
        StopWatch watch = new StopWatch();
        int count = 0;
        this.repaint_timer.start();
        this.rfbProto.readFramebufferUpdate();
        this.tmoni.increaseFPSCount();
        for (int i = 0; i < this.rfbProto.updateNRects; ++i) {
            this.rfbProto.readFramebufferUpdateRectHdr();
            this.rfbProto.prepareUpdateRect();
            switch (this.rfbProto.updateRectEncoding & 0xFF) {
                case 0: {
                    System.out.println("RFBproto.EncodingRaw");
                    this.rdr.drawRawRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH, this.rfbProto.bigEndian);
                    break;
                }
                case 10: {
                    System.out.println("RFBproto.EncodingRawVSC");
                    this.rdr.drawRawVSCRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH, this.rfbProto.bigEndian);
                    break;
                }
                case 5: {
                    System.out.println("RFBproto.EncodingHextile");
                    this.rdr.drawHextileRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH, this.rfbProto.bigEndian);
                    break;
                }
                case 7: {
                    System.out.println("RFBproto.EncodingTight");
                    this.rdr.drawTightRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH);
                    break;
                }
                case 9: {
                    System.out.println("RFBproto.EncodingUseTightCache");
                    this.rdr.drawTightCachedRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH);
                    break;
                }
                case 1: {
                    System.out.println("RFBproto.EncodingCopyRect");
                    this.rfbProto.readCopyRect();
                    this.rdr.drawCopyRect(this.rfbProto.copyRectSrcX, this.rfbProto.copyRectSrcY, this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH);
                    break;
                }
                case 11: 
                case 128: {
                    int size = this.rfbProto.readHWencSize();
                    this.rdr.drawLRLERect(this.rfbProto.updateRectEncoding, this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH);
                    this.rfbProto.readHWencPadding(size);
                    break;
                }
                case 12: {
                    System.out.println("RFBproto.EncodingJpeg");
                    this.rdr.drawJpegRect(this.rfbProto.updateRectX, this.rfbProto.updateRectY, this.rfbProto.updateRectW, this.rfbProto.updateRectH);
                    break;
                }
                default: {
                    throw new IOException("Unknown RFB rectangle encoding " + this.rfbProto.updateRectEncoding);
                }
            }
            if (!this.repaint_scheduled) continue;
            this.rdr.repaint();
            this.repaint_scheduled = false;
        }
        this.repaint_timer.stop();
        this.rdr.repaint();
        if (this.fps && ++count == 10) {
            long t = watch.stop();
            if (t == 0L) {
                t = 1L;
            }
            this.logger.println(" fps=" + 1000.0 * (double)count / (double)t + " t=" + t / (long)count + "ms" + " c=" + count);
            watch.start();
            count = 0;
        }
    }

    protected void handleAckPixelFormat() throws IOException {
        this.rfbProto.readAckPixelFormat();
        Dimension d = this.rdr.mysize;
        RFBRenderer newRdr = this.rfbProto.ack_bitsPerPixel == 16 ? this.rdr16 : this.rdr8;
        if (this.rdr != newRdr) {
            System.out.println("Switching to new RFB Renderer: " + newRdr);
            this.rdr = newRdr;
            this.canvas.setRCRenderer(this.rdr);
            this.rdr.setRenderSize(d);
        }
        newRdr.enableTightCache(this.profile.encoding.isTightCacheUsed());
        this.rfbProto.writeFullFramebufferUpdateRequest();
    }

    protected void handleScreenUpdate() throws IOException {
        if (this.pendingFormatChange) {
            this.sendFormatAndEncodings(true);
            this.pendingFormatChange = false;
        } else {
            this.sendFramebufferUpdateRequest();
        }
        this.readScreenUpdate();
    }

    protected void readSasEvent() throws IOException {
        SasEvent evt = this.rfbProto.readSasEvent();
        if (this.forensicPanel != null) {
            this.forensicPanel.handleSasEvent(evt);
        }
    }

    protected void readSpTimestamp() throws IOException {
        Date d = this.rfbProto.readSpTimestamp();
        if (this.forensicPanel != null) {
            if (sasDebug) {
                System.out.println("Timestamp " + this.no++);
            }
            SpEvent sp = new SpEvent();
            sp.setReplayTime(d);
            this.forensicPanel.handleSpEvent(sp);
        }
    }

    public void sendFormatAndEncodings(boolean framebufferUpdateRequest) throws IOException {
        RFBRenderer newRdr;
        int[] encodings = this.profile.encoding.getRFBEncodings(true);
        this.rfbProto.writeSetEncodings(encodings, encodings.length);
        if (this.profile.encoding.needsTrueColor()) {
            if (this.rdr16 == null) {
                this.rdr16 = this.loadRFBRenderer(this.canvas, true);
                this.rdr16.setRFBProto(this.rfbProto);
            }
            newRdr = this.rdr16;
        } else {
            if (this.rdr8 == null) {
                this.rdr8 = this.loadRFBRenderer(this.canvas, false);
                this.rdr8.setRFBProto(this.rfbProto);
            }
            newRdr = this.rdr8;
        }
        newRdr.sendPixelMsg();
        if (framebufferUpdateRequest) {
            this.rfbProto.writeFullFramebufferUpdateRequest();
        }
    }

    void readSpCommand() throws IOException {
        this.rfbProto.readSpCommand();
        switch (this.rfbProto.spCommand) {
            case 0: 
            case 1: 
            case 2: {
                if (this.forensicPanel == null) break;
                this.forensicPanel.handleSpEvent(new SpEvent(this.rfbProto.spCommand));
            }
        }
    }

    protected int processProtocol() throws IOException {
        int msgType;
        this.sendFormatAndEncodings(false);
        this.logger.println(T._("Console: rendering") + " " + this.rdr);
        this.processFbFormatUpdate(true);
        this.rdr.sendUpdateMsg();
        this.rdr.setOSDState(this.rfbProto.osdStateBlanking, this.rfbProto.osdStateMessage, this.rfbProto.osdStateTimeout);
        block24: while (true) {
            msgType = this.rfbProto.readServerMessageType();
            switch (msgType) {
                case 3: {
                    return this.rfbProto.readQuitReason();
                }
                case 7: {
                    if (this.chat == null) continue block24;
                    this.chat.newMsg(this.rfbProto.readString());
                    continue block24;
                }
                case 128: {
                    int framebufferWidthOld = this.rfbProto.framebufferWidth;
                    int framebufferHeightOld = this.rfbProto.framebufferHeight;
                    this.rfbProto.readServerInit();
                    this.processFbFormatUpdate(false);
                    if (!this.profile.encoding.isTightCacheUsed() || framebufferWidthOld == this.rfbProto.framebufferWidth && framebufferHeightOld == this.rfbProto.framebufferHeight) continue block24;
                    this.rdr.setNewTightCacheSize();
                    continue block24;
                }
                case 0: {
                    this.handleScreenUpdate();
                    continue block24;
                }
                case 19: {
                    this.handleAckPixelFormat();
                    continue block24;
                }
                case 2: {
                    Toolkit.getDefaultToolkit().beep();
                    continue block24;
                }
                case 131: {
                    this.rfbProto.readConsoleMessage();
                    this.logger.println(this.rfbProto.message);
                    continue block24;
                }
                case 132: {
                    this.rfbProto.readServerCommand();
                    this.parseServerCommand();
                    continue block24;
                }
                case 16: {
                    this.rfbProto.readOsdStateMessage();
                    this.rdr.setOSDState(this.rfbProto.osdStateBlanking, this.rfbProto.osdStateMessage, this.rfbProto.osdStateTimeout);
                    continue block24;
                }
                case 9: {
                    this.rfbProto.readKbdLayout();
                    this.scp.setSoftKbdLayout(this.rfbProto.kbdlayout);
                    continue block24;
                }
                case 148: {
                    this.rfbProto.readPing();
                    try {
                        this.rfbProto.writePingReply(0);
                    }
                    catch (Exception ignore) {
                        this.logger.println(T._("Can't write pingresponse:") + " " + ignore);
                    }
                    continue block24;
                }
                case 150: {
                    this.rfbProto.writeBandwidthTick((byte)1);
                    this.rfbProto.readBandwidthRequest();
                    this.rfbProto.writeBandwidthTick((byte)2);
                    System.out.println("Bandwidth measurement done.");
                    continue block24;
                }
                case 8: {
                    this.rfbProto.readVideoSettingsUpdate();
                    this.vsframe.updateVideoSettings(this.rfbProto.vs);
                    continue block24;
                }
                case 17: {
                    this.rfbProto.readVideoQualityUpdate();
                    continue block24;
                }
                case 161: {
                    System.out.println("RCModeReply not supported.");
                    continue block24;
                }
                case 134: {
                    this.rfbProto.readSasError();
                    continue block24;
                }
                case 133: {
                    this.readSasEvent();
                    continue block24;
                }
                case 136: {
                    this.readSpTimestamp();
                    continue block24;
                }
                case 163: {
                    this.readSpCommand();
                    continue block24;
                }
                case 164: {
                    this.rfbProto.readSpSessionTimes();
                    this.changeSpTimes();
                    continue block24;
                }
            }
            break;
        }
        throw new IOException(T._("Unknown RFB message type") + " " + msgType);
    }

    public void sendPlay() throws IOException {
        this.rfbProto.sendSpCommand(0);
    }

    public void sendPause() throws IOException {
        this.rfbProto.sendSpCommand(1);
    }

    public void sendStop() throws IOException {
        this.rfbProto.sendSpCommand(2);
    }

    public void sendSpeed(int speed) throws IOException {
        this.rfbProto.sendSpCommand(3, speed, 0);
    }

    public void sendSeek(Date pos) throws IOException {
        this.rfbProto.sendSpTimestamp(pos);
    }
}

