/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.awt.GraphicsEnvironment;
import java.io.IOException;

public class KVMPlugIn
extends CommandPlugIn {
    public void execute() throws Exception {
        if (!this.isKVMSupported()) {
            this.printSlaveCMMUnavailableMessage();
            return;
        }
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.print("No graphic environment here !");
            return;
        }
        MOut.print("Starting KVM Process...");
        try {
            Process p = Runtime.getRuntime().exec("java -jar KVMPlugIn.jar " + this.config.getIp() + " " + this.config.getUserName() + " " + this.config.getPassword());
        }
        catch (IOException ex) {
            MOut.println(" Failed");
            return;
        }
        MOut.println("Done");
        MOut.println("Please wait for KVM window");
    }

    public boolean isKVMSupported() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            return false;
        }
        if (IPMIMessagingCommand.isCMMGUID(guid)) {
            return this.isCurrentCMMMaster();
        }
        if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isSIMBL(guid)) {
            return true;
        }
        if (IPMIMessagingCommand.isOSAGUID(guid)) {
            return false;
        }
        return false;
    }

    public boolean isCurrentCMMMaster() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        for (int i = 0; i < 2; ++i) {
            CMMModuleEntity cmm = bladeSystem.getCmmModules()[i];
            if (!cmm.isConnected() || cmm.getMasterSlave() != 0) continue;
            return true;
        }
        return false;
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.println("This function is unavailable for this device or slave CMM.");
    }

    public String getAlternateValue() {
        return null;
    }

    public String getComment() {
        return "Open KVM console (graphic mode)";
    }

    public String getName() {
        return "kvm";
    }

    public String getValue() {
        return "kvm";
    }

    public boolean isSupportCLIMode() {
        return true;
    }

    public boolean isSupportShellMode() {
        return true;
    }

    public static void main(String[] args) {
    }
}

