/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import nn.pp.drvredir.ConnectionHandler;
import nn.pp.drvredir.DrvRedirIso;
import nn.pp.drvredir.DrvRedirSettingsPanel;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.T;

class ConnectionHandlerIso
extends ConnectionHandler {
    DrvRedirIso iso;
    String directory;
    String filename;

    ConnectionHandlerIso(RFBProfile prof, DrvRedirSettingsPanel panel, PrintStream logger, int msIndex) {
        super(prof, panel, new DrvRedirIso(), logger, msIndex);
        this.iso = (DrvRedirIso)this.drvAccess;
    }

    void chooseIsoFile(Frame frame) throws IOException {
        FileDialog chooser = new FileDialog(frame, T._("Choose ISO image to redirect"), 0);
        chooser.setDirectory(System.getProperty("user.home"));
        chooser.show();
        this.filename = chooser.getFile();
        this.directory = chooser.getDirectory();
        if (this.filename == null || this.directory == null) {
            throw new IOException(T._("No ISO file chosen"));
        }
        RandomAccessFile file = new RandomAccessFile(new File(this.directory, this.filename), "r");
        boolean isValid = this.iso.isFloppy(file) || this.iso.isIso(file);
        try {
            file.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        if (!isValid) {
            ConfirmDialog dlg = new ConfirmDialog("The file you selected is not a valid image file.", "Warning", 0, true);
            dlg.show();
            throw new IOException(T._("Invalid file selected"));
        }
        ConnectionHandlerIso.debug("Redirecting file " + this.filename);
    }

    void connect() throws Exception {
        this.iso.openFile(this.directory, this.filename);
        this.doConnect();
    }

    void disconnect() {
        this.doDisconnect();
        this.iso.closeFile();
    }
}

