/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.drvredir;

import java.io.PrintStream;
import nn.pp.drvredir.DriveAccess;
import nn.pp.drvredir.DrvRedirSettingsPanel;
import nn.pp.drvredir.MSPProto;
import nn.pp.rc.RFBProfile;

abstract class ConnectionHandler
extends Thread {
    RFBProfile prof;
    DrvRedirSettingsPanel panel;
    DriveAccess drvAccess;
    MSPProto proto;
    PrintStream logger;
    boolean writeSupport = false;
    boolean running;
    boolean killThread = false;

    ConnectionHandler(RFBProfile prof, DrvRedirSettingsPanel panel, DriveAccess drvAccess, PrintStream logger, int msIndex) {
        this.prof = prof;
        this.panel = panel;
        this.drvAccess = drvAccess;
        this.logger = logger;
        this.writeSupport = this.writeSupport;
        this.proto = new MSPProto(prof, logger, drvAccess, msIndex);
    }

    static void debug(String s) {
    }

    abstract void connect() throws Exception;

    abstract void disconnect();

    protected void doConnect() throws Exception {
        this.proto.initializeMSPConnection(this.writeSupport);
        this.startProcessingThread();
    }

    protected void doDisconnect() {
        this.stopProcessingThread();
        try {
            this.proto.closeConnection(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void startProcessingThread() {
        ConnectionHandler.debug("Starting message processing thread.");
        this.killThread = false;
        this.start();
    }

    void stopProcessingThread() {
        ConnectionHandler.debug("Stopping message processing thread.");
        this.killThread = true;
        this.proto.closeConnection(true);
        if (this.running) {
            try {
                this.join(1000L);
                if (this.isAlive()) {
                    this.stop();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ConnectionHandler.debug("message processing thread finished.");
        }
        this.running = false;
    }

    public void run() {
        this.running = true;
        ConnectionHandler.debug("message processing thread started.");
        try {
            this.proto.processProtocol();
        }
        catch (Exception e) {
            this.logger.println(e.getMessage());
            this.running = false;
            this.panel.disconnected(!this.killThread);
        }
        ConnectionHandler.debug("message processing thread finishing.");
    }
}

