/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.softkeyboard;

import com.ami.kvm.jviewer.hid.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.USBKeyboardRep;
import com.supermicro.softkeyboard.IKeyboardLayout;
import com.supermicro.softkeyboard.Key;
import com.supermicro.softkeyboard.KeyButton;
import com.supermicro.softkeyboard.KeyChar;
import com.supermicro.softkeyboard.KeyboardLanguage;
import com.supermicro.softkeyboard.KeyboardLanguage_EN;
import com.supermicro.softkeyboard.KeyboardLayout_109;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;

public class SoftKeyboard
extends JPanel
implements MouseListener {
    KVMClient kvmClient;
    IKeyboardLayout keyboardLayout;
    KeyboardLanguage keyboardLanguage;
    KeyButton[] keyButtons;
    int keyWidth = 22;
    int keyHeight = 22;
    boolean combineKeyMode = false;
    boolean combineKeyLock = false;
    boolean isNumLock = false;
    boolean isCapsLock = false;
    boolean isScrollLock = false;
    boolean isLShift = false;
    boolean isLCtrl = false;
    boolean isLAlt = false;
    boolean isLWin = false;
    boolean isRShift = false;
    boolean isRCtrl = false;
    boolean isRAlt = false;
    boolean isRWin = false;
    Timer timer = null;
    MouseEvent tempMouseEvent;

    public SoftKeyboard() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(null);
    }

    private void myInit() throws Exception {
        this.keyboardLayout = new KeyboardLayout_109();
        this.keyboardLanguage = new KeyboardLanguage_EN();
        this.layoutKeyboard(this.keyboardLayout.getKeyboardLayout());
        int maxWidth = this.keyWidth * this.keyboardLayout.sizeOfWidth();
        int maxHeight = this.keyHeight * this.keyboardLayout.sizeOfHeight();
        this.setPreferredSize(new Dimension(maxWidth, maxHeight));
    }

    public void changeKeyboardLanguage(KeyboardLanguage keyboardLanguage) {
        this.keyboardLanguage = keyboardLanguage;
        this.cleanToggleStatus();
        this.layoutKeyboard(this.keyboardLayout.getKeyboardLayout());
        this.repaint();
    }

    public void layoutKeyboard(Key[] keys) {
        HashMap hmKeyChar = this.keyboardLanguage.getKeyboardCharHT();
        this.removeAll();
        this.keyButtons = new KeyButton[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            KeyChar keyChar = (KeyChar)hmKeyChar.get(keys[i].getKeyNumber());
            this.keyButtons[i] = new KeyButton(keys[i], keyChar);
            this.keyButtons[i].setBounds((int)((double)this.keyWidth * keys[i].getXLoc()), (int)((double)this.keyHeight * keys[i].getYLoc()), (int)((double)this.keyWidth * keys[i].getWidthRatio()), (int)((double)this.keyHeight * keys[i].getHeightRatio()));
            this.keyButtons[i].addMouseListener(this);
            this.add(this.keyButtons[i]);
        }
        this.setCombineKeyMode(true);
    }

    public void setKeyDisplayStatus(int status) {
        for (int i = 0; i < this.keyButtons.length; ++i) {
            this.keyButtons[i].setKeyDisplayStatus(status);
        }
    }

    public void setNumlock(boolean isNumlock) {
        for (int i = 0; i < this.keyButtons.length; ++i) {
            this.keyButtons[i].setIsNumlock(isNumlock);
        }
    }

    public void showKeyboardChar(KeyChar[] keyChars) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void mousePressed(MouseEvent e) {
        KeyButton keyButton;
        if (this.combineKeyMode) {
            this.updateModifierStatus(e);
            this.updateShiftKeyCharDisplay();
            if (this.isModifierKey((KeyButton)e.getSource())) {
                return;
            }
        }
        this.sendKey(e);
        if (!this.combineKeyLock && (keyButton = (KeyButton)e.getSource()).getKeyType() != 1) {
            this.cleanToggleStatus();
            this.updateShiftKeyCharDisplay();
        }
        this.tempMouseEvent = e;
        TimerTask tt = new TimerTask(){

            public void run() {
                SoftKeyboard.this.sendKey(SoftKeyboard.this.tempMouseEvent);
            }
        };
        this.timer = new Timer();
        this.timer.schedule(tt, 500L, 100L);
    }

    public boolean isCombineKeyMode() {
        return this.combineKeyMode;
    }

    public boolean isCombineKeyLock() {
        return this.combineKeyLock;
    }

    public KVMClient getKvmClient() {
        return this.kvmClient;
    }

    public void cleanToggleStatus() {
        for (int i = 0; i < this.keyButtons.length; ++i) {
            if (!this.isModifierKey(this.keyButtons[i])) continue;
            this.keyButtons[i].clearToggleStatus();
        }
        this.isLShift = false;
        this.isLAlt = false;
        this.isLCtrl = false;
        this.isLWin = false;
        this.isRShift = false;
        this.isRAlt = false;
        this.isRCtrl = false;
        this.isRWin = false;
    }

    public void setCombineKeyMode(boolean combineKeyMode) {
        this.combineKeyMode = combineKeyMode;
        for (int i = 0; i < this.keyButtons.length; ++i) {
            if (this.isModifierKey(this.keyButtons[i])) {
                if (combineKeyMode) {
                    this.keyButtons[i].setKeyType(1);
                    continue;
                }
                this.keyButtons[i].setKeyType(0);
                continue;
            }
            this.keyButtons[i].setKeyType(0);
        }
    }

    public void setCombineKeyLock(boolean combineKeyLock) {
        this.combineKeyLock = combineKeyLock;
    }

    public void setKvmClient(KVMClient kvmClient) {
        this.kvmClient = kvmClient;
    }

    private boolean isModifierKey(KeyButton keyButton) {
        return keyButton.getKey().getKeyNumber() == 44 || keyButton.getKey().getKeyNumber() == 58 || keyButton.getKey().getKeyNumber() == 60 || keyButton.getKey().getKeyNumber() == 127 || keyButton.getKey().getKeyNumber() == 57 || keyButton.getKey().getKeyNumber() == 64 || keyButton.getKey().getKeyNumber() == 62 || keyButton.getKey().getKeyNumber() == 128;
    }

    private void updateModifierStatus(MouseEvent e) {
        KeyButton keyButton = (KeyButton)e.getSource();
        switch (keyButton.getKey().getKeyNumber()) {
            case 44: {
                this.isLShift = keyButton.keyToggleStatus;
                break;
            }
            case 58: {
                this.isLCtrl = keyButton.keyToggleStatus;
                break;
            }
            case 60: {
                this.isLAlt = keyButton.keyToggleStatus;
                break;
            }
            case 127: {
                this.isLWin = keyButton.keyToggleStatus;
                break;
            }
            case 57: {
                this.isRShift = keyButton.keyToggleStatus;
                break;
            }
            case 64: {
                this.isRCtrl = keyButton.keyToggleStatus;
                break;
            }
            case 62: {
                this.isRAlt = keyButton.keyToggleStatus;
                break;
            }
            case 128: {
                this.isRWin = keyButton.keyToggleStatus;
                break;
            }
            case 90: {
                this.isNumLock = keyButton.keyToggleStatus;
            }
        }
    }

    private void updateShiftKeyCharDisplay() {
        if (this.isLShift || this.isRShift) {
            this.setKeyDisplayStatus(1);
        } else {
            this.setKeyDisplayStatus(0);
        }
    }

    private void updateNumLockCharDisplay() {
        this.setNumlock(this.isNumLock);
    }

    public void sendKey(MouseEvent e) {
        KeyButton keyButton = (KeyButton)e.getSource();
        USBKeyboardRep keyRep = new USBKeyboardRep();
        if (this.isLCtrl) {
            keyRep.set(17, 2, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLShift) {
            keyRep.set(16, 2, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLAlt) {
            keyRep.set(18, 2, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLWin) {
            keyRep.set(524, 2, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRCtrl) {
            keyRep.set(17, 3, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRShift) {
            keyRep.set(16, 3, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRAlt) {
            keyRep.set(18, 3, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRWin) {
            keyRep.set(524, 3, true);
            this.kvmClient.sendKMMessage(keyRep);
        }
        int key = keyButton.getKey().getJavaVirtualKey();
        keyRep.set(key, keyButton.getKey().getKeyLocation(), true);
        this.kvmClient.sendKMMessage(keyRep);
        keyRep.set(key, keyButton.getKey().getKeyLocation(), false);
        this.kvmClient.sendKMMessage(keyRep);
        if (this.isLWin) {
            keyRep.set(524, 2, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLAlt) {
            keyRep.set(18, 2, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLShift) {
            keyRep.set(16, 2, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isLCtrl) {
            keyRep.set(17, 2, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRWin) {
            keyRep.set(524, 3, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRAlt) {
            keyRep.set(18, 3, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRShift) {
            keyRep.set(16, 3, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
        if (this.isRCtrl) {
            keyRep.set(17, 3, false);
            this.kvmClient.sendKMMessage(keyRep);
        }
    }

    public void softKeyboardKeyPressed(KeyEvent e) {
        for (int i = 0; i < this.keyButtons.length; ++i) {
            if (this.keyButtons[i].getKey().getJavaVirtualKey() != e.getKeyCode()) continue;
            this.keyButtons[i].setMousePressedVisible(true);
        }
    }

    public void softKeyboardKeyReleased(KeyEvent e) {
        for (int i = 0; i < this.keyButtons.length; ++i) {
            if (this.keyButtons[i].getKey().getJavaVirtualKey() != e.getKeyCode()) continue;
            this.keyButtons[i].setMousePressedVisible(false);
        }
    }
}

