/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.softkeyboard;

import com.supermicro.softkeyboard.Key;
import com.supermicro.softkeyboard.KeyChar;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class KeyButton
extends JLabel {
    public static final int KEY_DISPLAY_STATUS_NORMAL = 0;
    public static final int KEY_DISPLAY_STATUS_MODIFIER = 1;
    public static final int KEY_TYPE_NORMAL = 0;
    public static final int KEY_TYPE_TOGGLE = 1;
    Key key;
    KeyChar keyChar;
    int keyDisplayStatus;
    int keyType = 0;
    boolean keyToggleStatus = false;
    boolean isNumlock = false;
    boolean borderVisible = true;
    Color keyLeftUpColor = Color.WHITE;
    Color keyRightDownColor = Color.DARK_GRAY;
    boolean mouseInVisible = false;
    Color mouseInColor = Color.GRAY;
    boolean mousePressedVisible = false;
    boolean lockVisible = false;
    Color lockColor = Color.YELLOW;

    public KeyButton(Key key, KeyChar keyChar) {
        this.key = key;
        this.keyChar = keyChar;
        this.initial();
    }

    public void initial() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                KeyButton.this.setCursor(new Cursor(12));
                KeyButton.this.setMouseInVisible(true);
            }

            public void mouseExited(MouseEvent e) {
                KeyButton.this.setCursor(new Cursor(0));
                KeyButton.this.setMouseInVisible(false);
            }

            public void mousePressed(MouseEvent e) {
                KeyButton.this.setMouseClickVisible(true);
                if (KeyButton.this.keyType == 1) {
                    KeyButton.this.keyToggleStatus = !KeyButton.this.keyToggleStatus;
                    KeyButton.this.setLockVisible(KeyButton.this.keyToggleStatus);
                }
            }

            public void mouseReleased(MouseEvent e) {
                KeyButton.this.setMouseClickVisible(false);
            }
        });
    }

    public void paintComponent(Graphics g) {
        this.darwBackground(g);
        if (this.borderVisible) {
            this.drawBorder(g);
        }
        if (this.mouseInVisible) {
            this.drawMouseIn(g);
        }
        if (this.mousePressedVisible) {
            this.drawMousePressed(g);
        }
        if (this.lockVisible) {
            this.drawLocked(g);
        }
        if (this.keyChar.isShow()) {
            this.showKeyChar(g);
        }
    }

    private void drawLocked(Graphics g) {
        Color backupColor = g.getColor();
        g.setColor(this.lockColor);
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        g.setColor(backupColor);
    }

    private void drawMousePressed(Graphics g) {
        Color backupColor = g.getColor();
        g.setColor(this.keyRightDownColor);
        g.drawLine(0, 0, this.getWidth() - 1, 0);
        g.drawLine(0, 0, 0, this.getHeight() - 1);
        g.setColor(this.keyLeftUpColor);
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(backupColor);
    }

    private void darwBackground(Graphics g) {
        this.setOpaque(false);
        Graphics2D g2d = (Graphics2D)g;
        GradientPaint lightBlueGradient = new GradientPaint(1.0f, 1.0f, new Color(215, 235, 255), this.getWidth(), this.getHeight(), new Color(140, 198, 255));
        GradientPaint blueGradient2 = new GradientPaint(1.0f, 1.0f, new Color(170, 199, 246), this.getWidth(), this.getHeight(), new Color(91, 147, 238));
        GradientPaint blackGradient = new GradientPaint(1.0f, 1.0f, new Color(238, 238, 238), this.getWidth(), this.getHeight(), new Color(175, 175, 175));
        g2d.setPaint(lightBlueGradient);
        g2d.fillRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
        g2d.setPaint(null);
    }

    private void drawMouseIn(Graphics g) {
        Color backupColor = g.getColor();
        g.setColor(this.mouseInColor);
        g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
        g.setColor(backupColor);
    }

    private void drawBorder(Graphics g) {
        Color backupColor = g.getColor();
        g.setColor(this.keyLeftUpColor);
        g.drawLine(0, 0, this.getWidth() - 1, 0);
        g.drawLine(0, 0, 0, this.getHeight() - 1);
        g.setColor(this.keyRightDownColor);
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, this.getHeight() - 1);
        g.drawLine(0, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
        g.setColor(backupColor);
    }

    private void showKeyChar(Graphics g) {
        String s = "";
        switch (this.keyDisplayStatus) {
            case 0: {
                s = this.keyChar.getKeyNormalChar();
                break;
            }
            case 1: {
                s = this.keyChar.getKeyModifierChar() != null ? this.keyChar.getKeyModifierChar() : this.keyChar.getKeyNormalChar();
            }
        }
        g.drawString(s, 2, this.getHeight() - 5);
        if (this.keyChar.getKeyNumLockChar() != null) {
            String numChar = this.keyChar.getKeyNumLockChar();
            Graphics2D g2d = (Graphics2D)g;
            Color backup = g2d.getColor();
            g2d.setColor(Color.white);
            g2d.setComposite(AlphaComposite.getInstance(3, 0.8f));
            g2d.drawString(numChar, this.getWidth() / 2 - 3, this.getHeight() - 11);
            g2d.setColor(backup);
        }
    }

    public void clearToggleStatus() {
        this.keyToggleStatus = false;
        this.setLockVisible(this.keyToggleStatus);
        this.repaint();
    }

    public void setBorderVisible(boolean borderVisible) {
        this.borderVisible = borderVisible;
        this.repaint();
    }

    public void setMouseInVisible(boolean mouseInVisible) {
        this.mouseInVisible = mouseInVisible;
        this.repaint();
    }

    public void setMouseClickVisible(boolean mouseClickVisible) {
        this.mousePressedVisible = mouseClickVisible;
        this.repaint();
    }

    public void setKeyDisplayStatus(int keyDisplayStatus) {
        this.keyDisplayStatus = keyDisplayStatus;
        this.repaint();
    }

    public void setKeyChar(KeyChar keyChar) {
        this.keyChar = keyChar;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public void setIsNumlock(boolean isNumlock) {
        this.isNumlock = isNumlock;
        this.repaint();
    }

    public void setLockVisible(boolean lockVisible) {
        this.lockVisible = lockVisible;
        this.repaint();
    }

    public void setMousePressedVisible(boolean mousePressedVisible) {
        this.mousePressedVisible = mousePressedVisible;
        this.repaint();
    }

    public void setKeyType(int keyType) {
        this.keyType = keyType;
    }

    public boolean isBorderVisible() {
        return this.borderVisible;
    }

    public boolean isMouseInVisible() {
        return this.mouseInVisible;
    }

    public boolean isMouseClickVisible() {
        return this.mousePressedVisible;
    }

    public int getKeyDisplayStatus() {
        return this.keyDisplayStatus;
    }

    public KeyChar getKeyChar() {
        return this.keyChar;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isIsNumlock() {
        return this.isNumlock;
    }

    public boolean isLockVisible() {
        return this.lockVisible;
    }

    public boolean isMousePressedVisible() {
        return this.mousePressedVisible;
    }

    public int getKeyType() {
        return this.keyType;
    }
}

