/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class VMFloppyCommand
extends SuperBladeCommand {
    String filename = "";
    byte driveID;

    public boolean preValidate() {
        String usage = "Usage: vm floppy <drive ID> floppy_filename\ndrive ID = <1|2>\nPlease make sure the drive is empty";
        if (this.parameters == null || this.parameters.length != 2) {
            MOut.println(usage);
            return false;
        }
        try {
            this.driveID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            MOut.println("drive ID should be number");
            MOut.println(usage);
            return false;
        }
        if (this.driveID < 1 || this.driveID > 2) {
            MOut.println("Invalid drive number");
            MOut.println(usage);
            return false;
        }
        this.filename = this.parameters[1];
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isVirutalMediaSupported()) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (ipmiOEMCommand.checkNoVMAndWeb()) {
            MOut.println("This device doesn't support virtual media");
            this.statusCode = 153;
            return;
        }
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b = ipmiRaritanOEMCommand.uploadFloppyImageForTextMode(this.driveID, this.filename);
        if (b) {
            MOut.println("Done");
            this.statusCode = 0;
        } else {
            MOut.println("Failed");
            this.statusCode = 149;
        }
    }
}

