/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperBladeTool {
    public static String version = "1.5.3";
    public static String buildNo = "090420";
    public static final boolean DEBUG = false;

    public static void main(String[] args) {
        if (args.length < 3) {
            SuperBladeTool.usage();
            System.exit(182);
        }
        Parser parser = new Parser();
        String ip = args[0];
        String username = args[1];
        String password = args[2];
        if (!SuperBladeTool.validateIP(ip)) {
            MOut.println("IP format erorr !");
            System.exit(181);
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        String[] subArgs = new String[args.length - 3];
        System.arraycopy(args, 3, subArgs, 0, subArgs.length);
        Command command = parser.parse(parser.argumentRoot, subArgs);
        if (command == null) {
            System.exit(180);
        }
        command.setConfig(config);
        command.setOriginalParser(parser);
        try {
            command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(command.getStatusCode());
    }

    public static void usage() {
        MOut.println("");
        MOut.println("SMC IPMI Tool V" + version + "(Build " + buildNo + ") - Super Micro Computer, Inc.");
        MOut.println("Usage:");
        MOut.println("      SMCIPMITool <IP> <username> <password> [commands ... ]");
    }

    public static void ver() {
        MOut.println("SMC IPMI Tool V" + version + "(Build " + buildNo + ") - Super Micro Computer, Inc.");
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }
}

