/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;

public abstract class SuperBladeCommand
extends Command {
    IPMICMMOEMCommand ipmiCMMOEMCommand = null;
    ISessionController sessionController = null;
    boolean isMaster = false;
    String masterIP;

    public void execute() throws Exception {
        boolean b = this.preValidate();
        if (!b) {
            this.statusCode = 147;
            return;
        }
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerEx(this.config, this.ipmiCMMOEMCommand);
        }
        catch (IPMIException ex) {
            MOut.println(ex.getMessage());
            String message = ex.getMessage();
            if (message.indexOf("connect") != -1) {
                this.statusCode = 145;
            } else if (message.indexOf("login") != -1) {
                this.statusCode = 146;
            }
            return;
        }
        this.isMaster = this.isCurrentCMMMaster();
        try {
            this.runCommand();
        }
        catch (Exception e) {
            MOut.println("Exception:");
            e.printStackTrace();
            this.statusCode = 148;
            return;
        }
        b = this.sessionController.closeSession();
    }

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;

    public boolean isBladePresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getBlades()[--index].getPresent() != 0;
    }

    public boolean isCMMPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getCmmModules()[--index].getPresent() != 0;
    }

    public boolean isPowerSupplyPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getPowerSupplies()[--index].getPresent() != 0;
    }

    public boolean isGigabitPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getGigabitSwitchs()[--index].getPresent() != 0;
    }

    public boolean isIBPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getInfiniBands()[--index].getPresent() != 0;
    }

    public BladeSystemEntity getBladeSystemEntity() {
        if (this.ipmiCMMOEMCommand == null) {
            return null;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        if (bladeSystem.isLoginSuccessful) {
            return bladeSystem;
        }
        return null;
    }

    public boolean isConnectToCMM(int cmmIndex) {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        CMMModuleEntity cmm = bladeSystem.getCmmModules()[cmmIndex];
        return cmm.isConnected();
    }

    public boolean isCurrentCMMMaster() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        for (int i = 0; i < 2; ++i) {
            CMMModuleEntity cmm = bladeSystem.getCmmModules()[i];
            if (!cmm.isConnected() || cmm.getMasterSlave() != 0) continue;
            return true;
        }
        try {
            this.masterIP = this.ipmiCMMOEMCommand.getCMMOtherIP();
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        return false;
    }

    public boolean isVirutalMediaSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
            result = this.isMaster;
        } else if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isSIMBL(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isOSAGUID(guid)) {
            result = false;
        }
        return result;
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.println("This function is unavailable for this device or slave CMM.");
        if (this.masterIP != null) {
            MOut.println("Please connect to Master CMM(IP : " + this.masterIP + ")");
        }
    }

    public int getBladeMaxSize() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            byte bladeSize = guid[8];
            byte cmmModuleSize = guid[9];
            byte powerSupplySize = guid[10];
            byte infiniBandSize = guid[11];
            byte gigabitSwitchSize = guid[12];
            return bladeSize;
        }
        return 0;
    }
}

