/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.SuperBladeCommand;
import com.supermicro.ipmi.trap.Receiver;
import com.supermicro.ipmi.trap.Trap;
import com.supermicro.ipmi.trap.TrapReceiverListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;

public class ShellCommand
extends SuperBladeCommand
implements TrapReceiverListener {
    Calendar startTime;
    Parser parser;
    ArrayList commandHistory = new ArrayList();
    int commandHistoryIndex = 0;

    public ShellCommand() {
        this.startTime = Calendar.getInstance();
    }

    public void runCommand() {
    }

    public void startTrapReceiver() {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isTrap = ca.getProperty("trap");
        Receiver.getInstance().addTrapReceiverListener(this);
        if ("on".equalsIgnoreCase(isTrap)) {
            boolean result = Receiver.getInstance().startReceiver();
            if (result) {
                MOut.println("Trap Receiver Started");
            } else {
                MOut.println("Start Trap Receiver failed");
            }
        }
    }

    public void action(Trap trap) {
        MOut.println("");
        this.printPrompt();
        if (Receiver.getInstance().getTrapCollector().getTraps().size() == 1) {
            MOut.print("Info: Use \"trap\" command for detail.");
        }
    }

    public String trapStatusForPrompt() {
        ArrayList traps = Receiver.getInstance().getTrapCollector().getTraps();
        if (traps.size() == 0) {
            return "";
        }
        return " [!Trap(" + traps.size() + ")]";
    }

    public void execute() throws Exception {
        MOut.println("Press Ctrl+D or \"exit\" to exit");
        MOut.println("Press \"?\" or \"help\" for help");
        MOut.println("Press TAB for command completion");
        MOut.println("Press UP and DOWN key for command history");
        this.startTrapReceiver();
        this.newParser();
        ConsoleReader reader = null;
        try {
            reader = new ConsoleReader();
            reader.addCompletor((Completor)this.parser);
            this.setCommandHistory(reader);
        }
        catch (Exception e) {
            MOut.println("Create ConsoleReader fail " + e.toString());
            throw e;
        }
        while (true) {
            String line = null;
            try {
                line = reader.readLine(this.getPrompt());
                MOut.isPrintToScreen = false;
                MOut.println(line);
                MOut.isPrintToScreen = true;
            }
            catch (IOException ex1) {
                // empty catch block
            }
            if (line == null || line.trim().equalsIgnoreCase("exit")) {
                if (Receiver.getInstance().isStart) {
                    Receiver.getInstance().stopReceiver();
                }
                break;
            }
            if (line.trim().equals("/")) {
                this.printCommandHistory();
                continue;
            }
            if (line.trim().startsWith("\\")) {
                line = this.lastCommand(line);
            }
            if (line.trim().equalsIgnoreCase("help") || line.trim().equalsIgnoreCase("?")) {
                this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
                this.printRuntimeAndHelp();
                continue;
            }
            if (line.trim().startsWith("delay")) {
                this.delay(line);
                continue;
            }
            try {
                this.processCommand(line);
            }
            catch (Exception ex) {
                MOut.println(ex.getMessage());
            }
        }
        MOut.println("bye");
        System.exit(0);
        this.statusCode = 0;
    }

    private void delay(String delay) {
        int msdelay;
        StringTokenizer st = new StringTokenizer(delay, " ");
        st.nextToken();
        String ms = st.nextToken();
        if (ms == null) {
            return;
        }
        try {
            msdelay = Integer.parseInt(ms);
        }
        catch (NumberFormatException ex) {
            MOut.println("The parameter must be integer");
            return;
        }
        try {
            Thread.sleep(msdelay);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void setCommandHistory(ConsoleReader reader) throws IOException {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isHistory = ca.getProperty("history");
        if ("on".equalsIgnoreCase(isHistory)) {
            reader.setHistory(new History(new File("SMCIPMITool.history")));
        }
    }

    public void newParser() {
        this.parser = new Parser(true);
        this.parser.loadPlugInCommands();
    }

    public void printPrompt() {
        MOut.print(this.getPrompt());
    }

    public String getPrompt() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        String prompt = guid == null ? ">" : (IPMIMessagingCommand.isCMMGUID(guid) ? "CMM" : (IPMIMessagingCommand.isPepperconGUID(guid) ? "SIM-KVM-IPMI" : (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) ? "SIM-IPMI" : (IPMIMessagingCommand.isSIMBL(guid) ? "SIMBL" : (IPMIMessagingCommand.isOSAGUID(guid) ? "SUPERO-IPMI" : (IPMIMessagingCommand.isAMIGUID(guid) ? "SIM(W)" : (IPMIMessagingCommand.isAMISIMBLGUID(guid) ? "SIMBL(W)" : "IPMI")))))));
        return prompt + this.trapStatusForPrompt() + ">";
    }

    private String lastCommand(String line) {
        int numberInt;
        if (this.commandHistory.size() == 0) {
            return "";
        }
        String numberStr = line.substring(1);
        try {
            numberInt = Integer.parseInt(numberStr);
        }
        catch (NumberFormatException ex1) {
            MOut.println("number parse error!");
            return "";
        }
        this.commandHistoryIndex = numberInt;
        if (this.commandHistoryIndex <= 0) {
            return "";
        }
        if (this.commandHistory.size() - this.commandHistoryIndex < 0) {
            return "";
        }
        line = (String)this.commandHistory.get(this.commandHistory.size() - this.commandHistoryIndex);
        MOut.println(line);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return line;
    }

    private void printRuntimeAndHelp() {
        String usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + "K";
        String freeMemory = Runtime.getRuntime().freeMemory() / 1024L + "K";
        String totalMemory = Runtime.getRuntime().totalMemory() / 1024L + "K";
        String maxMemory = Runtime.getRuntime().maxMemory() / 1024L + "K";
        String maxAvailableMemory = (Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024L + "K";
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        MOut.println("Runtime Info:");
        MOut.printf("%-20s \t %-20s \n", "Host IP", this.config.getIp());
        MOut.printf("%-20s \t %-20s \n", "Username", this.config.getUserName());
        MOut.printf("%-20s \t %-20s \n", "Java Version", System.getProperty("java.vm.version"));
        MOut.printf("%-20s \t %-20s \n", "Used Memory", usedMemory);
        MOut.printf("%-20s \t %-20s \n", "Max Available Memory", maxAvailableMemory);
        MOut.printf("%-20s \t %-20s \n", "Current Time", f.format(Calendar.getInstance().getTime()));
        MOut.printf("%-20s \t %-20s \n", "Time Elapsed", ShellCommand.timeDiff(this.startTime, Calendar.getInstance()));
        if (MOut.isRecord) {
            MOut.printf("%-20s \t %-20s \n", "Record File", MOut.recordFilename);
        }
        MOut.printf("%-20s \t %-20s \n", "Trap Receiver", Receiver.getInstance().isStart ? "Running" : "Stopped");
        MOut.println("");
        MOut.println("Press Ctrl+D or \"exit\" to exit");
        MOut.println("Press \"?\" or \"help\" for help");
        MOut.println("Press TAB for command completion");
        MOut.println("Press UP and DOWN key for command history");
    }

    public static String timeDiff(Calendar c1, Calendar c2) {
        long diffMillis = c2.getTimeInMillis() - c1.getTimeInMillis();
        long diffSecs = diffMillis / 1000L;
        long diffMins = diffMillis / 60000L;
        long diffHours = diffMillis / 3600000L;
        long diffDays = diffMillis / 86400000L;
        long leafHours = diffMillis % 86400000L / 3600000L;
        long leafMins = diffMillis % 86400000L % 3600000L / 60000L;
        return "" + diffDays + "d" + " " + leafHours + "h" + " " + leafMins + "m";
    }

    public void processCommand(String commandLine) {
        if (commandLine.length() == 0) {
            return;
        }
        if (commandLine.trim().equalsIgnoreCase("help") || commandLine.trim().equalsIgnoreCase("?")) {
            this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
            this.printRuntimeAndHelp();
            return;
        }
        if (commandLine.trim().startsWith("delay")) {
            this.delay(commandLine);
            return;
        }
        ArrayList<String> string = new ArrayList<String>();
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            string.add(token);
        }
        String[] args = new String[string.size()];
        string.toArray(args);
        this.parser.argumentRoot.clearValue();
        Command command = this.parser.parse(this.parser.argumentRoot, args);
        if (command == null) {
            return;
        }
        try {
            command.setConfig(this.config);
            command.setOriginalParser(this.parser);
            command.execute();
            MOut.println("");
            this.commandHistory.add(commandLine);
        }
        catch (Exception ex) {
            MOut.println(ex.getMessage());
        }
    }

    public void printCommandHistory() {
        if (this.commandHistory.size() == 0) {
            MOut.println("Command history empty");
            return;
        }
        MOut.println("Command History:");
        for (int i = 0; i < this.commandHistory.size(); ++i) {
            MOut.printf("(%2d) %-20s \t : %s \n", i + 1, "\\" + (i + 1), this.commandHistory.get(this.commandHistory.size() - i - 1));
            if (i == 19) break;
        }
    }

    public static void main(String[] args) {
        String a = "1 2 3 4 \"asdf asd fasdfa sdf\" ";
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(a);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            MOut.println(token);
        }
    }
}

