/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PowerSupplyStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte powerIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (powerIndex < 1 || powerIndex > 4) {
            MOut.println("Power Supply Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryPowerSupplyEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        PowerSupplyEntity ps = bladeSystem.getPowerSupplies()[index - 1];
        if (ps.getPresent() == 0) {
            MOut.println("Power Supply " + index + " is not present");
            this.statusCode = 151;
            return;
        }
        MOut.print(ps.toFormatedHeader());
        MOut.print(ps.toFormatedString());
        this.statusCode = 0;
    }
}

