/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;
import java.util.HashMap;

public class IPMISensorCommand
extends SuperBladeCommand {
    public static final int READING_SAFE = 0;
    public static final int READING_UNSAFE = 1;
    public static final int READING_UNKNOWN = 2;
    StringBuffer formatedString;
    String formatTemplate = "  %-6s | %-24s | %12s | %9s | %10s |\n";
    HashMap ipToSDRs = new HashMap();

    public void runCommand() throws Exception {
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        ArrayList sdrList = null;
        boolean hasSensorData = false;
        MOut.println("Getting SDR data ...");
        if (this.ipToSDRs.get(this.config.getIp()) == null) {
            SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
            if (sdrInfo == null) {
                MOut.println("Get SDR Repository error");
                this.statusCode = 149;
                return;
            }
            sdrList = ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
            this.ipToSDRs.put(this.config.getIp(), sdrList);
        } else {
            sdrList = (ArrayList)this.ipToSDRs.get(this.config.getIp());
        }
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "(#)Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "---------", "-------", "---------", "----------"));
        MOut.println("Getting sensors ...");
        for (SDRRecord item : sdrList) {
            if (item.getSensorType() == 1 || item.getSensorType() == 2 || item.getSensorType() == 4 || item.getSensorType() == -64) {
                int value = 0;
                value = ipmiSDRCommand.getSensorReading(item.getSensorNumber());
                String reading = "";
                String hi = "";
                String low = "";
                block0 : switch (item.getSensorType()) {
                    case 1: {
                        reading = value == -1 ? "n/a" : this.showCandF((int)item.calSensorReading(value & 0xFF));
                        hi = this.showCandF((int)item.getHiLimit());
                        low = this.showCandF((int)item.getLowLimit());
                        break;
                    }
                    case 2: {
                        reading = value == -1 ? "n/a" : item.doubleToString(item.calSensorReading(value & 0xFF)) + " V";
                        hi = item.doubleToString(item.getHiLimit()) + " V";
                        low = item.doubleToString(item.getLowLimit()) + " V";
                        break;
                    }
                    case 4: {
                        reading = value == -1 ? "n/a" : "" + (int)item.calSensorReading(value & 0xFF) + " RPM";
                        hi = "" + (int)item.getHiLimit() + " RPM";
                        low = "" + (int)item.getLowLimit() + " RPM";
                        break;
                    }
                    case -64: {
                        byte[] values = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
                        reading = "n/a";
                        if ((values[1] & 0x20) > 0) {
                            value = 7;
                            break;
                        }
                        value = values[2];
                        if (values == null) break;
                        switch (value) {
                            case 0: {
                                reading = "Low";
                                break block0;
                            }
                            case 1: {
                                reading = "Medium";
                                break block0;
                            }
                            case 2: {
                                reading = "High";
                                break block0;
                            }
                            case 4: {
                                reading = "Overheat";
                                break block0;
                            }
                        }
                        reading = "n/a";
                    }
                }
                this.addRaw(this.checkSensorValue((byte)value, item), this.getSensornameAndNumber(item), reading, low, hi);
                hasSensorData = true;
                continue;
            }
            if (item.getSensorType() != 5 && item.getSensorType() != 8 && item.getSensorType() != 21 && item.getSensorType() != 7) continue;
            byte[] value = ipmiSDRCommand.getFullSensorValue(item.getSensorNumber());
            if (value != null) {
                byte[] guid;
                int status = 0;
                status = value[2] == 0 ? 0 : 1;
                if (item.getSensorType() == 8 && value[2] == 1) {
                    status = 0;
                }
                if (item.getSensorType() == 8 && (guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp())) != null && IPMIMessagingCommand.isOSAGUID(guid)) {
                    status = value[2] == 2 ? 0 : (value[2] == 0 ? 1 : 2);
                }
                this.addRaw(status, this.getSensornameAndNumber(item), ByteUtility.bytesToHex(value), "N/A", "N/A");
            } else {
                this.addRaw(2, this.getSensornameAndNumber(item), "N/A", "N/A", "N/A");
            }
            hasSensorData = true;
        }
        if (!hasSensorData) {
            MOut.println("no sensor data");
        } else {
            MOut.println(this.formatedString.toString());
        }
        this.statusCode = 0;
    }

    private String getSensornameAndNumber(SDRRecord item) {
        String sensorNameAndNumber = "(" + ByteUtility.byteToHex(item.getSensorNumber()) + "h) " + item.getSensorName();
        return sensorNameAndNumber;
    }

    public int checkSensorValue(byte reading, SDRRecord item) {
        if (item.getSensorType() == -64) {
            if (reading == 0 || reading == 1 || reading == 2) {
                return 0;
            }
            if (reading == 4) {
                return 1;
            }
            return 2;
        }
        if (reading == 0) {
            return 2;
        }
        if (reading == -1) {
            return 2;
        }
        double value = item.calSensorReading(reading & 0xFF);
        double hi = item.getHiLimit();
        double low = item.getLowLimit();
        if (value < hi && value > low) {
            return 0;
        }
        return 1;
    }

    protected void addRaw(int checkedResult, String name, String value, String low, String high) {
        String result = null;
        switch (checkedResult) {
            case 0: {
                result = "OK";
                break;
            }
            case 1: {
                result = "Fail";
                break;
            }
            case 2: {
                result = "";
                break;
            }
            default: {
                result = "Unknown";
            }
        }
        this.formatedString.append(String.format(this.formatTemplate, result, name, value, low, high));
    }

    protected String showCandF(int c) {
        if (c == 0) {
            return "n/a";
        }
        long f = Math.round(1.8 * (double)c + 32.0);
        return c + "C/" + f + "F";
    }

    private void faridaWorkAround() {
    }
}

