/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMIPEFCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class IPMILanSNMPCommand
extends SuperBladeCommand {
    public void runCommand() throws Exception {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIPEFCommand ipmiPEFCommand = new IPMIPEFCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        int destCount = ipmiLanCommand.getNumberOfDestination();
        if (this.parameters != null && (this.parameters.length == 2 || this.parameters.length == 3)) {
            byte seq = 0;
            String seqStr = this.parameters[0];
            String ip = this.parameters[1];
            String mac = "00:00:00:00:00:00";
            if (this.parameters.length == 3) {
                mac = this.parameters[2];
            }
            try {
                seq = (byte)Integer.parseInt(seqStr);
            }
            catch (NumberFormatException ex) {
                MOut.println(" destination number format error!");
                this.statusCode = 147;
                return;
            }
            if (seq <= 0 || seq >= destCount) {
                MOut.println("destination number out of range. destiation size = " + destCount);
                this.statusCode = 147;
                return;
            }
            if (!IPMILanCommand.isIPAddress(ip)) {
                MOut.println("IP format error!");
                this.statusCode = 147;
                return;
            }
            if (this.parameters.length == 3 && !IPMILanCommand.isMacAddress(mac)) {
                MOut.println("MAC format error!");
                this.statusCode = 147;
                return;
            }
            byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
            if (guid == null) {
                MOut.println("Unknown GUID");
                this.statusCode = 149;
            }
            byte policyNumber = 0;
            boolean b = false;
            if (IPMIMessagingCommand.isPepperconGUID(guid) || IPMIMessagingCommand.isPepperconNoneKVMGUID(guid) || IPMIMessagingCommand.isCMMGUID(guid) || IPMIMessagingCommand.isNormalBladeCMMGUID(guid) || IPMIMessagingCommand.isSIMBL(guid) || IPMIMessagingCommand.isOSAGUID(guid)) {
                b = this.setPEFforPeppercon(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber);
            } else if (IPMIMessagingCommand.isAMIGUID(guid) || IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
                b = this.setPEFForAMI(ipmiLanCommand, ipmiPEFCommand, seq, ip, mac, policyNumber);
            }
            if (b) {
                MOut.println("Done");
                this.statusCode = 0;
            } else {
                MOut.println("Failed");
                this.statusCode = 149;
            }
            this.printSNMPList(ipmiLanCommand, destCount);
        } else {
            this.printSNMPList(ipmiLanCommand, destCount);
            this.statusCode = 0;
        }
    }

    private boolean setPEFforPeppercon(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = ipmiPEFCommand.setDefaultEventFilterTableEntry((byte)1, policyNumber);
        boolean b2 = ipmiPEFCommand.setDefaultAlertPolicyTableEntry(seq, policyNumber, seq);
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b = b1 && b2 && b3 && b4;
        return b;
    }

    private boolean setPEFForAMI(IPMILanCommand ipmiLanCommand, IPMIPEFCommand ipmiPEFCommand, byte seq, String ip, String mac, byte policyNumber) {
        boolean b1 = true;
        boolean b2 = true;
        for (int i = 1; i <= 4; ++i) {
            if (!ip.equals("0.0.0.0")) {
                boolean isEnable = false;
                byte channel = 0;
                isEnable = true;
                channel = 1;
                b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i), (byte)i, isEnable, channel, seq);
                continue;
            }
            b2 &= ipmiPEFCommand.setAlertPolicyTableEntry((byte)((seq - 1) * 4 + i), (byte)i, false, (byte)0, seq);
        }
        boolean b3 = ipmiLanCommand.setDesitnationIPandMAC(seq, ip, mac);
        boolean b4 = ipmiLanCommand.setDefaultPEFDestinationType(seq);
        boolean b = b1 && b2 && b3 && b4;
        return b;
    }

    private void printSNMPList(IPMILanCommand ipmiLanCommand, int destCount) {
        String format = "%3s %20s %20s \n";
        MOut.printf(format, "Seq", "IP", "MAC");
        MOut.printf(format, "---", "--", "---");
        for (byte i = 1; i <= destCount; i = (byte)(i + 1)) {
            String ip = ipmiLanCommand.getDestinationIP(i);
            String mac = ipmiLanCommand.getDestinationMAC(i);
            MOut.printf(format, i, ip, mac);
        }
    }
}

