/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMNtpCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            MOut.println("CMM Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            MOut.println("This function is only available for the CMM connected");
            this.statusCode = 152;
            return;
        }
        if (this.parameters != null && this.parameters.length >= 2) {
            byte utcOffset = 0;
            String ntp1 = "";
            String ntp2 = "";
            try {
                utcOffset = (byte)Integer.parseInt(this.parameters[0]);
                if (utcOffset < -11 || utcOffset > 12) {
                    MOut.print("UTC Offset out of range (-11 to +12)");
                    this.statusCode = 147;
                    return;
                }
            }
            catch (NumberFormatException ex) {
                MOut.print(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ntp1 = this.parameters[1];
            if (this.parameters.length > 2) {
                ntp2 = this.parameters[2];
            }
            if (this.processNTPServerIfDHCPMode(utcOffset)) {
                this.statusCode = 0;
                return;
            }
            this.writeNTPServer(utcOffset, ntp1, ntp2);
        } else {
            this.printNTPServerList();
            this.statusCode = 0;
        }
    }

    public boolean processNTPServerIfDHCPMode(byte utcOffset) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte type = ipmiLanCommand.getLanSettingType();
        if (type != 2) {
            return false;
        }
        MOut.println("The NTP Server configuration is obtained automatically. For proper");
        MOut.println("fucntion, please make sure that the BOOTP/DHCP server used by");
        MOut.println("this device provides correct time server information.");
        MOut.print("\nSet synchronize with NTP Server...");
        try {
            boolean result = this.ipmiCMMOEMCommand.setNTPMode();
            boolean result2 = this.ipmiCMMOEMCommand.setUTCOffset(utcOffset);
            if (result && result2) {
                MOut.println("Done");
            } else {
                MOut.println("Failed");
            }
        }
        catch (IPMIException ex) {
            MOut.println(ex.toString());
        }
        return true;
    }

    public void writeNTPServer(byte utcOffset, String ntp1, String ntp2) {
        try {
            this.ipmiCMMOEMCommand.setAllNTPServer(utcOffset, ntp1, ntp2);
        }
        catch (IPMIException ex) {
            MOut.println("Set NTP server failed");
            this.statusCode = 149;
            return;
        }
        MOut.println("Done");
        this.statusCode = 0;
    }

    public void printNTPServerList() {
        try {
            String ntp1 = this.ipmiCMMOEMCommand.getNTPServerPrimary();
            String ntp2 = this.ipmiCMMOEMCommand.getNTPServerSecondary();
            MOut.println("Primary NTP Server   :" + ntp1);
            MOut.println("Secondary NTP Server :" + ntp2);
            String usage = "\nUsage: ntp <UTC Offset> <NTP1> [NTP2]\nUTC Offset: -11 to +12\nNTP1: domain name or IP of Primary NTP server\nNTP2: domain name or IP of Secondary NTP server";
            MOut.println(usage);
        }
        catch (IPMIException ex) {
            MOut.println("Command is not available");
        }
    }
}

