/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladeBMCIPMBCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        int maxBladeSize = this.getBladeMaxSize();
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > maxBladeSize) {
            MOut.println("blade Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte[] data;
        byte cmd;
        byte netfn;
        if (!this.isMaster) {
            this.printSlaveCMMUnavailableMessage();
            this.statusCode = 150;
            return;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryBladeEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            MOut.println("Login error!");
            this.statusCode = 146;
            return;
        }
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        BladeEntity bladeEntity = bladeSystem.getBlades()[bladeIndex - 1];
        if (bladeEntity.getPresent() == 0) {
            MOut.println("Blade " + bladeIndex + " is not present");
            this.statusCode = 151;
            return;
        }
        if (!bladeEntity.isSimCardDetectPin()) {
            MOut.println("BMC Not Installed");
            this.statusCode = 149;
            return;
        }
        if (this.parameters == null || this.parameters.length < 2) {
            MOut.println("<netFn> <cmd> [data] parameters required");
            this.statusCode = 147;
            return;
        }
        IPMB ipmb = new IPMB(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmb.setIpmbType(1);
        this.ipmiCMMOEMCommand.setIPMIInterface(ipmb);
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        ipmb.setChannel(index);
        try {
            netfn = (byte)Integer.parseInt(this.parameters[0], 16);
            cmd = (byte)Integer.parseInt(this.parameters[1], 16);
            int dataSize = this.parameters.length - 2;
            data = new byte[dataSize];
            for (int i = 0; i < dataSize; ++i) {
                data[i] = (byte)Integer.parseInt(this.parameters[2 + i], 16);
            }
        }
        catch (NumberFormatException ex) {
            MOut.println(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        netfn = (byte)(netfn << 2);
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        IPMIMessage resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
        if (resMessage != null) {
            MOut.println("Completion code = " + ByteUtility.byteToHex(resMessage.completionCode) + "h");
            if (resMessage.completionCode != 0) {
                MOut.println("(" + GlobalDefine.getCompletionCodeString(resMessage.completionCode) + ")");
            }
            if (resMessage.data != null && resMessage.data.length != 0) {
                MOut.println("Return data = " + ByteUtility.bytesToHex(resMessage.data));
            }
            this.statusCode = 0;
        } else {
            this.statusCode = 149;
        }
    }
}

