/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.FRU;
import com.supermicro.ipmi.IPMIFRUCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForSetFRU
extends Command {
    public Result execute(Host host) {
        FRU fru = null;
        IPMIFRUCommand ipmiFRUCommand = new IPMIFRUCommand(null);
        Result result = new Result(this, host);
        if (!(this.option instanceof FRU)) {
            result.booleanResult = false;
            result.description = "Parameter error";
            return result;
        }
        fru = (FRU)this.option;
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiFRUCommand.setIPMIInterface(rmcp);
        boolean r1 = ipmiFRUCommand.writeFRU(fru);
        if (r1) {
            result.booleanResult = true;
            result.description = "Write FRU OK";
        } else {
            result.booleanResult = false;
            result.description = L.t("group.Write_FRU_failed");
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Write FRU";
    }
}

